/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.jsp.taglib;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.jsp.taglib.TilesBodyTag;
import org.apache.tiles.jsp.taglib.TilesJspException;

public abstract class RoleSecurityTagSupport
extends TilesBodyTag {
    private static final Log LOG = LogFactory.getLog(RoleSecurityTagSupport.class);
    private String role;

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    protected void reset() {
        super.reset();
        this.role = null;
    }

    public int doEndTag() throws TilesJspException {
        try {
            if (this.isAccessAllowed()) {
                this.execute();
            }
        }
        catch (IOException io) {
            String message = "IO Error executing tag: " + io.getMessage();
            LOG.error((Object)message, (Throwable)io);
            throw new TilesJspException(message, io);
        }
        return 6;
    }

    protected abstract void execute() throws TilesJspException, IOException;

    protected boolean isAccessAllowed() {
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        return this.role == null || req.isUserInRole(this.role);
    }
}

