/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaTimeoutException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.FileProcessResult;
import org.apache.tika.utils.ProcessUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UnrarParser
implements Parser {
    private static final long serialVersionUID = 6157727985054451501L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"x-rar-compressed"));
    private long timeoutMillis = 60000L;

    public Set<MediaType> getSupportedTypes(ParseContext arg0) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        EmbeddedDocumentExtractor extractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context);
        Path cwd = Files.createTempDirectory("tika-unrar-", new FileAttribute[0]);
        try {
            Path tmp = Files.createTempFile(cwd, "input", ".rar", new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(tmp, StandardOpenOption.WRITE);){
                IOUtils.copy((InputStream)stream, (OutputStream)os);
            }
            FileProcessResult result = this.unrar(cwd, tmp);
            try {
                Files.delete(tmp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (result.isTimeout()) {
                throw new TikaTimeoutException("timed out unrarring");
            }
            if (result.getExitValue() != 0) {
                if (result.getStderr().contains("error in the encrypted file")) {
                    throw new EncryptedDocumentException();
                }
                String msg = result.getStderr();
                if (msg.length() > 100) {
                    msg = msg.substring(0, 100);
                }
                throw new TikaException("Unrecoverable problem with rar file, exitValue=" + result.getExitValue() + " : " + msg);
            }
            this.processDirectory(cwd, cwd, xhtml, extractor, context);
        }
        finally {
            FileUtils.deleteDirectory((File)cwd.toFile());
        }
        xhtml.endDocument();
    }

    private void processDirectory(Path baseDir, Path path, XHTMLContentHandler xhtml, EmbeddedDocumentExtractor extractor, ParseContext context) throws IOException, SAXException {
        for (File f : path.toFile().listFiles()) {
            if (f.isDirectory()) {
                this.processDirectory(baseDir, f.toPath(), xhtml, extractor, context);
                continue;
            }
            this.processFile(baseDir, f.toPath(), xhtml, extractor, context);
        }
    }

    private void processFile(Path base, Path embeddedFile, XHTMLContentHandler xhtml, EmbeddedDocumentExtractor extractor, ParseContext context) throws IOException, SAXException {
        String relPath = base.relativize(embeddedFile).toString();
        Metadata metadata = new Metadata();
        String fName = FilenameUtils.getName((String)relPath);
        metadata.set("resourceName", fName);
        metadata.set(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, relPath);
        if (extractor.shouldParseEmbedded(metadata)) {
            try (TikaInputStream is = TikaInputStream.get((Path)embeddedFile);){
                extractor.parseEmbedded((InputStream)is, (ContentHandler)xhtml, metadata, true);
            }
        }
    }

    private FileProcessResult unrar(Path cwd, Path tmp) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(cwd.toFile());
        pb.command("unrar", "x", "-kb", "-p-", ProcessUtils.escapeCommandLine((String)tmp.toAbsolutePath().toString()));
        return ProcessUtils.execute((ProcessBuilder)pb, (long)this.timeoutMillis, (int)10000, (int)1000);
    }
}

