/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.V2ExpressionUtils$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.connector.distributions.ClusteredDistribution;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.OrderedDistribution;
import org.apache.spark.sql.connector.distributions.UnspecifiedDistribution;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.write.RequiresDistributionAndOrdering;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class DistributionAndOrderingUtils$ {
    public static DistributionAndOrderingUtils$ MODULE$;

    static {
        new DistributionAndOrderingUtils$();
    }

    public LogicalPlan prepareQuery(Write write, LogicalPlan query, SQLConf conf) {
        LogicalPlan logicalPlan2;
        Write write2 = write;
        if (write2 instanceof RequiresDistributionAndOrdering) {
            LogicalPlan queryWithDistributionAndOrdering;
            LogicalPlan logicalPlan3;
            org.apache.spark.sql.catalyst.expressions.Expression[] expressionArray;
            RequiresDistributionAndOrdering requiresDistributionAndOrdering = (RequiresDistributionAndOrdering)write2;
            int numPartitions = requiresDistributionAndOrdering.requiredNumPartitions();
            Distribution distribution = requiresDistributionAndOrdering.requiredDistribution();
            if (distribution instanceof OrderedDistribution) {
                OrderedDistribution orderedDistribution = (OrderedDistribution)distribution;
                expressionArray = (org.apache.spark.sql.catalyst.expressions.Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])orderedDistribution.ordering())).map((Function1 & Serializable & scala.Serializable)e -> V2ExpressionUtils$.MODULE$.toCatalyst((Expression)e, query), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(org.apache.spark.sql.catalyst.expressions.Expression.class)));
            } else if (distribution instanceof ClusteredDistribution) {
                ClusteredDistribution clusteredDistribution = (ClusteredDistribution)distribution;
                expressionArray = (org.apache.spark.sql.catalyst.expressions.Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clusteredDistribution.clustering())).map((Function1 & Serializable & scala.Serializable)e -> V2ExpressionUtils$.MODULE$.toCatalyst(e, query), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(org.apache.spark.sql.catalyst.expressions.Expression.class)));
            } else if (distribution instanceof UnspecifiedDistribution) {
                expressionArray = (org.apache.spark.sql.catalyst.expressions.Expression[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(org.apache.spark.sql.catalyst.expressions.Expression.class));
            } else {
                throw new MatchError((Object)distribution);
            }
            org.apache.spark.sql.catalyst.expressions.Expression[] distribution2 = expressionArray;
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])distribution2)).nonEmpty()) {
                int finalNumPartitions = numPartitions > 0 ? numPartitions : conf.numShufflePartitions();
                logicalPlan3 = RepartitionByExpression$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])distribution2), query, finalNumPartitions);
            } else {
                if (numPartitions > 0) {
                    throw QueryCompilationErrors$.MODULE$.numberOfPartitionsNotAllowedWithUnspecifiedDistributionError();
                }
                logicalPlan3 = query;
            }
            LogicalPlan queryWithDistribution = logicalPlan3;
            Seq ordering = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiresDistributionAndOrdering.requiredOrdering())).toSeq().map((Function1 & Serializable & scala.Serializable)e -> V2ExpressionUtils$.MODULE$.toCatalyst((Expression)e, query), Seq$.MODULE$.canBuildFrom());
            logicalPlan2 = queryWithDistributionAndOrdering = ordering.nonEmpty() ? new Sort(ordering, false, queryWithDistribution) : queryWithDistribution;
        } else {
            logicalPlan2 = query;
        }
        return logicalPlan2;
    }

    private DistributionAndOrderingUtils$() {
        MODULE$ = this;
    }
}

