/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.IntColumnStats;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.LongColumnStats;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.execution.columnar.compression.Decoder;
import org.apache.spark.sql.execution.columnar.compression.IntDelta$;
import org.apache.spark.sql.execution.columnar.compression.LongDelta$;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegralType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0002\u0004\u0001+!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0003y\u0002B\u0002\u0014\u0001A\u0003%\u0001\u0005C\u0003(\u0001\u0011\u0005\u0001F\u0001\nJ]R,wM]1m\t\u0016dG/Y*vSR,'BA\u0004\t\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\u000b\u0005%Q\u0011\u0001C2pYVlg.\u0019:\u000b\u0005-a\u0011!C3yK\u000e,H/[8o\u0015\tia\"A\u0002tc2T!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001815\ta\"\u0003\u0002\u001a\u001d\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#\u0001\u000f\u0011\u0005u\u0001Q\"\u0001\u0004\u0002\u00139,H\u000e\u001c,bYV,W#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\u0007%sG/\u0001\u0006ok2dg+\u00197vK\u0002\n\u0011\u0003^3ti&sG/Z4sC2$U\r\u001c;b+\tI#\b\u0006\u0003+[M2\u0005CA\u0011,\u0013\ta#E\u0001\u0003V]&$\b\"\u0002\u0018\u0005\u0001\u0004y\u0013aC2pYVlgn\u0015;biN\u0004\"\u0001M\u0019\u000e\u0003!I!A\r\u0005\u0003\u0017\r{G.^7o'R\fGo\u001d\u0005\u0006i\u0011\u0001\r!N\u0001\u000bG>dW/\u001c8UsB,\u0007c\u0001\u00197q%\u0011q\u0007\u0003\u0002\u0011\u001d\u0006$\u0018N^3D_2,XN\u001c+za\u0016\u0004\"!\u000f\u001e\r\u0001\u0011)1\b\u0002b\u0001y\t\t\u0011*\u0005\u0002>\u0001B\u0011\u0011EP\u0005\u0003\u007f\t\u0012qAT8uQ&tw\r\u0005\u0002B\t6\t!I\u0003\u0002D\u0019\u0005)A/\u001f9fg&\u0011QI\u0011\u0002\r\u0013:$Xm\u001a:bYRK\b/\u001a\u0005\u0006\u000f\u0012\u0001\r\u0001S\u0001\u0007g\u000eDW-\\3\u0011\u0005uI\u0015B\u0001&\u0007\u0005E\u0019u.\u001c9sKN\u001c\u0018n\u001c8TG\",W.\u001a")
public class IntegralDeltaSuite
extends SparkFunSuite {
    private final int nullValue;

    public int nullValue() {
        return this.nullValue;
    }

    public <I extends IntegralType> void testIntegralDelta(ColumnStats columnStats, NativeColumnType<I> columnType, CompressionScheme scheme) {
        this.test(new StringBuilder(14).append(scheme).append(": empty column").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeleton$1((Seq)Nil$.MODULE$, columnStats, columnType, scheme), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test(new StringBuilder(13).append(scheme).append(": simple case").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq seq;
            NativeColumnType nativeColumnType = columnType;
            if (INT$.MODULE$.equals(nativeColumnType)) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 2, 130}));
            } else if (LONG$.MODULE$.equals(nativeColumnType)) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L, 1L, 2L, 130L}));
            } else {
                throw new MatchError((Object)nativeColumnType);
            }
            Seq input = seq;
            this.skeleton$1((Seq)input.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2, Seq$.MODULE$.canBuildFrom()), columnStats, columnType, scheme);
        }, new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        this.test(new StringBuilder(20).append(scheme).append(": long random series").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeleton$1((Seq)Seq$.MODULE$.fill(10000, (Function0 & Serializable & scala.Serializable)() -> ColumnarTestUtils$.MODULE$.makeRandomValue(columnType)), columnStats, columnType, scheme), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test(new StringBuilder(31).append(scheme).append(": empty column for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeletonForDecompress$1((Seq)Nil$.MODULE$, columnStats, columnType, scheme), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test(new StringBuilder(30).append(scheme).append(": simple case for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq seq;
            NativeColumnType nativeColumnType = columnType;
            if (INT$.MODULE$.equals(nativeColumnType)) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 2, 130}));
            } else if (LONG$.MODULE$.equals(nativeColumnType)) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L, 1L, 2L, 130L}));
            } else {
                throw new MatchError((Object)nativeColumnType);
            }
            Seq input = seq;
            this.skeletonForDecompress$1((Seq)input.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3, Seq$.MODULE$.canBuildFrom()), columnStats, columnType, scheme);
        }, new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test(new StringBuilder(40).append(scheme).append(": simple case with null for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq seq;
            NativeColumnType nativeColumnType = columnType;
            if (INT$.MODULE$.equals(nativeColumnType)) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 2, this.nullValue(), 5}));
            } else if (LONG$.MODULE$.equals(nativeColumnType)) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L, 1L, 2L, this.nullValue(), 5L}));
            } else {
                throw new MatchError((Object)nativeColumnType);
            }
            Seq input = seq;
            this.skeletonForDecompress$1((Seq)input.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4, Seq$.MODULE$.canBuildFrom()), columnStats, columnType, scheme);
        }, new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ long $anonfun$testIntegralDelta$1(IntegralDeltaSuite $this, Object x0$1, Object x1$1) {
        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
        if (tuple2 != null) {
            Object x = tuple2._1();
            Object y = tuple2._2();
            if (x instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)x);
                if (y instanceof Integer) {
                    int n2 = BoxesRunTime.unboxToInt((Object)y);
                    return n - n2;
                }
            }
        }
        if (tuple2 == null) throw $this.fail(new StringBuilder(17).append("Unexpected input ").append(tuple2).toString(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        Object x = tuple2._1();
        Object y = tuple2._2();
        if (!(x instanceof Long)) throw $this.fail(new StringBuilder(17).append("Unexpected input ").append(tuple2).toString(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        long l = BoxesRunTime.unboxToLong((Object)x);
        if (!(y instanceof Long)) throw $this.fail(new StringBuilder(17).append("Unexpected input ").append(tuple2).toString(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        long l2 = BoxesRunTime.unboxToLong((Object)y);
        return l - l2;
    }

    public static final /* synthetic */ void $anonfun$testIntegralDelta$2(NativeColumnType columnType$1, TestCompressibleColumnBuilder builder$1, Object value) {
        GenericInternalRow row = new GenericInternalRow(1);
        columnType$1.setField((InternalRow)row, 0, value);
        builder$1.appendFrom((InternalRow)row, 0);
    }

    public static final /* synthetic */ Assertion $anonfun$testIntegralDelta$4(IntegralDeltaSuite $this, ByteBuffer buffer$1, NativeColumnType columnType$1, Object value, long delta) {
        Assertion assertion;
        if (package$.MODULE$.abs(delta) <= (long)127) {
            assertion = $this.assertResult(BoxesRunTime.boxToLong((long)delta), "Wrong delta", BoxesRunTime.boxToByte((byte)buffer$1.get()), Prettifier$.MODULE$.default(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        } else {
            $this.assertResult(BoxesRunTime.boxToByte((byte)-128), "Expecting escaping mark here", BoxesRunTime.boxToByte((byte)buffer$1.get()), Prettifier$.MODULE$.default(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            assertion = $this.assertResult(value, "Wrong value", columnType$1.extract(buffer$1), Prettifier$.MODULE$.default(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        }
        return assertion;
    }

    private final void skeleton$1(Seq input, ColumnStats columnStats$1, NativeColumnType columnType$1, CompressionScheme scheme$1) {
        int n;
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, scheme$1);
        Seq deltas = input.isEmpty() ? (Seq)Nil$.MODULE$ : (Seq)Tuple2Zipped$.MODULE$.map$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2(input.tail(), input.init())), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToLong((long)IntegralDeltaSuite.$anonfun$testIntegralDelta$1(this, x0$1, x1$1)), Seq$.MODULE$.canBuildFrom());
        input.foreach((Function1 & Serializable & scala.Serializable)value -> {
            IntegralDeltaSuite.$anonfun$testIntegralDelta$2(columnType$1, builder, value);
            return BoxedUnit.UNIT;
        });
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        if (deltas.isEmpty()) {
            n = 0;
        } else {
            int oneBoolean = columnType$1.defaultSize();
            n = 1 + oneBoolean + BoxesRunTime.unboxToInt((Object)((TraversableOnce)deltas.map((Function1)(JFunction1.mcIJ.sp & Serializable & scala.Serializable)d -> package$.MODULE$.abs(d) <= (long)127 ? 1 : 1 + oneBoolean, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        int compressedSize = 4 + n;
        this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()), Prettifier$.MODULE$.default(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)scheme$1.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        if (input.nonEmpty()) {
            this.assertResult(BoxesRunTime.boxToByte((byte)-128), "The first byte should be an escaping mark", BoxesRunTime.boxToByte((byte)buffer.get()), Prettifier$.MODULE$.default(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            this.assertResult(input.head(), "The first value is wrong", columnType$1.extract(buffer), Prettifier$.MODULE$.default(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            Tuple2Zipped$.MODULE$.foreach$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2(input.tail(), (Object)deltas)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2 & Serializable & scala.Serializable)(value, delta) -> IntegralDeltaSuite.$anonfun$testIntegralDelta$4(this, buffer, columnType$1, value, BoxesRunTime.unboxToLong((Object)delta)));
        }
        buffer.rewind().position(headerSize + 4);
        Decoder decoder = scheme$1.decoder(buffer, columnType$1);
        GenericInternalRow mutableRow = new GenericInternalRow(1);
        if (input.nonEmpty()) {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            input.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                decoder.next((InternalRow)mutableRow, 0);
                return this.assertResult(x$1, "Wrong decoded value", columnType$1.getField((InternalRow)mutableRow, 0), Prettifier$.MODULE$.default(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            });
        }
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }

    public static final /* synthetic */ void $anonfun$testIntegralDelta$6(IntegralDeltaSuite $this, TestCompressibleColumnBuilder builder$2, GenericInternalRow nullRow$1, NativeColumnType columnType$1, GenericInternalRow row$1, Object value) {
        if (BoxesRunTime.equals((Object)value, (Object)BoxesRunTime.boxToInteger((int)$this.nullValue()))) {
            builder$2.appendFrom((InternalRow)nullRow$1, 0);
        } else {
            columnType$1.setField((InternalRow)row$1, 0, value);
            builder$2.appendFrom((InternalRow)row$1, 0);
        }
    }

    private final void skeletonForDecompress$1(Seq input, ColumnStats columnStats$1, NativeColumnType columnType$1, CompressionScheme scheme$1) {
        block0: {
            TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, scheme$1);
            GenericInternalRow row = new GenericInternalRow(1);
            GenericInternalRow nullRow = new GenericInternalRow(1);
            nullRow.setNullAt(0);
            input.foreach((Function1 & Serializable & scala.Serializable)value -> {
                IntegralDeltaSuite.$anonfun$testIntegralDelta$6(this, builder, nullRow, columnType$1, row, value);
                return BoxedUnit.UNIT;
            });
            ByteBuffer buffer = builder.build();
            int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
            buffer.position(headerSize);
            this.assertResult(BoxesRunTime.boxToInteger((int)scheme$1.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            Decoder decoder = scheme$1.decoder(buffer, columnType$1);
            OnHeapColumnVector columnVector = new OnHeapColumnVector(input.length(), (DataType)columnType$1.dataType());
            decoder.decompress((WritableColumnVector)columnVector, input.length());
            if (!input.nonEmpty()) break block0;
            ((IterableLike)input.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Object expected = tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    if (expected instanceof Object) {
                        Object object = expected;
                        int n = index;
                        if (BoxesRunTime.equals((Object)object, (Object)BoxesRunTime.boxToInteger((int)this.nullValue()))) {
                            return this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), new StringBuilder(22).append("Wrong null ").append(n).append("th-position").toString(), BoxesRunTime.boxToBoolean((boolean)columnVector.isNullAt(n)), Prettifier$.MODULE$.default(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
                        }
                    }
                }
                if (tuple2 != null) {
                    Object expected = tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    if (expected instanceof Integer) {
                        int n = BoxesRunTime.unboxToInt((Object)expected);
                        int n2 = index;
                        return this.assertResult(BoxesRunTime.boxToInteger((int)n), new StringBuilder(27).append("Wrong ").append(n2).append("-th decoded int value").toString(), BoxesRunTime.boxToInteger((int)columnVector.getInt(n2)), Prettifier$.MODULE$.default(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
                    }
                }
                if (tuple2 == null) throw this.fail("Unsupported type", new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                Object expected = tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (!(expected instanceof Long)) throw this.fail("Unsupported type", new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                long l = BoxesRunTime.unboxToLong((Object)expected);
                int n = index;
                return this.assertResult(BoxesRunTime.boxToLong((long)l), new StringBuilder(28).append("Wrong ").append(n).append("-th decoded long value").toString(), BoxesRunTime.boxToLong((long)columnVector.getLong(n)), Prettifier$.MODULE$.default(), new Position("IntegralDeltaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            });
        }
    }

    public IntegralDeltaSuite() {
        this.nullValue = -1;
        this.testIntegralDelta((ColumnStats)new IntColumnStats(), (NativeColumnType)INT$.MODULE$, (CompressionScheme)IntDelta$.MODULE$);
        this.testIntegralDelta((ColumnStats)new LongColumnStats(), (NativeColumnType)LONG$.MODULE$, (CompressionScheme)LongDelta$.MODULE$);
    }
}

