/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.execution.columnar.ARRAY;
import org.apache.spark.sql.execution.columnar.BINARY$;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.CALENDAR_INTERVAL$;
import org.apache.spark.sql.execution.columnar.COMPACT_DECIMAL;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.DOUBLE$;
import org.apache.spark.sql.execution.columnar.FLOAT$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.LARGE_DECIMAL;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.MAP;
import org.apache.spark.sql.execution.columnar.NULL$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.STRUCT;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class ColumnarTestUtils$ {
    public static ColumnarTestUtils$ MODULE$;

    static {
        new ColumnarTestUtils$();
    }

    /*
     * WARNING - void declaration
     */
    public GenericInternalRow makeNullRow(int length) {
        void var2_2;
        GenericInternalRow row = new GenericInternalRow(length);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> row.setNullAt(i));
        return var2_2;
    }

    public <JvmType> JvmType makeRandomValue(ColumnType<JvmType> columnType) {
        Object object;
        ColumnType<JvmType> columnType2 = columnType;
        if (NULL$.MODULE$.equals(columnType2)) {
            object = null;
        } else if (BOOLEAN$.MODULE$.equals(columnType2)) {
            object = BoxesRunTime.boxToBoolean((boolean)Random$.MODULE$.nextBoolean());
        } else if (BYTE$.MODULE$.equals(columnType2)) {
            object = BoxesRunTime.boxToByte((byte)((byte)(Random$.MODULE$.nextInt(254) - 127)));
        } else if (SHORT$.MODULE$.equals(columnType2)) {
            object = BoxesRunTime.boxToShort((short)((short)(Random$.MODULE$.nextInt(65534) - Short.MAX_VALUE)));
        } else if (INT$.MODULE$.equals(columnType2)) {
            object = BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt());
        } else if (LONG$.MODULE$.equals(columnType2)) {
            object = BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong());
        } else if (FLOAT$.MODULE$.equals(columnType2)) {
            object = BoxesRunTime.boxToFloat((float)Random$.MODULE$.nextFloat());
        } else if (DOUBLE$.MODULE$.equals(columnType2)) {
            object = BoxesRunTime.boxToDouble((double)Random$.MODULE$.nextDouble());
        } else if (STRING$.MODULE$.equals(columnType2)) {
            object = UTF8String.fromString((String)Random$.MODULE$.nextString(Random$.MODULE$.nextInt(32)));
        } else if (BINARY$.MODULE$.equals(columnType2)) {
            object = ColumnarTestUtils$.randomBytes$1(Random$.MODULE$.nextInt(32));
        } else if (CALENDAR_INTERVAL$.MODULE$.equals(columnType2)) {
            object = new CalendarInterval(Random$.MODULE$.nextInt(), Random$.MODULE$.nextInt(), Random$.MODULE$.nextLong());
        } else if (columnType2 instanceof COMPACT_DECIMAL) {
            COMPACT_DECIMAL cOMPACT_DECIMAL = (COMPACT_DECIMAL)columnType2;
            int precision = cOMPACT_DECIMAL.precision();
            int scale = cOMPACT_DECIMAL.scale();
            object = Decimal$.MODULE$.apply(Random$.MODULE$.nextLong() % 100L, precision, scale);
        } else if (columnType2 instanceof LARGE_DECIMAL) {
            LARGE_DECIMAL lARGE_DECIMAL = (LARGE_DECIMAL)columnType2;
            int precision = lARGE_DECIMAL.precision();
            int scale = lARGE_DECIMAL.scale();
            object = Decimal$.MODULE$.apply(Random$.MODULE$.nextLong(), precision, scale);
        } else if (columnType2 instanceof STRUCT) {
            object = new GenericInternalRow(new Object[]{UTF8String.fromString((String)Random$.MODULE$.nextString(10))});
        } else if (columnType2 instanceof ARRAY) {
            object = new GenericArrayData(new Object[]{BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt()), BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt())});
        } else if (columnType2 instanceof MAP) {
            object = ArrayBasedMapData$.MODULE$.apply((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt())), (Object)UTF8String.fromString((String)Random$.MODULE$.nextString(Random$.MODULE$.nextInt(32))))})), ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3());
        } else {
            throw new IllegalArgumentException(new StringBuilder(20).append("Unknown column type ").append(columnType).toString());
        }
        return (JvmType)object;
    }

    public Seq<Object> makeRandomValues(ColumnType<?> head, Seq<ColumnType<?>> tail) {
        return this.makeRandomValues((Seq)((TraversableLike)new .colon.colon(head, (List)Nil$.MODULE$)).$plus$plus(tail, Seq$.MODULE$.canBuildFrom()));
    }

    public Seq<Object> makeRandomValues(Seq<ColumnType<?>> columnTypes) {
        return (Seq)columnTypes.map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.makeRandomValue((ColumnType)x$1), Seq$.MODULE$.canBuildFrom());
    }

    public <JvmType> Seq<JvmType> makeUniqueRandomValues(ColumnType<JvmType> columnType, int count) {
        return ((SetLike)package$.MODULE$.Iterator().iterate((Object)HashSet$.MODULE$.empty(), (Function1 & Serializable & scala.Serializable)set -> set.$plus(package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> MODULE$.makeRandomValue(columnType)).filterNot((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)set.contains(e))).next())).drop(count).next()).toSeq();
    }

    public InternalRow makeRandomRow(ColumnType<?> head, Seq<ColumnType<?>> tail) {
        return this.makeRandomRow((Seq)((TraversableLike)new .colon.colon(head, (List)Nil$.MODULE$)).$plus$plus(tail, Seq$.MODULE$.canBuildFrom()));
    }

    /*
     * WARNING - void declaration
     */
    public InternalRow makeRandomRow(Seq<ColumnType<?>> columnTypes) {
        void var2_2;
        GenericInternalRow row = new GenericInternalRow(columnTypes.length());
        ((IterableLike)this.makeRandomValues(columnTypes).zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ColumnarTestUtils$.$anonfun$makeRandomRow$1(row, x0$1);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public <T extends AtomicType> Tuple2<Seq<Object>, Seq<GenericInternalRow>> makeUniqueValuesAndSingleValueRows(NativeColumnType<T> columnType, int count) {
        Seq<T> values = this.makeUniqueRandomValues((ColumnType)columnType, count);
        Seq rows = (Seq)values.map((Function1 & Serializable & scala.Serializable)value -> {
            void var1_1;
            GenericInternalRow row = new GenericInternalRow(1);
            row.update(0, value);
            return var1_1;
        }, Seq$.MODULE$.canBuildFrom());
        return new Tuple2(values, (Object)rows);
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] randomBytes$1(int length) {
        void var1_1;
        byte[] bytes = new byte[length];
        Random$.MODULE$.nextBytes(bytes);
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$makeRandomRow$1(GenericInternalRow row$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object value = tuple2._1();
        int index = tuple2._2$mcI$sp();
        row$2.update(index, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private ColumnarTestUtils$() {
        MODULE$ = this;
    }
}

