/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.util.Locale;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class MySQLDialect$
extends JdbcDialect
implements Product {
    public static MySQLDialect$ MODULE$;

    static {
        new MySQLDialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:mysql");
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        Object object;
        if (sqlType == -3 && typeName.equals("BIT") && size != 1) {
            md.putLong("binarylong", 1L);
            object = Option$.MODULE$.apply((Object)LongType$.MODULE$);
        } else {
            object = sqlType == -7 && typeName.equals("TINYINT") ? Option$.MODULE$.apply((Object)BooleanType$.MODULE$) : None$.MODULE$;
        }
        return object;
    }

    @Override
    public String quoteIdentifier(String colName) {
        return new StringBuilder(2).append("`").append(colName).append("`").toString();
    }

    @Override
    public String getTableExistsQuery(String table) {
        return new StringBuilder(22).append("SELECT 1 FROM ").append(table).append(" LIMIT 1").toString();
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(28).append("ALTER TABLE ").append(tableName).append(" MODIFY COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(newDataType).toString();
    }

    @Override
    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        if (dbMajorVersion < 8) {
            throw QueryExecutionErrors$.MODULE$.renameColumnUnsupportedForOlderMySQLError();
        }
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" RENAME COLUMN ").append(this.quoteIdentifier(columnName)).append(" TO").append(" ").append(this.quoteIdentifier(newName)).toString();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        throw QueryExecutionErrors$.MODULE$.unsupportedUpdateColumnNullabilityError();
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        return new StringBuilder(25).append("ALTER TABLE ").append(table).append(" COMMENT = '").append(comment).append("'").toString();
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        Option option = FloatType$.MODULE$.equals(dataType) ? Option$.MODULE$.apply((Object)new JdbcType("FLOAT", 6)) : JdbcUtils$.MODULE$.getCommonJDBCType(dt);
        return option;
    }

    public String productPrefix() {
        return "MySQLDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MySQLDialect$;
    }

    public int hashCode() {
        return 1790277476;
    }

    public String toString() {
        return "MySQLDialect";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MySQLDialect$() {
        MODULE$ = this;
        Product.$init$((Product)this);
    }
}

