/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.metric;

import org.apache.spark.SparkContext;
import org.apache.spark.executor.TempShuffleReadMetrics;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLShuffleReadMetricsReporter$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001\u0002\u0013&\u0001IB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!)q\n\u0001C\u0001!\"1A\u000b\u0001Q\u0001\n-Ca!\u0016\u0001!\u0002\u0013Y\u0005B\u0002,\u0001A\u0003%1\n\u0003\u0004X\u0001\u0001\u0006Ia\u0013\u0005\u00071\u0002\u0001\u000b\u0011B&\t\re\u0003\u0001\u0015!\u0003L\u0011\u0019Q\u0006\u0001)A\u0005\u0017\")1\f\u0001C!9\")a\r\u0001C!O\")\u0011\u000e\u0001C!U\")A\u000e\u0001C![\")q\u000e\u0001C!a\")!\u000f\u0001C!g\")Q\u000f\u0001C!m\u001e)\u00010\nE\u0001s\u001a)A%\nE\u0001u\")qj\u0005C\u0001}\"Aqp\u0005b\u0001\n\u0003\t\t\u0001\u0003\u0005\u0002\u0012M\u0001\u000b\u0011BA\u0002\u0011%\t\u0019b\u0005b\u0001\n\u0003\t\t\u0001\u0003\u0005\u0002\u0016M\u0001\u000b\u0011BA\u0002\u0011%\t9b\u0005b\u0001\n\u0003\t\t\u0001\u0003\u0005\u0002\u001aM\u0001\u000b\u0011BA\u0002\u0011%\tYb\u0005b\u0001\n\u0003\t\t\u0001\u0003\u0005\u0002\u001eM\u0001\u000b\u0011BA\u0002\u0011%\tyb\u0005b\u0001\n\u0003\t\t\u0001\u0003\u0005\u0002\"M\u0001\u000b\u0011BA\u0002\u0011%\t\u0019c\u0005b\u0001\n\u0003\t\t\u0001\u0003\u0005\u0002&M\u0001\u000b\u0011BA\u0002\u0011%\t9c\u0005b\u0001\n\u0003\t\t\u0001\u0003\u0005\u0002*M\u0001\u000b\u0011BA\u0002\u0011\u001d\tYc\u0005C\u0001\u0003[\u0011QdU)M'\",hM\u001a7f%\u0016\fG-T3ue&\u001c7OU3q_J$XM\u001d\u0006\u0003M\u001d\na!\\3ue&\u001c'B\u0001\u0015*\u0003%)\u00070Z2vi&|gN\u0003\u0002+W\u0005\u00191/\u001d7\u000b\u00051j\u0013!B:qCJ\\'B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001gA\u0011AgN\u0007\u0002k)\u0011agK\u0001\tKb,7-\u001e;pe&\u0011\u0001(\u000e\u0002\u0017)\u0016l\u0007o\u00155vM\u001adWMU3bI6+GO]5dg\u0006YA/Z7q\u001b\u0016$(/[2t\u0003\u001diW\r\u001e:jGN\u0004B\u0001P#I\u0017:\u0011Qh\u0011\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001F\na\u0001\u0010:p_Rt$\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b\u0015A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n\u0019Q*\u00199\u000b\u0005\u0011\u000b\u0005C\u0001\u001fJ\u0013\tQuI\u0001\u0004TiJLgn\u001a\t\u0003\u00196k\u0011!J\u0005\u0003\u001d\u0016\u0012\u0011bU)M\u001b\u0016$(/[2\u0002\rqJg.\u001b;?)\r\t&k\u0015\t\u0003\u0019\u0002AQ!O\u0002A\u0002MBQAO\u0002A\u0002m\nAc\u0018:f[>$XM\u00117pG.\u001ch)\u001a;dQ\u0016$\u0017aE0m_\u000e\fGN\u00117pG.\u001ch)\u001a;dQ\u0016$\u0017\u0001E0sK6|G/\u001a\"zi\u0016\u001c(+Z1e\u0003Yy&/Z7pi\u0016\u0014\u0015\u0010^3t%\u0016\fG\rV8ESN\\\u0017aD0m_\u000e\fGNQ=uKN\u0014V-\u00193\u0002\u001d}3W\r^2i/\u0006LG\u000fV5nK\u0006aqL]3d_J$7OU3bI\u00061\u0012N\\2SK6|G/\u001a\"m_\u000e\\7OR3uG\",G\r\u0006\u0002^CB\u0011alX\u0007\u0002\u0003&\u0011\u0001-\u0011\u0002\u0005+:LG\u000fC\u0003c\u0017\u0001\u00071-A\u0001w!\tqF-\u0003\u0002f\u0003\n!Aj\u001c8h\u0003UIgn\u0019'pG\u0006d'\t\\8dWN4U\r^2iK\u0012$\"!\u00185\t\u000b\td\u0001\u0019A2\u0002%%t7MU3n_R,')\u001f;fgJ+\u0017\r\u001a\u000b\u0003;.DQAY\u0007A\u0002\r\f\u0001$\u001b8d%\u0016lw\u000e^3CsR,7OU3bIR{G)[:l)\tif\u000eC\u0003c\u001d\u0001\u00071-A\tj]\u000edunY1m\u0005f$Xm\u001d*fC\u0012$\"!X9\t\u000b\t|\u0001\u0019A2\u0002!%t7MR3uG\"<\u0016-\u001b;US6,GCA/u\u0011\u0015\u0011\u0007\u00031\u0001d\u00039Ign\u0019*fG>\u0014Hm\u001d*fC\u0012$\"!X<\t\u000b\t\f\u0002\u0019A2\u0002;M\u000bFj\u00155vM\u001adWMU3bI6+GO]5dgJ+\u0007o\u001c:uKJ\u0004\"\u0001T\n\u0014\u0005MY\bC\u00010}\u0013\ti\u0018I\u0001\u0004B]f\u0014VM\u001a\u000b\u0002s\u0006)\"+R'P)\u0016{&\tT(D\u0017N{f)\u0012+D\u0011\u0016#UCAA\u0002!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\tA\u0001\\1oO*\u0011\u0011QB\u0001\u0005U\u00064\u0018-C\u0002K\u0003\u000f\taCU#N\u001fR+uL\u0011'P\u0007.\u001bvLR#U\u0007\"+E\tI\u0001\u0015\u0019>\u001b\u0015\tT0C\u0019>\u001b5jU0G\u000bR\u001b\u0005*\u0012#\u0002+1{5)\u0011'`\u00052{5iS*`\r\u0016#6\tS#EA\u0005\t\"+R'P)\u0016{&)\u0017+F'~\u0013V)\u0011#\u0002%I+Uj\u0014+F?\nKF+R*`%\u0016\u000bE\tI\u0001\u001a%\u0016ku\nV#`\u0005f#ViU0S\u000b\u0006#u\fV(`\t&\u001b6*\u0001\u000eS\u000b6{E+R0C3R+5k\u0018*F\u0003\u0012{FkT0E\u0013N[\u0005%\u0001\tM\u001f\u000e\u000bEj\u0018\"Z)\u0016\u001bvLU#B\t\u0006\tBjT\"B\u0019~\u0013\u0015\fV#T?J+\u0015\t\u0012\u0011\u0002\u001f\u0019+Ek\u0011%`/\u0006KEk\u0018+J\u001b\u0016\u000b\u0001CR#U\u0007\"{v+Q%U?RKU*\u0012\u0011\u0002\u0019I+5i\u0014*E'~\u0013V)\u0011#\u0002\u001bI+5i\u0014*E'~\u0013V)\u0011#!\u0003a\u0019'/Z1uKNCWO\u001a4mKJ+\u0017\rZ'fiJL7m\u001d\u000b\u0004w\u0005=\u0002bBA\u0019G\u0001\u0007\u00111G\u0001\u0003g\u000e\u0004B!!\u000e\u000285\t1&C\u0002\u0002:-\u0012Ab\u00159be.\u001cuN\u001c;fqR\u0004")
public class SQLShuffleReadMetricsReporter
extends TempShuffleReadMetrics {
    private final TempShuffleReadMetrics tempMetrics;
    private final SQLMetric _remoteBlocksFetched;
    private final SQLMetric _localBlocksFetched;
    private final SQLMetric _remoteBytesRead;
    private final SQLMetric _remoteBytesReadToDisk;
    private final SQLMetric _localBytesRead;
    private final SQLMetric _fetchWaitTime;
    private final SQLMetric _recordsRead;

    public static Map<String, SQLMetric> createShuffleReadMetrics(SparkContext sparkContext) {
        return SQLShuffleReadMetricsReporter$.MODULE$.createShuffleReadMetrics(sparkContext);
    }

    public static String RECORDS_READ() {
        return SQLShuffleReadMetricsReporter$.MODULE$.RECORDS_READ();
    }

    public static String FETCH_WAIT_TIME() {
        return SQLShuffleReadMetricsReporter$.MODULE$.FETCH_WAIT_TIME();
    }

    public static String LOCAL_BYTES_READ() {
        return SQLShuffleReadMetricsReporter$.MODULE$.LOCAL_BYTES_READ();
    }

    public static String REMOTE_BYTES_READ_TO_DISK() {
        return SQLShuffleReadMetricsReporter$.MODULE$.REMOTE_BYTES_READ_TO_DISK();
    }

    public static String REMOTE_BYTES_READ() {
        return SQLShuffleReadMetricsReporter$.MODULE$.REMOTE_BYTES_READ();
    }

    public static String LOCAL_BLOCKS_FETCHED() {
        return SQLShuffleReadMetricsReporter$.MODULE$.LOCAL_BLOCKS_FETCHED();
    }

    public static String REMOTE_BLOCKS_FETCHED() {
        return SQLShuffleReadMetricsReporter$.MODULE$.REMOTE_BLOCKS_FETCHED();
    }

    public void incRemoteBlocksFetched(long v) {
        this._remoteBlocksFetched.add(v);
        this.tempMetrics.incRemoteBlocksFetched(v);
    }

    public void incLocalBlocksFetched(long v) {
        this._localBlocksFetched.add(v);
        this.tempMetrics.incLocalBlocksFetched(v);
    }

    public void incRemoteBytesRead(long v) {
        this._remoteBytesRead.add(v);
        this.tempMetrics.incRemoteBytesRead(v);
    }

    public void incRemoteBytesReadToDisk(long v) {
        this._remoteBytesReadToDisk.add(v);
        this.tempMetrics.incRemoteBytesReadToDisk(v);
    }

    public void incLocalBytesRead(long v) {
        this._localBytesRead.add(v);
        this.tempMetrics.incLocalBytesRead(v);
    }

    public void incFetchWaitTime(long v) {
        this._fetchWaitTime.add(v);
        this.tempMetrics.incFetchWaitTime(v);
    }

    public void incRecordsRead(long v) {
        this._recordsRead.add(v);
        this.tempMetrics.incRecordsRead(v);
    }

    public SQLShuffleReadMetricsReporter(TempShuffleReadMetrics tempMetrics, Map<String, SQLMetric> metrics) {
        this.tempMetrics = tempMetrics;
        this._remoteBlocksFetched = (SQLMetric)((Object)metrics.apply((Object)SQLShuffleReadMetricsReporter$.MODULE$.REMOTE_BLOCKS_FETCHED()));
        this._localBlocksFetched = (SQLMetric)((Object)metrics.apply((Object)SQLShuffleReadMetricsReporter$.MODULE$.LOCAL_BLOCKS_FETCHED()));
        this._remoteBytesRead = (SQLMetric)((Object)metrics.apply((Object)SQLShuffleReadMetricsReporter$.MODULE$.REMOTE_BYTES_READ()));
        this._remoteBytesReadToDisk = (SQLMetric)((Object)metrics.apply((Object)SQLShuffleReadMetricsReporter$.MODULE$.REMOTE_BYTES_READ_TO_DISK()));
        this._localBytesRead = (SQLMetric)((Object)metrics.apply((Object)SQLShuffleReadMetricsReporter$.MODULE$.LOCAL_BYTES_READ()));
        this._fetchWaitTime = (SQLMetric)((Object)metrics.apply((Object)SQLShuffleReadMetricsReporter$.MODULE$.FETCH_WAIT_TIME()));
        this._recordsRead = (SQLMetric)((Object)metrics.apply((Object)SQLShuffleReadMetricsReporter$.MODULE$.RECORDS_READ()));
    }
}

