/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.ui;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.ui.StreamingQueryUIData;
import org.apache.spark.sql.streaming.ui.UIUtils$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y4Qa\u0004\t\u0001)qA\u0001\"\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\u0006O\u0001!\t\u0001\u000b\u0005\tY\u0001\u0011\r\u0011\"\u0001\u0011[!1q\b\u0001Q\u0001\n9B\u0001\u0002\u0011\u0001C\u0002\u0013\u0005\u0001#\u0011\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002\"\t\u000f5\u0003!\u0019!C\u0005\u001d\"11\u000b\u0001Q\u0001\n=Cq\u0001\u0016\u0001C\u0002\u0013%a\n\u0003\u0004V\u0001\u0001\u0006Ia\u0014\u0005\u0006-\u0002!\te\u0016\u0005\u0006I\u0002!\t%\u001a\u0005\u0006U\u0002!\te\u001b\u0005\u0006a\u0002!\t!\u001d\u0002\u001d'R\u0014X-Y7j]\u001e\fV/\u001a:z'R\fG/^:MSN$XM\\3s\u0015\t\t\"#\u0001\u0002vS*\u00111\u0003F\u0001\ngR\u0014X-Y7j]\u001eT!!\u0006\f\u0002\u0007M\fHN\u0003\u0002\u00181\u0005)1\u000f]1sW*\u0011\u0011DG\u0001\u0007CB\f7\r[3\u000b\u0003m\t1a\u001c:h'\t\u0001Q\u0004\u0005\u0002\u001f?5\t!#\u0003\u0002!%\t12\u000b\u001e:fC6LgnZ)vKJLH*[:uK:,'/\u0001\u0003d_:47\u0001\u0001\t\u0003I\u0015j\u0011AF\u0005\u0003MY\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\rqJg.\u001b;?)\tI3\u0006\u0005\u0002+\u00015\t\u0001\u0003C\u0003\"\u0005\u0001\u00071%A\tbGRLg/Z)vKJL8\u000b^1ukN,\u0012A\f\t\u0005_YBD(D\u00011\u0015\t\t$'\u0001\u0006d_:\u001cWO\u001d:f]RT!a\r\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0002k\u0005!!.\u0019<b\u0013\t9\u0004GA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"!\u000f\u001e\u000e\u0003IJ!a\u000f\u001a\u0003\tU+\u0016\n\u0012\t\u0003UuJ!A\u0010\t\u0003)M#(/Z1nS:<\u0017+^3ssVKE)\u0019;b\u0003I\t7\r^5wKF+XM]=Ti\u0006$Xo\u001d\u0011\u0002'%t\u0017m\u0019;jm\u0016\fV/\u001a:z'R\fG/^:\u0016\u0003\t\u00032a\u0011&=\u001b\u0005!%BA#G\u0003\u001diW\u000f^1cY\u0016T!a\u0012%\u0002\u0015\r|G\u000e\\3di&|gNC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tYEIA\u0003Rk\u0016,X-\u0001\u000bj]\u0006\u001cG/\u001b<f#V,'/_*uCR,8\u000fI\u0001\u001bgR\u0014X-Y7j]\u001e\u0004&o\\4sKN\u001c(+\u001a;f]RLwN\\\u000b\u0002\u001fB\u0011\u0001+U\u0007\u0002\u0011&\u0011!\u000b\u0013\u0002\u0004\u0013:$\u0018aG:ue\u0016\fW.\u001b8h!J|wM]3tgJ+G/\u001a8uS>t\u0007%\u0001\u000fj]\u0006\u001cG/\u001b<f#V,'/_*uCR,8OU3uK:$\u0018n\u001c8\u0002;%t\u0017m\u0019;jm\u0016\fV/\u001a:z'R\fG/^:SKR,g\u000e^5p]\u0002\nab\u001c8Rk\u0016\u0014\u0018p\u0015;beR,G\r\u0006\u0002Y7B\u0011\u0001+W\u0005\u00035\"\u0013A!\u00168ji\")Al\u0003a\u0001;\u0006)QM^3oiB\u0011a,\u0019\b\u0003=}K!\u0001\u0019\n\u0002-M#(/Z1nS:<\u0017+^3ss2K7\u000f^3oKJL!AY2\u0003#E+XM]=Ti\u0006\u0014H/\u001a3Fm\u0016tGO\u0003\u0002a%\u0005yqN\\)vKJL\bK]8he\u0016\u001c8\u000f\u0006\u0002YM\")A\f\u0004a\u0001OB\u0011a\f[\u0005\u0003S\u000e\u0014!#U;fef\u0004&o\\4sKN\u001cXI^3oi\u0006\trN\\)vKJLH+\u001a:nS:\fG/\u001a3\u0015\u0005ac\u0007\"\u0002/\u000e\u0001\u0004i\u0007C\u00010o\u0013\ty7M\u0001\u000bRk\u0016\u0014\u0018\u0010V3s[&t\u0017\r^3e\u000bZ,g\u000e^\u0001\u000fC2d\u0017+^3ssN#\u0018\r^;t+\u0005\u0011\bcA:|y9\u0011A/\u001f\b\u0003kbl\u0011A\u001e\u0006\u0003o\n\na\u0001\u0010:p_Rt\u0014\"A%\n\u0005iD\u0015a\u00029bG.\fw-Z\u0005\u0003yv\u00141aU3r\u0015\tQ\b\n")
public class StreamingQueryStatusListener
extends StreamingQueryListener {
    private final ConcurrentHashMap<UUID, StreamingQueryUIData> activeQueryStatus = new ConcurrentHashMap();
    private final Queue<StreamingQueryUIData> inactiveQueryStatus = new Queue();
    private final int streamingProgressRetention;
    private final int inactiveQueryStatusRetention;

    public ConcurrentHashMap<UUID, StreamingQueryUIData> activeQueryStatus() {
        return this.activeQueryStatus;
    }

    public Queue<StreamingQueryUIData> inactiveQueryStatus() {
        return this.inactiveQueryStatus;
    }

    private int streamingProgressRetention() {
        return this.streamingProgressRetention;
    }

    private int inactiveQueryStatusRetention() {
        return this.inactiveQueryStatusRetention;
    }

    @Override
    public void onQueryStarted(StreamingQueryListener.QueryStartedEvent event) {
        long startTimestamp = UIUtils$.MODULE$.parseProgressTimestamp(event.timestamp());
        this.activeQueryStatus().putIfAbsent(event.runId(), new StreamingQueryUIData(event.name(), event.id(), event.runId(), startTimestamp));
    }

    @Override
    public void onQueryProgress(StreamingQueryListener.QueryProgressEvent event) {
        long batchTimestamp = UIUtils$.MODULE$.parseProgressTimestamp(event.progress().timestamp());
        StreamingQueryUIData queryStatus = this.activeQueryStatus().getOrDefault(event.progress().runId(), new StreamingQueryUIData(event.progress().name(), event.progress().id(), event.progress().runId(), batchTimestamp));
        queryStatus.updateProcess(event.progress(), this.streamingProgressRetention());
    }

    @Override
    public synchronized void onQueryTerminated(StreamingQueryListener.QueryTerminatedEvent event) {
        StreamingQueryUIData queryStatus = this.activeQueryStatus().remove(event.runId());
        if (queryStatus != null) {
            queryStatus.queryTerminated(event);
            this.inactiveQueryStatus().$plus$eq((Object)queryStatus);
            while (this.inactiveQueryStatus().length() >= this.inactiveQueryStatusRetention()) {
                this.inactiveQueryStatus().dequeue();
            }
        }
    }

    public synchronized Seq<StreamingQueryUIData> allQueryStatus() {
        return (Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.activeQueryStatus().values()).asScala()).toSeq().$plus$plus(this.inactiveQueryStatus(), Seq$.MODULE$.canBuildFrom());
    }

    public StreamingQueryStatusListener(SparkConf conf) {
        this.streamingProgressRetention = BoxesRunTime.unboxToInt((Object)conf.get(StaticSQLConf$.MODULE$.STREAMING_UI_RETAINED_PROGRESS_UPDATES()));
        this.inactiveQueryStatusRetention = BoxesRunTime.unboxToInt((Object)conf.get(StaticSQLConf$.MODULE$.STREAMING_UI_RETAINED_QUERIES()));
    }
}

