/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.python;

import java.io.Serializable;
import org.apache.spark.api.python.PythonEvalType$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.PythonUDF;
import org.apache.spark.sql.catalyst.expressions.PythonUDF$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.ArrowEvalPython;
import org.apache.spark.sql.catalyst.plans.logical.BatchEvalPython;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Subquery;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.sys.package$;

public final class ExtractPythonUDFs$
extends Rule<LogicalPlan>
implements PredicateHelper {
    public static ExtractPythonUDFs$ MODULE$;

    static {
        new ExtractPythonUDFs$();
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    private boolean hasScalarPythonUDF(Expression e2) {
        return e2.find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)PythonUDF$.MODULE$.isScalarPythonUDF(e))).isDefined();
    }

    private boolean canEvaluateInPython(PythonUDF e2) {
        boolean bl;
        block2: {
            Expression u;
            Seq seq;
            Some some;
            while (!(some = Seq$.MODULE$.unapplySeq(seq = e2.children())).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (u = (Expression)((SeqLike)some.get()).apply(0)) instanceof PythonUDF) {
                PythonUDF pythonUDF = (PythonUDF)u;
                if (e2.evalType() == pythonUDF.evalType()) {
                    e2 = pythonUDF;
                    continue;
                }
                bl = false;
                break block2;
            }
            bl = !seq.exists((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ExtractPythonUDFs$.MODULE$.hasScalarPythonUDF(e)));
        }
        return bl;
    }

    private Seq<PythonUDF> collectEvaluableUDFsFromExpressions(Seq<Expression> expressions) {
        ObjectRef firstVisitedScalarUDFEvalType = ObjectRef.create((Object)None$.MODULE$);
        return (Seq)expressions.flatMap((Function1 & Serializable & scala.Serializable)expr -> this.collectEvaluableUDFs$1((Expression)expr, firstVisitedScalarUDFEvalType), Seq$.MODULE$.canBuildFrom());
    }

    public LogicalPlan apply(LogicalPlan plan) {
        Subquery subquery;
        LogicalPlan logicalPlan2 = plan;
        LogicalPlan logicalPlan3 = logicalPlan2 instanceof Subquery && (subquery = (Subquery)logicalPlan2).correlated() ? plan : plan.transformUp((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof BatchEvalPython) {
                    BatchEvalPython batchEvalPython;
                    object = batchEvalPython = (BatchEvalPython)A1;
                } else if (A1 instanceof ArrowEvalPython) {
                    ArrowEvalPython arrowEvalPython = (ArrowEvalPython)A1;
                    object = arrowEvalPython;
                } else if (A1 != null) {
                    A1 A12 = A1;
                    object = ExtractPythonUDFs$.MODULE$.org$apache$spark$sql$execution$python$ExtractPythonUDFs$$extract(A12);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof BatchEvalPython ? true : (logicalPlan2 instanceof ArrowEvalPython ? true : logicalPlan2 != null);
                return bl;
            }
        });
        return logicalPlan3;
    }

    public LogicalPlan org$apache$spark$sql$execution$python$ExtractPythonUDFs$$extract(LogicalPlan plan) {
        Object object;
        Seq udfs = (Seq)this.collectEvaluableUDFsFromExpressions((Seq<Expression>)plan.expressions()).filter((Function1 & Serializable & scala.Serializable)udf -> BoxesRunTime.boxToBoolean((boolean)ExtractPythonUDFs$.$anonfun$extract$4(plan, udf)));
        if (udfs.isEmpty()) {
            object = plan;
        } else {
            HashMap attributeMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            Seq newChildren = (Seq)plan.children().map((Function1 & Serializable & scala.Serializable)child -> {
                LogicalPlan logicalPlan2;
                Seq validUdfs = (Seq)udfs.filter((Function1 & Serializable & scala.Serializable)udf -> BoxesRunTime.boxToBoolean((boolean)ExtractPythonUDFs$.$anonfun$extract$6(child, udf)));
                if (validUdfs.nonEmpty()) {
                    BatchEvalPython batchEvalPython;
                    int evalType;
                    Predef$.MODULE$.require(validUdfs.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)PythonUDF$.MODULE$.isScalarPythonUDF(e))), (Function0 & Serializable & scala.Serializable)() -> "Can only extract scalar vectorized udf or sql batch udf");
                    Seq resultAttrs = (Seq)((TraversableLike)validUdfs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        PythonUDF u = (PythonUDF)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        String x$1 = new StringBuilder(9).append("pythonUDF").append(i).toString();
                        DataType x$2 = u.dataType();
                        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                        AttributeReference attributeReference = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                        return attributeReference;
                    }, Seq$.MODULE$.canBuildFrom());
                    Set evalTypes = ((TraversableOnce)validUdfs.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.evalType()), Seq$.MODULE$.canBuildFrom())).toSet();
                    if (evalTypes.size() != 1) {
                        throw new AnalysisException(new StringBuilder(66).append("Expected udfs have the same evalType but got different evalTypes: ").append(evalTypes.mkString(",")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    int n = evalType = BoxesRunTime.unboxToInt((Object)evalTypes.head());
                    if (PythonEvalType$.MODULE$.SQL_BATCHED_UDF() == n) {
                        batchEvalPython = new BatchEvalPython(validUdfs, resultAttrs, child);
                    } else {
                        boolean bl = PythonEvalType$.MODULE$.SQL_SCALAR_PANDAS_UDF() == n ? true : PythonEvalType$.MODULE$.SQL_SCALAR_PANDAS_ITER_UDF() == n;
                        if (bl) {
                            batchEvalPython = new ArrowEvalPython(validUdfs, resultAttrs, child, evalType);
                        } else {
                            throw new AnalysisException("Unexcepted UDF evalType", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                        }
                    }
                    BatchEvalPython evaluation = batchEvalPython;
                    attributeMap.$plus$plus$eq((TraversableOnce)validUdfs.zip((GenIterable)resultAttrs, Seq$.MODULE$.canBuildFrom()));
                    logicalPlan2 = (LogicalPlan)evaluation;
                } else {
                    logicalPlan2 = child;
                }
                return logicalPlan2;
            }, Seq$.MODULE$.canBuildFrom());
            ((IterableLike)udfs.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)attributeMap.contains((Object)key)))).foreach((Function1 & Serializable & scala.Serializable)udf -> package$.MODULE$.error(new StringBuilder(65).append("Invalid PythonUDF ").append(udf).append(", requires attributes from more than one child.").toString()));
            LogicalPlan rewritten = (LogicalPlan)((QueryPlan)plan.withNewChildren(newChildren)).transformExpressions((PartialFunction)new scala.Serializable(attributeMap){
                public static final long serialVersionUID = 0L;
                private final HashMap attributeMap$2;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    PythonUDF pythonUDF;
                    A1 A1 = x1;
                    Object object = A1 instanceof PythonUDF && this.attributeMap$2.contains((Object)(pythonUDF = (PythonUDF)A1)) ? this.attributeMap$2.apply((Object)pythonUDF) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Expression x1) {
                    PythonUDF pythonUDF;
                    Expression expression = x1;
                    boolean bl = expression instanceof PythonUDF && this.attributeMap$2.contains((Object)(pythonUDF = (PythonUDF)expression));
                    return bl;
                }
                {
                    this.attributeMap$2 = attributeMap$2;
                }
            });
            LogicalPlan newPlan = this.org$apache$spark$sql$execution$python$ExtractPythonUDFs$$extract(rewritten);
            Seq seq = newPlan.output();
            Seq seq2 = plan.output();
            object = (seq == null ? seq2 != null : !seq.equals(seq2)) ? new Project(plan.output(), newPlan) : newPlan;
        }
        return object;
    }

    private static final boolean canChainUDF$1(int evalType, ObjectRef firstVisitedScalarUDFEvalType$1) {
        return evalType == PythonEvalType$.MODULE$.SQL_SCALAR_PANDAS_ITER_UDF() ? false : evalType == BoxesRunTime.unboxToInt((Object)((Option)firstVisitedScalarUDFEvalType$1.elem).get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Seq collectEvaluableUDFs$1(Expression expr2, ObjectRef firstVisitedScalarUDFEvalType$1) {
        boolean bl = false;
        PythonUDF pythonUDF = null;
        Expression expression = expr2;
        if (expression instanceof PythonUDF) {
            bl = true;
            pythonUDF = (PythonUDF)expression;
            if (PythonUDF$.MODULE$.isScalarPythonUDF((Expression)pythonUDF) && this.canEvaluateInPython(pythonUDF) && ((Option)firstVisitedScalarUDFEvalType$1.elem).isEmpty()) {
                firstVisitedScalarUDFEvalType$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)pythonUDF.evalType()));
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PythonUDF[]{pythonUDF}));
            }
        }
        if (!bl) return (Seq)expression.children().flatMap((Function1 & Serializable & scala.Serializable)expr -> this.collectEvaluableUDFs$1((Expression)expr, firstVisitedScalarUDFEvalType$1), Seq$.MODULE$.canBuildFrom());
        if (!PythonUDF$.MODULE$.isScalarPythonUDF((Expression)pythonUDF)) return (Seq)expression.children().flatMap((Function1 & Serializable & scala.Serializable)expr -> this.collectEvaluableUDFs$1((Expression)expr, firstVisitedScalarUDFEvalType$1), Seq$.MODULE$.canBuildFrom());
        if (!this.canEvaluateInPython(pythonUDF)) return (Seq)expression.children().flatMap((Function1 & Serializable & scala.Serializable)expr -> this.collectEvaluableUDFs$1((Expression)expr, firstVisitedScalarUDFEvalType$1), Seq$.MODULE$.canBuildFrom());
        if (!ExtractPythonUDFs$.canChainUDF$1(pythonUDF.evalType(), firstVisitedScalarUDFEvalType$1)) return (Seq)expression.children().flatMap((Function1 & Serializable & scala.Serializable)expr -> this.collectEvaluableUDFs$1((Expression)expr, firstVisitedScalarUDFEvalType$1), Seq$.MODULE$.canBuildFrom());
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PythonUDF[]{pythonUDF}));
    }

    public static final /* synthetic */ boolean $anonfun$extract$4(LogicalPlan plan$1, PythonUDF udf) {
        return udf.references().subsetOf(plan$1.inputSet());
    }

    public static final /* synthetic */ boolean $anonfun$extract$6(LogicalPlan child$1, PythonUDF udf) {
        return udf.references().subsetOf(child$1.outputSet());
    }

    private ExtractPythonUDFs$() {
        MODULE$ = this;
        PredicateHelper.$init$((PredicateHelper)this);
    }
}

