/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker$;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.WriteJobDescription;
import org.apache.spark.sql.execution.datasources.WriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.v2.FileBatchWrite;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.sql.util.SchemaUtils$;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%e!B\t\u0013\u0003\u0003\t\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0011%\u0003!\u0011!Q\u0001\n\u0005C\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t1\u0002\u0011\t\u0011)A\u00053\")A\f\u0001C\u0001;\"9A\r\u0001b\u0001\n\u0013)\u0007BB5\u0001A\u0003%a\rC\u0004k\u0001\t\u0007I\u0011B6\t\r9\u0004\u0001\u0015!\u0003m\u0011\u001dy\u0007A1A\u0005\nADaa\u001e\u0001!\u0002\u0013\t\b\"\u0002=\u0001\t\u0003J\b\"B?\u0001\r\u0003q\bbBA\u001c\u0001\u0011%\u0011\u0011\b\u0005\b\u0003\u000b\u0002A\u0011BA$\u0011\u001d\tI\u0007\u0001C\u0005\u0003W\u0012\u0001CR5mK^\u0013\u0018\u000e^3Ck&dG-\u001a:\u000b\u0005M!\u0012A\u0001<3\u0015\t)b#A\u0006eCR\f7o\\;sG\u0016\u001c(BA\f\u0019\u0003%)\u00070Z2vi&|gN\u0003\u0002\u001a5\u0005\u00191/\u001d7\u000b\u0005ma\u0012!B:qCJ\\'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001E)\u0002\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\t1\fgn\u001a\u0006\u0002O\u0005!!.\u0019<b\u0013\tICE\u0001\u0004PE*,7\r\u001e\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\nQa\u001e:ji\u0016T!a\f\r\u0002\u0013\r|gN\\3di>\u0014\u0018BA\u0019-\u000519&/\u001b;f\u0005VLG\u000eZ3s\u0003\u0015\u0001\u0018\r\u001e5t!\r!d(\u0011\b\u0003kmr!AN\u001d\u000e\u0003]R!\u0001\u000f\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f>\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011AO\u0005\u0003\u007f\u0001\u00131aU3r\u0015\taT\b\u0005\u0002C\r:\u00111\t\u0012\t\u0003muJ!!R\u001f\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000bv\n!BZ8s[\u0006$h*Y7f\u0003A\u0019X\u000f\u001d9peR\u001cH)\u0019;b)f\u0004X\r\u0005\u0003M\u001b>+V\"A\u001f\n\u00059k$!\u0003$v]\u000e$\u0018n\u001c82!\t\u00016+D\u0001R\u0015\t\u0011\u0006$A\u0003usB,7/\u0003\u0002U#\nAA)\u0019;b)f\u0004X\r\u0005\u0002M-&\u0011q+\u0010\u0002\b\u0005>|G.Z1o\u0003\u0011IgNZ8\u0011\u0005-R\u0016BA.-\u0005AaunZ5dC2<&/\u001b;f\u0013:4w.\u0001\u0004=S:LGO\u0010\u000b\u0006=\u0002\f'm\u0019\t\u0003?\u0002i\u0011A\u0005\u0005\u0006e\u0015\u0001\ra\r\u0005\u0006\u0013\u0016\u0001\r!\u0011\u0005\u0006\u0015\u0016\u0001\ra\u0013\u0005\u00061\u0016\u0001\r!W\u0001\u0007g\u000eDW-\\1\u0016\u0003\u0019\u0004\"\u0001U4\n\u0005!\f&AC*ueV\u001cG\u000fV=qK\u000691o\u00195f[\u0006\u0004\u0013aB9vKJL\u0018\nZ\u000b\u0002YB\u00111%\\\u0005\u0003\u000f\u0012\n\u0001\"];fefLE\rI\u0001\b_B$\u0018n\u001c8t+\u0005\t\bC\u0001:v\u001b\u0005\u0019(B\u0001;\u0019\u0003\u0011)H/\u001b7\n\u0005Y\u001c(\u0001G\"bg\u0016Len]3og&$\u0018N^3TiJLgnZ'ba\u0006Aq\u000e\u001d;j_:\u001c\b%A\u0007ck&dGMR8s\u0005\u0006$8\r\u001b\u000b\u0002uB\u00111f_\u0005\u0003y2\u0012!BQ1uG\"<&/\u001b;f\u00031\u0001(/\u001a9be\u0016<&/\u001b;f)%y\u0018qAA\f\u0003W\t\u0019\u0004\u0005\u0003\u0002\u0002\u0005\rQ\"\u0001\u000b\n\u0007\u0005\u0015ACA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010C\u0004\u0002\n5\u0001\r!a\u0003\u0002\u000fM\fHnQ8oMB!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012a\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0003+\tyAA\u0004T#2\u001buN\u001c4\t\u000f\u0005eQ\u00021\u0001\u0002\u001c\u0005\u0019!n\u001c2\u0011\t\u0005u\u0011qE\u0007\u0003\u0003?QA!!\t\u0002$\u0005IQ.\u00199sK\u0012,8-\u001a\u0006\u0004\u0003Ka\u0012A\u00025bI>|\u0007/\u0003\u0003\u0002*\u0005}!a\u0001&pE\"1q.\u0004a\u0001\u0003[\u0001RAQA\u0018\u0003\u0006K1!!\rI\u0005\ri\u0015\r\u001d\u0005\u0007\u0003ki\u0001\u0019\u00014\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017-\u0001\bwC2LG-\u0019;f\u0013:\u0004X\u000f^:\u0015\t\u0005m\u0012\u0011\t\t\u0004\u0019\u0006u\u0012bAA {\t!QK\\5u\u0011\u0019\t\u0019E\u0004a\u0001+\u0006)2-Y:f'\u0016t7/\u001b;jm\u0016\fe.\u00197zg&\u001c\u0018AD4fi*{'-\u00138ti\u0006t7-\u001a\u000b\u0007\u00037\tI%!\u0017\t\u000f\u0005-s\u00021\u0001\u0002N\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#RA!a\u0015\u0002$\u0005!1m\u001c8g\u0013\u0011\t9&!\u0015\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\tYf\u0004a\u0001\u0003;\nA\u0001]1uQB!\u0011qLA3\u001b\t\t\tG\u0003\u0003\u0002d\u0005\r\u0012A\u00014t\u0013\u0011\t9'!\u0019\u0003\tA\u000bG\u000f[\u0001\u001aGJ,\u0017\r^3Xe&$XMS8c\t\u0016\u001c8M]5qi&|g\u000e\u0006\u0007\u0002n\u0005M\u0014qPAA\u0003\u0007\u000b9\t\u0005\u0003\u0002\u0002\u0005=\u0014bAA9)\t\u0019rK]5uK*{'\rR3tGJL\u0007\u000f^5p]\"9\u0011Q\u000f\tA\u0002\u0005]\u0014\u0001D:qCJ\\7+Z:tS>t\u0007\u0003BA=\u0003wj\u0011\u0001G\u0005\u0004\u0003{B\"\u0001D*qCJ\\7+Z:tS>t\u0007bBA&!\u0001\u0007\u0011Q\n\u0005\b\u00033\u0001\u0002\u0019AA\u000e\u0011\u0019\t)\t\u0005a\u0001\u0003\u0006A\u0001/\u0019;i\u001d\u0006lW\r\u0003\u0004p!\u0001\u0007\u0011Q\u0006")
public abstract class FileWriteBuilder
implements WriteBuilder {
    private final Seq<String> paths;
    private final String formatName;
    private final Function1<DataType, Object> supportsDataType;
    private final StructType schema;
    private final String queryId;
    private final CaseInsensitiveStringMap options;

    public StreamingWrite buildForStreaming() {
        return super.buildForStreaming();
    }

    private StructType schema() {
        return this.schema;
    }

    private String queryId() {
        return this.queryId;
    }

    private CaseInsensitiveStringMap options() {
        return this.options;
    }

    public BatchWrite buildForBatch() {
        LazyRef description$lzy = new LazyRef();
        SparkSession sparkSession = SparkSession$.MODULE$.active();
        this.validateInputs(sparkSession.sessionState().conf().caseSensitiveAnalysis());
        Path path = new Path((String)this.paths.head());
        scala.collection.immutable.Map caseSensitiveMap = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.options().asCaseSensitiveMap()).asScala()).toMap(Predef$.MODULE$.$conforms());
        Configuration hadoopConf = sparkSession.sessionState().newHadoopConfWithOptions((scala.collection.immutable.Map<String, String>)caseSensitiveMap);
        Job job = this.getJobInstance(hadoopConf, path);
        FileCommitProtocol committer = FileCommitProtocol$.MODULE$.instantiate(sparkSession.sessionState().conf().fileCommitProtocolClass(), UUID.randomUUID().toString(), (String)this.paths.head(), FileCommitProtocol$.MODULE$.instantiate$default$4());
        committer.setupJob((JobContext)job);
        return new FileBatchWrite(job, this.description$1(description$lzy, sparkSession, hadoopConf, job), committer);
    }

    public abstract OutputWriterFactory prepareWrite(SQLConf var1, Job var2, scala.collection.immutable.Map<String, String> var3, StructType var4);

    private void validateInputs(boolean caseSensitiveAnalysis) {
        Predef$.MODULE$.assert(this.schema() != null, (Function0 & Serializable & scala.Serializable)() -> "Missing input data schema");
        Predef$.MODULE$.assert(this.queryId() != null, (Function0 & Serializable & scala.Serializable)() -> "Missing query ID");
        if (this.paths.length() != 1) {
            throw new IllegalArgumentException(new StringBuilder(52).append("Expected exactly one path to be specified, but ").append("got: ").append(this.paths.mkString(", ")).toString());
        }
        String pathName = (String)this.paths.head();
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.schema().fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), new StringBuilder(20).append("when inserting into ").append(pathName).toString(), caseSensitiveAnalysis);
        DataSource$.MODULE$.validateSchema(this.schema());
        this.schema().foreach((Function1 & Serializable & scala.Serializable)field -> {
            FileWriteBuilder.$anonfun$validateInputs$4(this, field);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Job getJobInstance(Configuration hadoopConf, Path path) {
        void var3_3;
        Job job = Job.getInstance((Configuration)hadoopConf);
        job.setOutputKeyClass(Void.class);
        job.setOutputValueClass(InternalRow.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)path);
        return var3_3;
    }

    private WriteJobDescription createWriteJobDescription(SparkSession sparkSession, Configuration hadoopConf, Job job, String pathName, scala.collection.immutable.Map<String, String> options) {
        CaseInsensitiveMap caseInsensitiveOptions = CaseInsensitiveMap$.MODULE$.apply(options);
        OutputWriterFactory outputWriterFactory = this.prepareWrite(sparkSession.sessionState().conf(), job, (scala.collection.immutable.Map<String, String>)caseInsensitiveOptions, this.schema());
        Seq allColumns = this.schema().toAttributes();
        scala.collection.immutable.Map<String, SQLMetric> metrics = BasicWriteJobStatsTracker$.MODULE$.metrics();
        SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(hadoopConf);
        BasicWriteJobStatsTracker statsTracker = new BasicWriteJobStatsTracker(serializableHadoopConf, metrics);
        return new WriteJobDescription(UUID.randomUUID().toString(), new SerializableConfiguration(job.getConfiguration()), outputWriterFactory, (Seq<Attribute>)allColumns, (Seq<Attribute>)allColumns, (Seq<Attribute>)((Seq)Seq$.MODULE$.empty()), (Option<Expression>)None$.MODULE$, pathName, (scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, String>)Predef$.MODULE$.Map().empty(), BoxesRunTime.unboxToLong((Object)caseInsensitiveOptions.get("maxRecordsPerFile").map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)FileWriteBuilder.$anonfun$createWriteJobDescription$1(x$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> sparkSession.sessionState().conf().maxRecordsPerFile())), (String)caseInsensitiveOptions.get(DateTimeUtils$.MODULE$.TIMEZONE_OPTION()).getOrElse((Function0 & Serializable & scala.Serializable)() -> sparkSession.sessionState().conf().sessionLocalTimeZone()), (Seq<WriteJobStatsTracker>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BasicWriteJobStatsTracker[]{statsTracker}))));
    }

    private final /* synthetic */ WriteJobDescription description$lzycompute$1(LazyRef description$lzy$1, SparkSession sparkSession$1, Configuration hadoopConf$1, Job job$1) {
        WriteJobDescription writeJobDescription;
        LazyRef lazyRef = description$lzy$1;
        synchronized (lazyRef) {
            writeJobDescription = description$lzy$1.initialized() ? (WriteJobDescription)description$lzy$1.value() : (WriteJobDescription)description$lzy$1.initialize((Object)this.createWriteJobDescription(sparkSession$1, hadoopConf$1, job$1, (String)this.paths.head(), (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.options()).asScala()).toMap(Predef$.MODULE$.$conforms())));
        }
        return writeJobDescription;
    }

    private final WriteJobDescription description$1(LazyRef description$lzy$1, SparkSession sparkSession$1, Configuration hadoopConf$1, Job job$1) {
        return description$lzy$1.initialized() ? (WriteJobDescription)description$lzy$1.value() : this.description$lzycompute$1(description$lzy$1, sparkSession$1, hadoopConf$1, job$1);
    }

    public static final /* synthetic */ void $anonfun$validateInputs$4(FileWriteBuilder $this, StructField field) {
        if (!BoxesRunTime.unboxToBoolean((Object)$this.supportsDataType.apply((Object)field.dataType()))) {
            throw new AnalysisException(new StringBuilder(41).append($this.formatName).append(" data source does not support ").append(field.dataType().catalogString()).append(" data type.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public static final /* synthetic */ long $anonfun$createWriteJobDescription$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public FileWriteBuilder(Seq<String> paths, String formatName, Function1<DataType, Object> supportsDataType, LogicalWriteInfo info) {
        this.paths = paths;
        this.formatName = formatName;
        this.supportsDataType = supportsDataType;
        this.schema = info.schema();
        this.queryId = info.queryId();
        this.options = info.options();
    }
}

