/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import org.apache.arrow.vector.complex.MapVector;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.arrow.ArrowFieldWriter;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E3Q\u0001D\u0007\u0001\u001beA\u0001B\b\u0001\u0003\u0006\u0004%\t\u0001\t\u0005\tU\u0001\u0011\t\u0011)A\u0005C!A1\u0006\u0001BC\u0002\u0013\u0005A\u0006\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003\u001b\u0011!q\u0003A!b\u0001\n\u0003a\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\t\u000bA\u0002A\u0011A\u0019\t\u000bY\u0002A\u0011I\u001c\t\u000by\u0002A\u0011I \t\u000b=\u0003A\u0011I\u001c\t\u000bA\u0003A\u0011I\u001c\u0003\u00135\u000b\u0007o\u0016:ji\u0016\u0014(B\u0001\b\u0010\u0003\u0015\t'O]8x\u0015\t\u0001\u0012#A\u0005fq\u0016\u001cW\u000f^5p]*\u0011!cE\u0001\u0004gFd'B\u0001\u000b\u0016\u0003\u0015\u0019\b/\u0019:l\u0015\t1r#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0005\u0019qN]4\u0014\u0005\u0001Q\u0002CA\u000e\u001d\u001b\u0005i\u0011BA\u000f\u000e\u0005A\t%O]8x\r&,G\u000eZ,sSR,'/A\u0006wC2,XMV3di>\u00148\u0001A\u000b\u0002CA\u0011!\u0005K\u0007\u0002G)\u0011A%J\u0001\bG>l\u0007\u000f\\3y\u0015\t1s%\u0001\u0004wK\u000e$xN\u001d\u0006\u0003\u001dUI!!K\u0012\u0003\u00135\u000b\u0007OV3di>\u0014\u0018\u0001\u0004<bYV,g+Z2u_J\u0004\u0013!C6fs^\u0013\u0018\u000e^3s+\u0005Q\u0012AC6fs^\u0013\u0018\u000e^3sA\u0005Ya/\u00197vK^\u0013\u0018\u000e^3s\u000311\u0018\r\\;f/JLG/\u001a:!\u0003\u0019a\u0014N\\5u}Q!!g\r\u001b6!\tY\u0002\u0001C\u0003\u001f\u000f\u0001\u0007\u0011\u0005C\u0003,\u000f\u0001\u0007!\u0004C\u0003/\u000f\u0001\u0007!$A\u0004tKRtU\u000f\u001c7\u0015\u0003a\u0002\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012A!\u00168ji\u0006A1/\u001a;WC2,X\rF\u00029\u0001*CQ!Q\u0005A\u0002\t\u000bQ!\u001b8qkR\u0004\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000fF\t\u0001bY1uC2L8\u000f^\u0005\u0003\u0013\u0012\u0013!c\u00159fG&\fG.\u001b>fI\u001e+G\u000f^3sg\")1*\u0003a\u0001\u0019\u00069qN\u001d3j]\u0006d\u0007CA\u001dN\u0013\tq%HA\u0002J]R\faAZ5oSND\u0017!\u0002:fg\u0016$\b")
public class MapWriter
extends ArrowFieldWriter {
    private final MapVector valueVector;
    private final ArrowFieldWriter keyWriter;
    private final ArrowFieldWriter valueWriter;

    public MapVector valueVector() {
        return this.valueVector;
    }

    public ArrowFieldWriter keyWriter() {
        return this.keyWriter;
    }

    public ArrowFieldWriter valueWriter() {
        return this.valueWriter;
    }

    @Override
    public void setNull() {
    }

    @Override
    public void setValue(SpecializedGetters input, int ordinal) {
        MapData map = input.getMap(ordinal);
        this.valueVector().startNewValue(this.count());
        ArrayData keys = map.keyArray();
        ArrayData values = map.valueArray();
        for (int i = 0; i < map.numElements(); ++i) {
            this.keyWriter().write((SpecializedGetters)keys, i);
            this.valueWriter().write((SpecializedGetters)values, i);
        }
        this.valueVector().endValue(this.count(), map.numElements());
    }

    @Override
    public void finish() {
        super.finish();
        this.keyWriter().finish();
        this.valueWriter().finish();
    }

    @Override
    public void reset() {
        super.reset();
        this.keyWriter().reset();
        this.valueWriter().reset();
    }

    public MapWriter(MapVector valueVector, ArrowFieldWriter keyWriter, ArrowFieldWriter valueWriter) {
        this.valueVector = valueVector;
        this.keyWriter = keyWriter;
        this.valueWriter = valueWriter;
    }
}

