/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.feature.RobustScaler$;
import org.apache.spark.ml.feature.RobustScalerModel;
import org.apache.spark.ml.feature.RobustScalerParams;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasRelativeError;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u000b\u0017\u0001\u0005B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0005\u000e\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005k!)Q\n\u0001C\u0001\u001d\")Q\n\u0001C\u0001'\")A\u000b\u0001C\u0001+\")\u0011\f\u0001C\u00015\")A\f\u0001C\u0001;\")1\r\u0001C\u0001I\")a\r\u0001C\u0001O\")A\u000e\u0001C\u0001[\")q\u000e\u0001C\u0001a\")!\u000f\u0001C!g\"9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0001bBA\u0013\u0001\u0011\u0005\u0013qE\u0004\b\u0003w1\u0002\u0012AA\u001f\r\u0019)b\u0003#\u0001\u0002@!1Q\n\u0005C\u0001\u0003'B\u0001\"!\u0016\u0011\t\u0003A\u0012q\u000b\u0005\b\u00033\u0003B\u0011IAN\u0011%\t\t\u000bEA\u0001\n\u0013\t\u0019K\u0001\u0007S_\n,8\u000f^*dC2,'O\u0003\u0002\u00181\u00059a-Z1ukJ,'BA\r\u001b\u0003\tiGN\u0003\u0002\u001c9\u0005)1\u000f]1sW*\u0011QDH\u0001\u0007CB\f7\r[3\u000b\u0003}\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0012+[A\u00191\u0005\n\u0014\u000e\u0003aI!!\n\r\u0003\u0013\u0015\u001bH/[7bi>\u0014\bCA\u0014)\u001b\u00051\u0012BA\u0015\u0017\u0005E\u0011vNY;tiN\u001b\u0017\r\\3s\u001b>$W\r\u001c\t\u0003O-J!\u0001\f\f\u0003%I{'-^:u'\u000e\fG.\u001a:QCJ\fWn\u001d\t\u0003]Ej\u0011a\f\u0006\u0003aa\tA!\u001e;jY&\u0011!g\f\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:Xe&$\u0018M\u00197f\u0003\r)\u0018\u000eZ\u000b\u0002kA\u0011ag\u0010\b\u0003ou\u0002\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0011\u0002\rq\u0012xn\u001c;?\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005yZ\u0004fA\u0001D\u0013B\u0011AiR\u0007\u0002\u000b*\u0011aIG\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001%F\u0005\u0015\u0019\u0016N\\2fC\u0005Q\u0015!B\u001a/a9\u0002\u0014\u0001B;jI\u0002B3AA\"J\u0003\u0019a\u0014N\\5u}Q\u0011q\n\u0015\t\u0003O\u0001AQaM\u0002A\u0002UB3\u0001U\"JQ\r\u00191)\u0013\u000b\u0002\u001f\u0006Y1/\u001a;J]B,HoQ8m)\t1v+D\u0001\u0001\u0011\u0015AV\u00011\u00016\u0003\u00151\u0018\r\\;f\u00031\u0019X\r^(viB,HoQ8m)\t16\fC\u0003Y\r\u0001\u0007Q'\u0001\u0005tKRdun^3s)\t1f\fC\u0003Y\u000f\u0001\u0007q\f\u0005\u0002aC6\t1(\u0003\u0002cw\t1Ai\\;cY\u0016\f\u0001b]3u+B\u0004XM\u001d\u000b\u0003-\u0016DQ\u0001\u0017\u0005A\u0002}\u000b\u0001c]3u/&$\bnQ3oi\u0016\u0014\u0018N\\4\u0015\u0005YC\u0007\"\u0002-\n\u0001\u0004I\u0007C\u00011k\u0013\tY7HA\u0004C_>dW-\u00198\u0002\u001dM,GoV5uQN\u001b\u0017\r\\5oOR\u0011aK\u001c\u0005\u00061*\u0001\r![\u0001\u0011g\u0016$(+\u001a7bi&4X-\u0012:s_J$\"AV9\t\u000ba[\u0001\u0019A0\u0002\u0007\u0019LG\u000f\u0006\u0002'i\")Q\u000f\u0004a\u0001m\u00069A-\u0019;bg\u0016$\bGA<\u0000!\rA80`\u0007\u0002s*\u0011!PG\u0001\u0004gFd\u0017B\u0001?z\u0005\u001d!\u0015\r^1tKR\u0004\"A`@\r\u0001\u0011Y\u0011\u0011\u0001;\u0002\u0002\u0003\u0005)\u0011AA\u0002\u0005\ryF%M\t\u0005\u0003\u000b\tY\u0001E\u0002a\u0003\u000fI1!!\u0003<\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001YA\u0007\u0013\r\tya\u000f\u0002\u0004\u0003:L\u0018a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005U\u0011\u0011\u0005\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111D=\u0002\u000bQL\b/Z:\n\t\u0005}\u0011\u0011\u0004\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA\u0012\u001b\u0001\u0007\u0011QC\u0001\u0007g\u000eDW-\\1\u0002\t\r|\u0007/\u001f\u000b\u0004\u001f\u0006%\u0002bBA\u0016\u001d\u0001\u0007\u0011QF\u0001\u0006Kb$(/\u0019\t\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111\u0007\r\u0002\u000bA\f'/Y7\n\t\u0005]\u0012\u0011\u0007\u0002\t!\u0006\u0014\u0018-\\'ba\"\u001a\u0001aQ%\u0002\u0019I{'-^:u'\u000e\fG.\u001a:\u0011\u0005\u001d\u00022c\u0002\t\u0002B\u0005\u001d\u0013Q\n\t\u0004A\u0006\r\u0013bAA#w\t1\u0011I\\=SK\u001a\u0004BALA%\u001f&\u0019\u00111J\u0018\u0003+\u0011+g-Y;miB\u000b'/Y7t%\u0016\fG-\u00192mKB\u0019\u0001-a\u0014\n\u0007\u0005E3H\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002>\u0005\u00012m\\7qkR,7+^7nCJLWm\u001d\u000b\t\u00033\ny(!%\u0002\u0016B1\u00111LA1\u0003Kj!!!\u0018\u000b\u0007\u0005}#$A\u0002sI\u0012LA!a\u0019\u0002^\t\u0019!\u000b\u0012#\u0011\u000f\u0001\f9'a\u001b\u0002r%\u0019\u0011\u0011N\u001e\u0003\rQ+\b\u000f\\33!\r\u0001\u0017QN\u0005\u0004\u0003_Z$aA%oiB!\u00111OA>\u001b\t\t)HC\u00021\u0003oR1!!\u001fz\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA?\u0003k\u0012\u0011#U;b]RLG.Z*v[6\f'/[3t\u0011\u001d\t\tI\u0005a\u0001\u0003\u0007\u000bqA^3di>\u00148\u000f\u0005\u0004\u0002\\\u0005\u0005\u0014Q\u0011\t\u0005\u0003\u000f\u000bi)\u0004\u0002\u0002\n*\u0019\u00111\u0012\r\u0002\r1Lg.\u00197h\u0013\u0011\ty)!#\u0003\rY+7\r^8s\u0011\u001d\t\u0019J\u0005a\u0001\u0003W\n1B\\;n\r\u0016\fG/\u001e:fg\"1\u0011q\u0013\nA\u0002}\u000bQB]3mCRLg/Z#se>\u0014\u0018\u0001\u00027pC\u0012$2aTAO\u0011\u0019\tyj\u0005a\u0001k\u0005!\u0001/\u0019;i\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0015\u0006\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\u0005Y\u0006twM\u0003\u0002\u00020\u0006!!.\u0019<b\u0013\u0011\t\u0019,!+\u0003\r=\u0013'.Z2uQ\r\u00012)\u0013\u0015\u0004\u001f\rK\u0005")
public class RobustScaler
extends Estimator<RobustScalerModel>
implements RobustScalerParams,
DefaultParamsWritable {
    private final String uid;
    private final DoubleParam lower;
    private final DoubleParam upper;
    private final BooleanParam withCentering;
    private final BooleanParam withScaling;
    private final DoubleParam relativeError;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    public static RobustScaler load(String string) {
        return RobustScaler$.MODULE$.load(string);
    }

    public static MLReader<RobustScaler> read() {
        return RobustScaler$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public double getLower() {
        return RobustScalerParams.getLower$(this);
    }

    @Override
    public double getUpper() {
        return RobustScalerParams.getUpper$(this);
    }

    @Override
    public boolean getWithCentering() {
        return RobustScalerParams.getWithCentering$(this);
    }

    @Override
    public boolean getWithScaling() {
        return RobustScalerParams.getWithScaling$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return RobustScalerParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final double getRelativeError() {
        return HasRelativeError.getRelativeError$(this);
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$(this);
    }

    @Override
    public final String getInputCol() {
        return HasInputCol.getInputCol$(this);
    }

    @Override
    public DoubleParam lower() {
        return this.lower;
    }

    @Override
    public DoubleParam upper() {
        return this.upper;
    }

    @Override
    public BooleanParam withCentering() {
        return this.withCentering;
    }

    @Override
    public BooleanParam withScaling() {
        return this.withScaling;
    }

    @Override
    public void org$apache$spark$ml$feature$RobustScalerParams$_setter_$lower_$eq(DoubleParam x$1) {
        this.lower = x$1;
    }

    @Override
    public void org$apache$spark$ml$feature$RobustScalerParams$_setter_$upper_$eq(DoubleParam x$1) {
        this.upper = x$1;
    }

    @Override
    public void org$apache$spark$ml$feature$RobustScalerParams$_setter_$withCentering_$eq(BooleanParam x$1) {
        this.withCentering = x$1;
    }

    @Override
    public void org$apache$spark$ml$feature$RobustScalerParams$_setter_$withScaling_$eq(BooleanParam x$1) {
        this.withScaling = x$1;
    }

    @Override
    public final DoubleParam relativeError() {
        return this.relativeError;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRelativeError$_setter_$relativeError_$eq(DoubleParam x$1) {
        this.relativeError = x$1;
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public RobustScaler setInputCol(String value) {
        return (RobustScaler)this.set(this.inputCol(), value);
    }

    public RobustScaler setOutputCol(String value) {
        return (RobustScaler)this.set(this.outputCol(), value);
    }

    public RobustScaler setLower(double value) {
        return (RobustScaler)this.set(this.lower(), BoxesRunTime.boxToDouble((double)value));
    }

    public RobustScaler setUpper(double value) {
        return (RobustScaler)this.set(this.upper(), BoxesRunTime.boxToDouble((double)value));
    }

    public RobustScaler setWithCentering(boolean value) {
        return (RobustScaler)this.set(this.withCentering(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public RobustScaler setWithScaling(boolean value) {
        return (RobustScaler)this.set(this.withScaling(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public RobustScaler setRelativeError(double value) {
        return (RobustScaler)this.set(this.relativeError(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public RobustScalerModel fit(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        int numFeatures = MetadataUtils$.MODULE$.getNumFeatures(dataset, this.$(this.inputCol()));
        RDD vectors = dataset.select(this.$(this.inputCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object vec;
            Row row = x0$1;
            Some some = Row$.MODULE$.unapplySeq(row);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((vec = ((SeqLike)some.get()).apply(0)) instanceof Vector)) {
                throw new MatchError((Object)row);
            }
            Vector vector = (Vector)vec;
            Predef$.MODULE$.require(vector.size() == numFeatures, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Number of dimensions must be ").append(numFeatures).append(" but got ").append(vector.size()).toString());
            Vector vector2 = vector;
            return vector2;
        }, ClassTag$.MODULE$.apply(Vector.class));
        double localUpper = BoxesRunTime.unboxToDouble((Object)this.$(this.upper()));
        double localLower = BoxesRunTime.unboxToDouble((Object)this.$(this.lower()));
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(RobustScaler$.MODULE$.computeSummaries((RDD<Vector>)vectors, numFeatures, BoxesRunTime.unboxToDouble((Object)this.$(this.relativeError()))), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(QuantileSummaries.class), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1 & Serializable & scala.Serializable)s -> {
            double range = BoxesRunTime.unboxToDouble((Object)s.query(localUpper).get()) - BoxesRunTime.unboxToDouble((Object)s.query(localLower).get());
            double median = BoxesRunTime.unboxToDouble((Object)s.query(0.5).get());
            return new Tuple2.mcDD.sp(range, median);
        }).collect())).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$2 -> (Tuple2)x$2._2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double[] ranges = (double[])tuple2._1();
        double[] medians = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)ranges, (Object)medians);
        Tuple2 tuple23 = tuple22;
        double[] ranges2 = (double[])tuple23._1();
        double[] medians2 = (double[])tuple23._2();
        Predef$.MODULE$.require(ranges2.length == numFeatures, (Function0 & Serializable & scala.Serializable)() -> "QuantileSummaries on some features are missing");
        return this.copyValues(new RobustScalerModel(this.uid(), Vectors$.MODULE$.dense(ranges2).compressed(), Vectors$.MODULE$.dense(medians2).compressed()).setParent(this), this.copyValues$default$2());
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    @Override
    public RobustScaler copy(ParamMap extra) {
        return (RobustScaler)this.defaultCopy(extra);
    }

    public RobustScaler(String uid) {
        this.uid = uid;
        HasInputCol.$init$(this);
        HasOutputCol.$init$(this);
        HasRelativeError.$init$(this);
        RobustScalerParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
    }

    public RobustScaler() {
        this(Identifiable$.MODULE$.randomUID("robustScal"));
    }
}

