/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spark_project.dmg.pmml.Coefficients;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.SupportVectors;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;
import org.spark_project.jpmml.schema.Added;
import org.spark_project.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "supportVectors", "coefficients"})
@XmlRootElement(name="SupportVectorMachine", namespace="http://www.dmg.org/PMML-4_2")
public class SupportVectorMachine
extends PMMLObject
implements HasExtensions {
    @XmlAttribute(name="targetCategory")
    @Added(value=Version.PMML_3_1)
    private String targetCategory;
    @XmlAttribute(name="alternateTargetCategory")
    @Added(value=Version.PMML_4_0)
    private String alternateTargetCategory;
    @XmlAttribute(name="threshold")
    @Added(value=Version.PMML_4_0)
    private Double threshold;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="SupportVectors", namespace="http://www.dmg.org/PMML-4_2")
    private SupportVectors supportVectors;
    @XmlElement(name="Coefficients", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private Coefficients coefficients;

    public SupportVectorMachine() {
    }

    public SupportVectorMachine(Coefficients coefficients2) {
        this.coefficients = coefficients2;
    }

    public String getTargetCategory() {
        return this.targetCategory;
    }

    public SupportVectorMachine setTargetCategory(String targetCategory) {
        this.targetCategory = targetCategory;
        return this;
    }

    public String getAlternateTargetCategory() {
        return this.alternateTargetCategory;
    }

    public SupportVectorMachine setAlternateTargetCategory(String alternateTargetCategory) {
        this.alternateTargetCategory = alternateTargetCategory;
        return this;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public SupportVectorMachine setThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public SupportVectors getSupportVectors() {
        return this.supportVectors;
    }

    public SupportVectorMachine setSupportVectors(SupportVectors supportVectors) {
        this.supportVectors = supportVectors;
        return this;
    }

    public Coefficients getCoefficients() {
        return this.coefficients;
    }

    public SupportVectorMachine setCoefficients(Coefficients coefficients2) {
        this.coefficients = coefficients2;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public SupportVectorMachine addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getSupportVectors(), this.getCoefficients());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

