/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.Measure;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="minkowski", namespace="http://www.dmg.org/PMML-4_2")
public class Minkowski
extends Measure
implements HasExtensions {
    @XmlAttribute(name="p-parameter", required=true)
    private double pParameter;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;

    public Minkowski() {
    }

    public Minkowski(double pParameter) {
        this.pParameter = pParameter;
    }

    public double getPParameter() {
        return this.pParameter;
    }

    public Minkowski setPParameter(double pParameter) {
        this.pParameter = pParameter;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public Minkowski addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

