/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import org.apache.spark.internal.Logging;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.tree.TreeEnsembleParams$;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichDouble$;
import scala.util.Try$;

public final class DecisionTreeMetadata$
implements Logging,
Serializable {
    public static final DecisionTreeMetadata$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DecisionTreeMetadata$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public DecisionTreeMetadata buildMetadata(RDD<LabeledPoint> input, Strategy strategy, int numTrees, String featureSubsetStrategy) {
        Enumeration.Value value;
        block13: {
            Option option;
            block21: {
                block22: {
                    int n;
                    int[] numBins;
                    HashSet unorderedFeatures;
                    int numClasses;
                    long numExamples;
                    int numFeatures;
                    block15: {
                        int n2;
                        block20: {
                            int n3;
                            String _featureSubsetStrategy;
                            block19: {
                                block18: {
                                    String string;
                                    block17: {
                                        block16: {
                                            block14: {
                                                String string2;
                                                int n4;
                                                block12: {
                                                    block11: {
                                                        numFeatures = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])input.map((Function1)new Serializable(){
                                                            public static final long serialVersionUID = 0L;

                                                            public final int apply(LabeledPoint x$1) {
                                                                return x$1.features().size();
                                                            }
                                                        }, ClassTag$.MODULE$.Int()).take(1)).headOption().getOrElse((Function0)new Serializable(){
                                                            public static final long serialVersionUID = 0L;

                                                            public final Nothing$ apply() {
                                                                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTree requires size of input RDD > 0, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but was given by empty one."})).s((Seq)Nil$.MODULE$)).toString());
                                                            }
                                                        }));
                                                        Predef$.MODULE$.require(numFeatures > 0, (Function0)new Serializable(){
                                                            public static final long serialVersionUID = 0L;

                                                            public final String apply() {
                                                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTree requires number of features > 0, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but was given an empty features vector"})).s((Seq)Nil$.MODULE$)).toString();
                                                            }
                                                        });
                                                        numExamples = input.count();
                                                        value = strategy.algo();
                                                        Enumeration.Value value2 = Algo$.MODULE$.Classification();
                                                        Enumeration.Value value3 = value;
                                                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block11;
                                                        n4 = strategy.numClasses();
                                                        break block12;
                                                    }
                                                    Enumeration.Value value4 = Algo$.MODULE$.Regression();
                                                    Enumeration.Value value5 = value;
                                                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block13;
                                                    n4 = 0;
                                                }
                                                numClasses = n4;
                                                int maxPossibleBins = (int)package$.MODULE$.min((long)strategy.maxBins(), numExamples);
                                                if (maxPossibleBins < strategy.maxBins()) {
                                                    this.logWarning((Function0<String>)new Serializable(strategy, maxPossibleBins){
                                                        public static final long serialVersionUID = 0L;
                                                        private final Strategy strategy$1;
                                                        private final int maxPossibleBins$1;

                                                        public final String apply() {
                                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTree reducing maxBins from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.strategy$1.maxBins()), BoxesRunTime.boxToInteger((int)this.maxPossibleBins$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (= number of training instances)"})).s((Seq)Nil$.MODULE$)).toString();
                                                        }
                                                        {
                                                            this.strategy$1 = strategy$1;
                                                            this.maxPossibleBins$1 = maxPossibleBins$1;
                                                        }
                                                    });
                                                }
                                                if (strategy.categoricalFeaturesInfo().nonEmpty()) {
                                                    int maxCategoriesPerFeature = BoxesRunTime.unboxToInt((Object)strategy.categoricalFeaturesInfo().values().max((Ordering)Ordering.Int$.MODULE$));
                                                    int maxCategory = ((Tuple2)strategy.categoricalFeaturesInfo().find((Function1)new Serializable(maxCategoriesPerFeature){
                                                        public static final long serialVersionUID = 0L;
                                                        private final int maxCategoriesPerFeature$1;

                                                        public final boolean apply(Tuple2<Object, Object> x$2) {
                                                            return x$2._2$mcI$sp() == this.maxCategoriesPerFeature$1;
                                                        }
                                                        {
                                                            this.maxCategoriesPerFeature$1 = maxCategoriesPerFeature$1;
                                                        }
                                                    }).get())._1$mcI$sp();
                                                    Predef$.MODULE$.require(maxCategoriesPerFeature <= maxPossibleBins, (Function0)new Serializable(maxPossibleBins, maxCategoriesPerFeature, maxCategory){
                                                        public static final long serialVersionUID = 0L;
                                                        private final int maxPossibleBins$1;
                                                        private final int maxCategoriesPerFeature$1;
                                                        private final int maxCategory$1;

                                                        public final String apply() {
                                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTree requires maxBins (= ", ") to be at least as large as the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxPossibleBins$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of values in each categorical feature, but categorical feature ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxCategory$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"has ", " values. Considering remove this and other categorical "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxCategoriesPerFeature$1)}))).append((Object)"features with a large number of values, or add more training examples.").toString();
                                                        }
                                                        {
                                                            this.maxPossibleBins$1 = maxPossibleBins$1;
                                                            this.maxCategoriesPerFeature$1 = maxCategoriesPerFeature$1;
                                                            this.maxCategory$1 = maxCategory$1;
                                                        }
                                                    });
                                                }
                                                unorderedFeatures = new HashSet();
                                                numBins = (int[])Array$.MODULE$.fill(numFeatures, (Function0)new Serializable(maxPossibleBins){
                                                    public static final long serialVersionUID = 0L;
                                                    private final int maxPossibleBins$1;

                                                    public final int apply() {
                                                        return this.apply$mcI$sp();
                                                    }

                                                    public int apply$mcI$sp() {
                                                        return this.maxPossibleBins$1;
                                                    }
                                                    {
                                                        this.maxPossibleBins$1 = maxPossibleBins$1;
                                                    }
                                                }, ClassTag$.MODULE$.Int());
                                                if (numClasses > 2) {
                                                    int maxCategoriesForUnorderedFeature = (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)(maxPossibleBins / 2 + 1)) / package$.MODULE$.log(2.0) + 1.0));
                                                    strategy.categoricalFeaturesInfo().foreach((Function1)new Serializable(unorderedFeatures, numBins, maxCategoriesForUnorderedFeature){
                                                        public static final long serialVersionUID = 0L;
                                                        private final HashSet unorderedFeatures$1;
                                                        private final int[] numBins$1;
                                                        private final int maxCategoriesForUnorderedFeature$1;

                                                        public final void apply(Tuple2<Object, Object> x0$1) {
                                                            Tuple2<Object, Object> tuple2 = x0$1;
                                                            if (tuple2 != null) {
                                                                BoxedUnit boxedUnit;
                                                                int featureIndex = tuple2._1$mcI$sp();
                                                                int numCategories = tuple2._2$mcI$sp();
                                                                if (numCategories > 1) {
                                                                    if (numCategories <= this.maxCategoriesForUnorderedFeature$1) {
                                                                        this.unorderedFeatures$1.add((Object)BoxesRunTime.boxToInteger((int)featureIndex));
                                                                        this.numBins$1[featureIndex] = DecisionTreeMetadata$.MODULE$.numUnorderedBins(numCategories);
                                                                        boxedUnit = BoxedUnit.UNIT;
                                                                    } else {
                                                                        this.numBins$1[featureIndex] = numCategories;
                                                                        boxedUnit = BoxedUnit.UNIT;
                                                                    }
                                                                } else {
                                                                    boxedUnit = BoxedUnit.UNIT;
                                                                }
                                                                BoxedUnit boxedUnit2 = boxedUnit;
                                                                return;
                                                            }
                                                            throw new MatchError(tuple2);
                                                        }
                                                        {
                                                            this.unorderedFeatures$1 = unorderedFeatures$1;
                                                            this.numBins$1 = numBins$1;
                                                            this.maxCategoriesForUnorderedFeature$1 = maxCategoriesForUnorderedFeature$1;
                                                        }
                                                    });
                                                } else {
                                                    strategy.categoricalFeaturesInfo().foreach((Function1)new Serializable(numBins){
                                                        public static final long serialVersionUID = 0L;
                                                        private final int[] numBins$1;

                                                        public final void apply(Tuple2<Object, Object> x0$2) {
                                                            Tuple2<Object, Object> tuple2 = x0$2;
                                                            if (tuple2 != null) {
                                                                BoxedUnit boxedUnit;
                                                                int featureIndex = tuple2._1$mcI$sp();
                                                                int numCategories = tuple2._2$mcI$sp();
                                                                if (numCategories > 1) {
                                                                    this.numBins$1[featureIndex] = numCategories;
                                                                    boxedUnit = BoxedUnit.UNIT;
                                                                } else {
                                                                    boxedUnit = BoxedUnit.UNIT;
                                                                }
                                                                BoxedUnit boxedUnit2 = boxedUnit;
                                                                return;
                                                            }
                                                            throw new MatchError(tuple2);
                                                        }
                                                        {
                                                            this.numBins$1 = numBins$1;
                                                        }
                                                    });
                                                }
                                                String string3 = featureSubsetStrategy;
                                                if ("auto".equals(string3)) {
                                                    String string4;
                                                    if (numTrees == 1) {
                                                        string4 = "all";
                                                    } else {
                                                        Enumeration.Value value6 = strategy.algo();
                                                        Enumeration.Value value7 = Algo$.MODULE$.Classification();
                                                        string4 = !(value6 != null ? !value6.equals(value7) : value7 != null) ? "sqrt" : "onethird";
                                                    }
                                                    string2 = string4;
                                                } else {
                                                    string2 = featureSubsetStrategy;
                                                }
                                                string = _featureSubsetStrategy = string2;
                                                if (!"all".equals(string)) break block14;
                                                n = numFeatures;
                                                break block15;
                                            }
                                            if (!"sqrt".equals(string)) break block16;
                                            n = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.sqrt((double)numFeatures)));
                                            break block15;
                                        }
                                        if (!"log2".equals(string)) break block17;
                                        n = package$.MODULE$.max(1, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)numFeatures) / package$.MODULE$.log(2.0))));
                                        break block15;
                                    }
                                    if (!"onethird".equals(string)) break block18;
                                    n = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)numFeatures / 3.0));
                                    break block15;
                                }
                                option = Try$.MODULE$.apply((Function0)new Serializable(_featureSubsetStrategy){
                                    public static final long serialVersionUID = 0L;
                                    private final String _featureSubsetStrategy$1;

                                    public final int apply() {
                                        return this.apply$mcI$sp();
                                    }

                                    public int apply$mcI$sp() {
                                        return new StringOps(Predef$.MODULE$.augmentString(this._featureSubsetStrategy$1)).toInt();
                                    }
                                    {
                                        this._featureSubsetStrategy$1 = _featureSubsetStrategy$1;
                                    }
                                }).filter((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(int x$3) {
                                        return this.apply$mcZI$sp(x$3);
                                    }

                                    public boolean apply$mcZI$sp(int x$3) {
                                        return x$3 > 0;
                                    }
                                }).toOption();
                                if (!(option instanceof Some)) break block19;
                                Some some = (Some)option;
                                int value8 = BoxesRunTime.unboxToInt((Object)some.x());
                                n2 = package$.MODULE$.min(value8, numFeatures);
                                break block20;
                            }
                            if (!None$.MODULE$.equals(option)) break block21;
                            Option option2 = Try$.MODULE$.apply((Function0)new Serializable(_featureSubsetStrategy){
                                public static final long serialVersionUID = 0L;
                                private final String _featureSubsetStrategy$1;

                                public final double apply() {
                                    return this.apply$mcD$sp();
                                }

                                public double apply$mcD$sp() {
                                    return new StringOps(Predef$.MODULE$.augmentString(this._featureSubsetStrategy$1)).toDouble();
                                }
                                {
                                    this._featureSubsetStrategy$1 = _featureSubsetStrategy$1;
                                }
                            }).filter((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(double x$4) {
                                    return this.apply$mcZD$sp(x$4);
                                }

                                public boolean apply$mcZD$sp(double x$4) {
                                    return x$4 > 0.0;
                                }
                            }).filter((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(double x$5) {
                                    return this.apply$mcZD$sp(x$5);
                                }

                                public boolean apply$mcZD$sp(double x$5) {
                                    return x$5 <= 1.0;
                                }
                            }).toOption();
                            if (!(option2 instanceof Some)) break block22;
                            Some some = (Some)option2;
                            double value9 = BoxesRunTime.unboxToDouble((Object)some.x());
                            n2 = n3 = (int)package$.MODULE$.ceil(value9 * (double)numFeatures);
                        }
                        n = n2;
                    }
                    int numFeaturesPerNode = n;
                    return new DecisionTreeMetadata(numFeatures, numExamples, numClasses, BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(numBins).max((Ordering)Ordering.Int$.MODULE$)), strategy.categoricalFeaturesInfo(), (Set<Object>)unorderedFeatures.toSet(), numBins, strategy.impurity(), strategy.quantileCalculationStrategy(), strategy.maxDepth(), strategy.minInstancesPerNode(), strategy.minInfoGain(), numTrees, numFeaturesPerNode);
                }
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Supported values:"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])TreeEnsembleParams$.MODULE$.supportedFeatureSubsetStrategies()).mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (0.0-1.0], [1-n]."})).s((Seq)Nil$.MODULE$)).toString());
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)value);
    }

    public DecisionTreeMetadata buildMetadata(RDD<LabeledPoint> input, Strategy strategy) {
        return this.buildMetadata(input, strategy, 1, "all");
    }

    public int numUnorderedBins(int arity) {
        return (1 << arity - 1) - 1;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DecisionTreeMetadata$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

