/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.clustering.GaussianMixture;
import org.apache.spark.ml.clustering.GaussianMixtureModel;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.GaussianMixtureWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReadable$class;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;

public final class GaussianMixtureWrapper$
implements MLReadable<GaussianMixtureWrapper> {
    public static final GaussianMixtureWrapper$ MODULE$;

    static {
        new GaussianMixtureWrapper$();
    }

    public GaussianMixtureWrapper fit(Dataset<Row> data, String formula, int k, int maxIter, double tol) {
        RFormula rFormula = new RFormula().setFormula(formula).setFeaturesCol("features");
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        StructType schema = ((RFormulaModel)rFormulaModel).transform(data).schema();
        Attribute[] featureAttrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField(schema.apply(((RFormulaModel)rFormulaModel).getFeaturesCol())).attributes().get();
        String[] features = (String[])Predef$.MODULE$.refArrayOps((Object[])featureAttrs).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Attribute x$3) {
                return (String)x$3.name().get();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        int dim = features.length;
        GaussianMixture gm = new GaussianMixture().setK(k).setMaxIter(maxIter).setTol(tol).setFeaturesCol(rFormula.getFeaturesCol());
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, gm})).fit((Dataset)data);
        GaussianMixtureModel gmm = (GaussianMixtureModel)((PipelineModel)pipeline).stages()[1];
        double logLikelihood2 = gmm.summary().logLikelihood();
        return new GaussianMixtureWrapper((PipelineModel)pipeline, dim, logLikelihood2, this.$lessinit$greater$default$4());
    }

    @Override
    public MLReader<GaussianMixtureWrapper> read() {
        return new GaussianMixtureWrapper.GaussianMixtureWrapperReader();
    }

    @Override
    public GaussianMixtureWrapper load(String path) {
        return (GaussianMixtureWrapper)MLReadable$class.load(this, path);
    }

    private boolean $lessinit$greater$default$4() {
        return false;
    }

    private GaussianMixtureWrapper$() {
        MODULE$ = this;
        MLReadable$class.$init$(this);
    }
}

