/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.feature.OneHotEncoderCommon$;
import org.apache.spark.ml.feature.OneHotEncoderCommon$$anonfun$12$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class OneHotEncoderCommon$ {
    public static final OneHotEncoderCommon$ MODULE$;

    static {
        new OneHotEncoderCommon$();
    }

    private Option<String[]> genOutputAttrNames(StructField inputCol) {
        None$ none$;
        Attribute inputAttr = Attribute$.MODULE$.fromStructField(inputCol);
        Attribute attribute = inputAttr;
        if (attribute instanceof NominalAttribute) {
            NominalAttribute nominalAttribute = (NominalAttribute)attribute;
            none$ = nominalAttribute.values().isDefined() ? nominalAttribute.values() : (nominalAttribute.numValues().isDefined() ? nominalAttribute.numValues().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String[] apply(int n) {
                    return (String[])Array$.MODULE$.tabulate(n, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(int x$7) {
                            return ((Object)BoxesRunTime.boxToInteger((int)x$7)).toString();
                        }
                    }, ClassTag$.MODULE$.apply(String.class));
                }
            }) : None$.MODULE$);
        } else if (attribute instanceof BinaryAttribute) {
            BinaryAttribute binaryAttribute = (BinaryAttribute)attribute;
            none$ = binaryAttribute.values().isDefined() ? binaryAttribute.values() : new Some(Array$.MODULE$.tabulate(2, (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(int x$8) {
                    return ((Object)BoxesRunTime.boxToInteger((int)x$8)).toString();
                }
            }, ClassTag$.MODULE$.apply(String.class)));
        } else {
            if (attribute instanceof NumericAttribute) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input column ", " cannot be continuous-value."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputCol.name()})));
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private AttributeGroup genOutputAttrGroup(Option<String[]> outputAttrNames, String outputColName) {
        return (AttributeGroup)outputAttrNames.map((Function1)new Serializable(outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$1;

            public final AttributeGroup apply(String[] attrNames) {
                Attribute[] attrs = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])attrNames).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BinaryAttribute apply(String name) {
                        return BinaryAttribute$.MODULE$.defaultAttr().withName(name);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
                return new AttributeGroup(this.outputColName$1, attrs);
            }
            {
                this.outputColName$1 = outputColName$1;
            }
        }).getOrElse((Function0)new Serializable(outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$1;

            public final AttributeGroup apply() {
                return new AttributeGroup(this.outputColName$1);
            }
            {
                this.outputColName$1 = outputColName$1;
            }
        });
    }

    public StructField transformOutputColumnSchema(StructField inputCol, String outputColName, boolean dropLast, boolean keepInvalid) {
        Option<String[]> outputAttrNames = this.genOutputAttrNames(inputCol);
        Option filteredOutputAttrNames = outputAttrNames.map((Function1)new Serializable(inputCol, dropLast, keepInvalid){
            public static final long serialVersionUID = 0L;
            public final StructField inputCol$1;
            private final boolean dropLast$1;
            private final boolean keepInvalid$1;

            public final String[] apply(String[] names) {
                String[] stringArray;
                if (this.dropLast$1 && !this.keepInvalid$1) {
                    Predef$.MODULE$.require(names.length > 1, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.9 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input column ", " should have at least two distinct values."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.inputCol$1.name()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    stringArray = (String[])Predef$.MODULE$.refArrayOps((Object[])names).dropRight(1);
                } else {
                    stringArray = !this.dropLast$1 && this.keepInvalid$1 ? (String[])Predef$.MODULE$.refArrayOps((Object[])names).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalidValues"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : names;
                }
                return stringArray;
            }
            {
                this.inputCol$1 = inputCol$1;
                this.dropLast$1 = dropLast$1;
                this.keepInvalid$1 = keepInvalid$1;
            }
        });
        return this.genOutputAttrGroup((Option<String[]>)filteredOutputAttrNames, outputColName).toStructField();
    }

    public boolean transformOutputColumnSchema$default$4() {
        return false;
    }

    public Seq<AttributeGroup> getOutputAttrGroupFromData(Dataset<?> dataset, Seq<String> inputColNames, Seq<String> outputColNames, boolean dropLast) {
        Seq columns = (Seq)inputColNames.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String inputColName) {
                return functions$.MODULE$.col(inputColName).cast((DataType)DoubleType$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom());
        int numOfColumns = columns.length();
        RDD qual$1 = dataset.select(columns).rdd().map((Function1)new Serializable(numOfColumns){
            public static final long serialVersionUID = 0L;
            private final int numOfColumns$1;

            public final double[] apply(Row row) {
                return (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numOfColumns$1).map((Function1)new Serializable(this, row){
                    public static final long serialVersionUID = 0L;
                    private final Row row$1;

                    public final double apply(int idx) {
                        return this.apply$mcDI$sp(idx);
                    }

                    public double apply$mcDI$sp(int idx) {
                        return this.row$1.getDouble(idx);
                    }
                    {
                        this.row$1 = row$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            }
            {
                this.numOfColumns$1 = numOfColumns$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        double[] x$11 = new double[numOfColumns];
        Serializable x$12 = new Serializable(inputColNames, numOfColumns){
            public static final long serialVersionUID = 0L;
            public final Seq inputColNames$1;
            private final int numOfColumns$1;

            public final double[] apply(double[] maxValues, double[] curValues) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numOfColumns$1).foreach$mVc$sp((Function1)new Serializable(this, maxValues, curValues){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.12 $outer;
                    private final double[] maxValues$1;
                    private final double[] curValues$1;

                    public final void apply(int idx) {
                        this.apply$mcVI$sp(idx);
                    }

                    public void apply$mcVI$sp(int idx) {
                        double x = this.curValues$1[idx];
                        Predef$.MODULE$.assert(x <= (double)Integer.MAX_VALUE, (Function0)new Serializable(this, x){
                            public static final long serialVersionUID = 0L;
                            private final double x$15;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OneHotEncoder only supports up to ", " indices, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToDouble((double)this.x$15)}));
                            }
                            {
                                this.x$15 = x$15;
                            }
                        });
                        Predef$.MODULE$.assert(x >= 0.0 && x == (double)((int)x), (Function0)new Serializable(this, x, idx){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$12$$anonfun$apply$2 $outer;
                            private final double x$15;
                            private final int idx$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Values from column ", " must be indices, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$ml$feature$OneHotEncoderCommon$$anonfun$$anonfun$$$outer().inputColNames$1.apply(this.idx$1), BoxesRunTime.boxToDouble((double)this.x$15)}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.x$15 = x$15;
                                this.idx$1 = idx$1;
                            }
                        });
                        this.maxValues$1[idx] = package$.MODULE$.max(this.maxValues$1[idx], x);
                    }

                    public /* synthetic */ anonfun.12 org$apache$spark$ml$feature$OneHotEncoderCommon$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.maxValues$1 = maxValues$1;
                        this.curValues$1 = curValues$1;
                    }
                });
                return maxValues;
            }
            {
                this.inputColNames$1 = inputColNames$1;
                this.numOfColumns$1 = numOfColumns$1;
            }
        };
        Serializable x$13 = new Serializable(numOfColumns){
            public static final long serialVersionUID = 0L;
            private final int numOfColumns$1;

            public final double[] apply(double[] m0, double[] m1) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numOfColumns$1).foreach$mVc$sp((Function1)new Serializable(this, m0, m1){
                    public static final long serialVersionUID = 0L;
                    private final double[] m0$1;
                    private final double[] m1$1;

                    public final void apply(int idx) {
                        this.apply$mcVI$sp(idx);
                    }

                    public void apply$mcVI$sp(int idx) {
                        this.m0$1[idx] = package$.MODULE$.max(this.m0$1[idx], this.m1$1[idx]);
                    }
                    {
                        this.m0$1 = m0$1;
                        this.m1$1 = m1$1;
                    }
                });
                return m0;
            }
            {
                this.numOfColumns$1 = numOfColumns$1;
            }
        };
        int x$14 = qual$1.treeAggregate$default$4((Object)x$11);
        int[] numAttrsArray = (int[])Predef$.MODULE$.doubleArrayOps((double[])qual$1.treeAggregate((Object)x$11, (Function2)x$12, (Function2)x$13, x$14, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(double x$9) {
                return this.apply$mcID$sp(x$9);
            }

            public int apply$mcID$sp(double x$9) {
                return (int)x$9 + 1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        return (Seq)((TraversableLike)outputColNames.zip((GenIterable)Predef$.MODULE$.wrapIntArray(numAttrsArray), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(dropLast){
            public static final long serialVersionUID = 0L;
            private final boolean dropLast$2;

            public final AttributeGroup apply(Tuple2<String, Object> x0$6) {
                Tuple2<String, Object> tuple2 = x0$6;
                if (tuple2 != null) {
                    String outputColName = (String)tuple2._1();
                    int numAttrs = tuple2._2$mcI$sp();
                    AttributeGroup attributeGroup = OneHotEncoderCommon$.MODULE$.createAttrGroupForAttrNames(outputColName, numAttrs, this.dropLast$2, false);
                    return attributeGroup;
                }
                throw new MatchError(tuple2);
            }
            {
                this.dropLast$2 = dropLast$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public AttributeGroup createAttrGroupForAttrNames(String outputColName, int numAttrs, boolean dropLast, boolean keepInvalid) {
        String[] outputAttrNames = (String[])Array$.MODULE$.tabulate(numAttrs, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int x$10) {
                return ((Object)BoxesRunTime.boxToInteger((int)x$10)).toString();
            }
        }, ClassTag$.MODULE$.apply(String.class));
        String[] filtered = dropLast && !keepInvalid ? (String[])Predef$.MODULE$.refArrayOps((Object[])outputAttrNames).dropRight(1) : (!dropLast && keepInvalid ? (String[])Predef$.MODULE$.refArrayOps((Object[])outputAttrNames).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalidValues"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : outputAttrNames);
        return this.genOutputAttrGroup((Option<String[]>)new Some((Object)filtered), outputColName);
    }

    private OneHotEncoderCommon$() {
        MODULE$ = this;
    }
}

