/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.security;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.security.HadoopDelegationTokenProvider;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma!\u0002\u0006\f\u0001E9\u0002\"B\u0015\u0001\t\u0003Y\u0003\"\u0002\u0018\u0001\t\u0003z\u0003bB\u001e\u0001\u0005\u0004%I\u0001\u0010\u0005\u0007\t\u0002\u0001\u000b\u0011B\u001f\t\u000b\u0015\u0003A\u0011\u0002$\t\u000bE\u0003A\u0011\t*\t\u000bu\u0003A\u0011\t0\t\u000b9\u0004A\u0011B8\t\u000f\u0005\r\u0001\u0001\"\u0003\u0002\u0006\tY\u0002*\u001b<f\t\u0016dWmZ1uS>tGk\\6f]B\u0013xN^5eKJT!\u0001D\u0007\u0002\u0011M,7-\u001e:jifT!AD\b\u0002\t!Lg/\u001a\u0006\u0003!E\t1a]9m\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7\u0003\u0002\u0001\u0019=\r\u0002\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0007CA\u0010\"\u001b\u0005\u0001#B\u0001\u0007\u0012\u0013\t\u0011\u0003EA\u000fIC\u0012|w\u000e\u001d#fY\u0016<\u0017\r^5p]R{7.\u001a8Qe>4\u0018\u000eZ3s!\t!s%D\u0001&\u0015\t1\u0013#\u0001\u0005j]R,'O\\1m\u0013\tASEA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001\f\t\u0003[\u0001i\u0011aC\u0001\fg\u0016\u0014h/[2f\u001d\u0006lW-F\u00011!\t\t\u0004H\u0004\u00023mA\u00111GG\u0007\u0002i)\u0011QGK\u0001\u0007yI|w\u000e\u001e \n\u0005]R\u0012A\u0002)sK\u0012,g-\u0003\u0002:u\t11\u000b\u001e:j]\u001eT!a\u000e\u000e\u0002+\rd\u0017m]:O_R4u.\u001e8e\u000bJ\u0014xN]*ueV\tQ\b\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u0006!A.\u00198h\u0015\u0005\u0011\u0015\u0001\u00026bm\u0006L!!O \u0002-\rd\u0017m]:O_R4u.\u001e8e\u000bJ\u0014xN]*ue\u0002\n\u0001\u0002[5wK\u000e{gN\u001a\u000b\u0003\u000f>\u0003\"\u0001S'\u000e\u0003%S!AS&\u0002\t\r|gN\u001a\u0006\u0003\u0019N\ta\u0001[1e_>\u0004\u0018B\u0001(J\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")\u0001+\u0002a\u0001\u000f\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u00021\u0011,G.Z4bi&|g\u000eV8lK:\u001c(+Z9vSJ,G\rF\u0002T-r\u0003\"!\u0007+\n\u0005US\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006/\u001a\u0001\r\u0001W\u0001\ngB\f'o[\"p]\u001a\u0004\"!\u0017.\u000e\u0003EI!aW\t\u0003\u0013M\u0003\u0018M]6D_:4\u0007\"\u0002)\u0007\u0001\u00049\u0015AF8ci\u0006Lg\u000eR3mK\u001e\fG/[8o)>\\WM\\:\u0015\t}+gm\u001a\t\u00043\u0001\u0014\u0017BA1\u001b\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011dY\u0005\u0003Ij\u0011A\u0001T8oO\")\u0001k\u0002a\u0001\u000f\")qk\u0002a\u00011\")\u0001n\u0002a\u0001S\u0006)1M]3egB\u0011!\u000e\\\u0007\u0002W*\u0011AbS\u0005\u0003[.\u00141b\u0011:fI\u0016tG/[1mg\u0006aAm\\!t%\u0016\fG.V:feV\u0011\u0001o\u001d\u000b\u0003cr\u0004\"A]:\r\u0001\u0011)A\u000f\u0003b\u0001k\n\tA+\u0005\u0002wsB\u0011\u0011d^\u0005\u0003qj\u0011qAT8uQ&tw\r\u0005\u0002\u001au&\u00111P\u0007\u0002\u0004\u0003:L\bBB?\t\t\u0003\u0007a0\u0001\u0002g]B\u0019\u0011d`9\n\u0007\u0005\u0005!D\u0001\u0005=Eft\u0017-\\3?\u0003)!xn[3o\u00032L\u0017m]\u000b\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001bY\u0015AA5p\u0013\u0011\t\t\"a\u0003\u0003\tQ+\u0007\u0010\u001e")
public class HiveDelegationTokenProvider
implements HadoopDelegationTokenProvider,
Logging {
    private final String classNotFoundErrorStr;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String serviceName() {
        return "hive";
    }

    private String classNotFoundErrorStr() {
        return this.classNotFoundErrorStr;
    }

    private Configuration hiveConf(Configuration hadoopConf) {
        HiveConf hiveConf;
        try {
            hiveConf = new HiveConf(hadoopConf, HiveConf.class);
        }
        catch (Throwable throwable) {
            Configuration configuration;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fail to create Hive Configuration", e);
                configuration = hadoopConf;
            } else if (throwable2 instanceof NoClassDefFoundError) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> this.classNotFoundErrorStr());
                configuration = hadoopConf;
            } else {
                throw throwable;
            }
            hiveConf = configuration;
        }
        return hiveConf;
    }

    public boolean delegationTokensRequired(SparkConf sparkConf, Configuration hadoopConf) {
        Token currentToken = UserGroupInformation.getCurrentUser().getCredentials().getToken(this.tokenAlias());
        return currentToken == null && UserGroupInformation.isSecurityEnabled() && new StringOps(Predef$.MODULE$.augmentString(this.hiveConf(hadoopConf).getTrimmed("hive.metastore.uris", ""))).nonEmpty() && (SparkHadoopUtil$.MODULE$.get().isProxyUser(UserGroupInformation.getCurrentUser()) || !Utils$.MODULE$.isClientMode(sparkConf) && !sparkConf.contains((ConfigEntry)package$.MODULE$.KEYTAB()));
    }

    public Option<Object> obtainDelegationTokens(Configuration hadoopConf, SparkConf sparkConf, Credentials creds) {
        None$ none$;
        try {
            try {
                Configuration conf = this.hiveConf(hadoopConf);
                String principalKey = "hive.metastore.kerberos.principal";
                String principal = conf.getTrimmed(principalKey, "");
                Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(principal)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Hive principal ").append(principalKey).append(" undefined").toString());
                String metastoreUri = conf.getTrimmed("hive.metastore.uris", "");
                Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(metastoreUri)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Hive metastore uri undefined");
                UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Getting Hive delegation token for ").append(currentUser.getUserName()).append(" against ").append(principal).append(" at ").append(metastoreUri).toString());
                this.doAsRealUser((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Hive hive = Hive.get((Configuration)conf, HiveConf.class);
                    String tokenStr = hive.getDelegationToken(currentUser.getUserName(), principal);
                    Token hive2Token = new Token();
                    hive2Token.decodeFromUrlString(tokenStr);
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Get Token from hive metastore: ").append(hive2Token.toString()).toString());
                    creds.addToken(this.tokenAlias(), hive2Token);
                });
                none$ = None$.MODULE$;
            }
            catch (Throwable throwable) {
                None$ none$2;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> Utils$.MODULE$.createFailedToGetTokenMessage(this.serviceName(), e));
                    none$2 = None$.MODULE$;
                } else if (throwable2 instanceof NoClassDefFoundError) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> this.classNotFoundErrorStr());
                    none$2 = None$.MODULE$;
                } else {
                    throw throwable;
                }
                none$ = none$2;
            }
        }
        finally {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Hive.closeCurrent());
        }
        return none$;
    }

    private <T> T doAsRealUser(Function0<T> fn) {
        Object object;
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        UserGroupInformation realUser = (UserGroupInformation)Option$.MODULE$.apply((Object)currentUser.getRealUser()).getOrElse((Function0 & Serializable & scala.Serializable)() -> currentUser);
        try {
            object = realUser.doAs(new PrivilegedExceptionAction<T>(null, fn){
                private final Function0 fn$1;

                public T run() {
                    return (T)this.fn$1.apply();
                }
                {
                    this.fn$1 = fn$1;
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            throw (Throwable)Option$.MODULE$.apply((Object)e.getCause()).getOrElse((Function0 & Serializable & scala.Serializable)() -> e);
        }
        return (T)object;
    }

    private Text tokenAlias() {
        return new Text("hive.server2.delegation.token");
    }

    public HiveDelegationTokenProvider() {
        Logging.$init$((Logging)this);
        this.classNotFoundErrorStr = new StringBuilder(93).append("You are attempting to use the ").append(this.getClass().getCanonicalName()).append(", but your Spark distribution is not built with Hive libraries.").toString();
    }
}

