/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoDir;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.command.CreateTableCommand;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.hive.execution.CreateHiveTableAsSelectCommand;
import org.apache.spark.sql.hive.execution.InsertIntoHiveDirCommand;
import org.apache.spark.sql.hive.execution.InsertIntoHiveTable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.runtime.LambdaDeserialize;

public final class HiveAnalysis$
extends Rule<LogicalPlan> {
    public static HiveAnalysis$ MODULE$;

    static {
        new HiveAnalysis$();
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return plan.resolveOperators((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_18;
                boolean bl = false;
                CreateTable createTable = null;
                A1 A1 = x1;
                if (A1 instanceof InsertIntoTable) {
                    HiveTableRelation hiveTableRelation;
                    InsertIntoTable insertIntoTable = (InsertIntoTable)A1;
                    LogicalPlan r = insertIntoTable.table();
                    Map partSpec = insertIntoTable.partition();
                    LogicalPlan query = insertIntoTable.query();
                    boolean overwrite = insertIntoTable.overwrite();
                    boolean ifPartitionNotExists = insertIntoTable.ifPartitionNotExists();
                    if (r instanceof HiveTableRelation && DDLUtils$.MODULE$.isHiveTable((hiveTableRelation = (HiveTableRelation)r).tableMeta())) {
                        InsertIntoHiveTable insertIntoHiveTable = new InsertIntoHiveTable(hiveTableRelation.tableMeta(), (Map<String, Option<String>>)partSpec, query, overwrite, ifPartitionNotExists, (Seq<String>)((Seq)query.output().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())));
                        return var3_18;
                    }
                }
                if (A1 instanceof CreateTable) {
                    bl = true;
                    createTable = (CreateTable)A1;
                    CatalogTable tableDesc = createTable.tableDesc();
                    SaveMode mode = createTable.mode();
                    Option option = createTable.query();
                    if (None$.MODULE$.equals(option) && DDLUtils$.MODULE$.isHiveTable(tableDesc)) {
                        DDLUtils$.MODULE$.checkDataColNames(tableDesc);
                        SaveMode saveMode = mode;
                        SaveMode saveMode2 = SaveMode.Ignore;
                        CreateTableCommand createTableCommand = new CreateTableCommand(tableDesc, !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null));
                        return var3_18;
                    }
                }
                if (bl) {
                    CatalogTable tableDesc = createTable.tableDesc();
                    SaveMode mode = createTable.mode();
                    Option option = createTable.query();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        LogicalPlan query = (LogicalPlan)some.value();
                        if (DDLUtils$.MODULE$.isHiveTable(tableDesc)) {
                            DDLUtils$.MODULE$.checkDataColNames(tableDesc);
                            CreateHiveTableAsSelectCommand createHiveTableAsSelectCommand = new CreateHiveTableAsSelectCommand(tableDesc, query, (Seq<String>)((Seq)query.output().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom())), mode);
                            return var3_18;
                        }
                    }
                }
                if (A1 instanceof InsertIntoDir) {
                    InsertIntoDir insertIntoDir = (InsertIntoDir)A1;
                    boolean isLocal = insertIntoDir.isLocal();
                    CatalogStorageFormat storage = insertIntoDir.storage();
                    Option provider = insertIntoDir.provider();
                    LogicalPlan child = insertIntoDir.child();
                    boolean overwrite = insertIntoDir.overwrite();
                    if (DDLUtils$.MODULE$.isHiveTable(provider)) {
                        Path outputPath = new Path((URI)storage.locationUri().get());
                        if (overwrite) {
                            DDLUtils$.MODULE$.verifyNotReadPath(child, outputPath);
                        }
                        InsertIntoHiveDirCommand insertIntoHiveDirCommand = new InsertIntoHiveDirCommand(isLocal, storage, child, overwrite, (Seq<String>)((Seq)child.output().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())));
                        return var3_18;
                    }
                }
                Object object = function1.apply(x1);
                return var3_18;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                HiveTableRelation hiveTableRelation;
                InsertIntoTable insertIntoTable;
                LogicalPlan r;
                boolean bl = false;
                CreateTable createTable = null;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof InsertIntoTable && (r = (insertIntoTable = (InsertIntoTable)logicalPlan).table()) instanceof HiveTableRelation && DDLUtils$.MODULE$.isHiveTable((hiveTableRelation = (HiveTableRelation)r).tableMeta())) {
                    return true;
                }
                if (logicalPlan instanceof CreateTable) {
                    bl = true;
                    createTable = (CreateTable)logicalPlan;
                    CatalogTable tableDesc = createTable.tableDesc();
                    Option option = createTable.query();
                    if (None$.MODULE$.equals(option) && DDLUtils$.MODULE$.isHiveTable(tableDesc)) {
                        return true;
                    }
                }
                if (bl) {
                    CatalogTable tableDesc = createTable.tableDesc();
                    Option option = createTable.query();
                    if (option instanceof Some && DDLUtils$.MODULE$.isHiveTable(tableDesc)) {
                        return true;
                    }
                }
                if (!(logicalPlan instanceof InsertIntoDir)) return false;
                InsertIntoDir insertIntoDir = (InsertIntoDir)logicalPlan;
                Option provider = insertIntoDir.provider();
                if (!DDLUtils$.MODULE$.isHiveTable(provider)) return false;
                return true;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.expressions.Attribute ), $anonfun$applyOrElse$4(org.apache.spark.sql.catalyst.expressions.Attribute ), $anonfun$applyOrElse$5(org.apache.spark.sql.catalyst.expressions.Attribute )}, serializedLambda);
            }
        });
    }

    private HiveAnalysis$() {
        MODULE$ = this;
    }
}

