/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.optimizer.ConstantFolding$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$DefaultColumnAnalyzer$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalogCapability;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ResolveDefaultColumns$ {
    public static ResolveDefaultColumns$ MODULE$;
    private final String CURRENT_DEFAULT_COLUMN_METADATA_KEY;
    private final String EXISTS_DEFAULT_COLUMN_METADATA_KEY;
    private final String CURRENT_DEFAULT_COLUMN_NAME;

    static {
        new ResolveDefaultColumns$();
    }

    public String CURRENT_DEFAULT_COLUMN_METADATA_KEY() {
        return this.CURRENT_DEFAULT_COLUMN_METADATA_KEY;
    }

    public String EXISTS_DEFAULT_COLUMN_METADATA_KEY() {
        return this.EXISTS_DEFAULT_COLUMN_METADATA_KEY;
    }

    public String CURRENT_DEFAULT_COLUMN_NAME() {
        return this.CURRENT_DEFAULT_COLUMN_NAME;
    }

    public StructType constantFoldCurrentDefaultsToExistDefaults(StructType tableSchema, String statementType) {
        if (SQLConf$.MODULE$.get().enableDefaultColumns()) {
            Seq newFields = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
                if (field.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY())) {
                    Metadata newMetadata;
                    Expression analyzed = MODULE$.analyze((StructField)field, statementType, MODULE$.analyze$default$3());
                    Metadata x$1 = newMetadata = new MetadataBuilder().withMetadata(field.metadata()).putString(MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), analyzed.sql()).build();
                    String x$2 = field.copy$default$1();
                    DataType x$3 = field.copy$default$2();
                    boolean x$4 = field.copy$default$3();
                    return field.copy(x$2, x$3, x$4, x$1);
                }
                return field;
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            return StructType$.MODULE$.apply((Seq<StructField>)newFields);
        }
        return tableSchema;
    }

    public void validateCatalogForDefaultValue(StructType schema, TableCatalog catalog, Identifier ident) {
        if (SQLConf$.MODULE$.get().enableDefaultColumns() && schema.exists((Function1<StructField, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$validateCatalogForDefaultValue$1(x$1))) && !catalog.capabilities().contains((Object)TableCatalogCapability.SUPPORT_COLUMN_DEFAULT_VALUE)) {
            throw QueryCompilationErrors$.MODULE$.unsupportedTableOperationError(catalog, ident, "column default value");
        }
    }

    public void validateTableProviderForDefaultValue(StructType schema, Option<String> tableProvider, String statementType, boolean addNewColumnToExistingTable) {
        if (SQLConf$.MODULE$.get().enableDefaultColumns() && schema.exists((Function1<StructField, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$validateTableProviderForDefaultValue$1(x$2)))) {
            String[] keywords = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.DEFAULT_COLUMN_ALLOWED_PROVIDERS()).toLowerCase().split(","))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            String[] allowedTableProviders = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keywords)).map((Function1 & Serializable & scala.Serializable)x$4 -> new StringOps(Predef$.MODULE$.augmentString(x$4)).stripSuffix("*"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            String[] addColumnExistingTableBannedProviders = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keywords)).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.endsWith("*"))))).map((Function1 & Serializable & scala.Serializable)x$6 -> new StringOps(Predef$.MODULE$.augmentString(x$6)).stripSuffix("*"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            String givenTableProvider = ((String)tableProvider.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toLowerCase();
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allowedTableProviders)).contains((Object)givenTableProvider)) {
                throw QueryCompilationErrors$.MODULE$.defaultReferencesNotAllowedInDataSource(statementType, givenTableProvider);
            }
            if (addNewColumnToExistingTable && new StringOps(Predef$.MODULE$.augmentString(givenTableProvider)).nonEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])addColumnExistingTableBannedProviders)).contains((Object)givenTableProvider)) {
                throw QueryCompilationErrors$.MODULE$.addNewDefaultColumnToExistingTableNotAllowed(statementType, givenTableProvider);
            }
            return;
        }
    }

    public Expression analyze(StructField field, String statementType, String metadataKey) {
        return this.analyze(field.name(), field.dataType(), field.metadata().getString(metadataKey), statementType);
    }

    public Expression analyze(String colName, DataType dataType, String defaultSQL, String statementType) {
        LogicalPlan logicalPlan;
        Expression expression;
        LazyRef parser$lzy = new LazyRef();
        try {
            expression = ResolveDefaultColumns$.parser$1(parser$lzy).parseExpression(defaultSQL);
        }
        catch (ParseException ex) {
            throw new AnalysisException(new StringBuilder(133).append("Failed to execute ").append(statementType).append(" command because the destination table column ").append(colName).append(" has a DEFAULT value of ").append(defaultSQL).append(" which fails to parse as a valid ").append("expression: ").append(ex.getMessage()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7(), AnalysisException$.MODULE$.$lessinit$greater$default$8());
        }
        Expression parsed = expression;
        if (parsed.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())) {
            throw QueryCompilationErrors$.MODULE$.defaultValuesMayNotContainSubQueryExpressions();
        }
        try {
            ResolveDefaultColumns$DefaultColumnAnalyzer$ analyzer = ResolveDefaultColumns$DefaultColumnAnalyzer$.MODULE$;
            Expression x$1 = parsed;
            String x$2 = colName;
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq<String> x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            LogicalPlan analyzed = analyzer.execute(new Project((Seq<NamedExpression>)((Seq)new .colon.colon((Object)new Alias(x$1, x$2, x$3, x$4, x$5, x$6), (List)Nil$.MODULE$)), new OneRowRelation()));
            analyzer.checkAnalysis(analyzed);
            logicalPlan = ConstantFolding$.MODULE$.apply(analyzed);
        }
        catch (AnalysisException ex) {
            throw new AnalysisException(new StringBuilder(135).append("Failed to execute ").append(statementType).append(" command because the destination table column ").append(colName).append(" has a DEFAULT value of ").append(defaultSQL).append(" which fails to resolve as a valid ").append("expression: ").append(ex.getMessage()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7(), AnalysisException$.MODULE$.$lessinit$greater$default$8());
        }
        LogicalPlan plan2 = logicalPlan;
        Expression analyzed = (Expression)plan2.collectFirst(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Project) {
                    NamedExpression a;
                    Project project = (Project)A1;
                    Seq<NamedExpression> seq = project.projectList();
                    LogicalPlan logicalPlan = project.child();
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (a = (NamedExpression)((SeqLike)some.get()).apply(0)) instanceof Alias) {
                        Alias alias = (Alias)a;
                        if (logicalPlan instanceof OneRowRelation) {
                            return (B1)alias.child();
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof Project) {
                    NamedExpression a;
                    Project project = (Project)logicalPlan;
                    Seq<NamedExpression> seq = project.projectList();
                    LogicalPlan logicalPlan2 = project.child();
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (a = (NamedExpression)((SeqLike)some.get()).apply(0)) instanceof Alias && logicalPlan2 instanceof OneRowRelation) {
                        return true;
                    }
                }
                return false;
            }
        }).get();
        DataType dataType2 = dataType;
        DataType dataType3 = analyzed.dataType();
        if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
            return analyzed;
        }
        if (Cast$.MODULE$.canUpCast(analyzed.dataType(), dataType)) {
            return new Cast(analyzed, dataType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
        }
        throw new AnalysisException(new StringBuilder(153).append("Failed to execute ").append(statementType).append(" command because the destination table column ").append(colName).append(" has a DEFAULT value with type ").append(dataType).append(", but the ").append("statement provided a value of incompatible type ").append(analyzed.dataType()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7(), AnalysisException$.MODULE$.$lessinit$greater$default$8());
    }

    public String analyze$default$3() {
        return this.CURRENT_DEFAULT_COLUMN_METADATA_KEY();
    }

    public String normalizeFieldName(String str) {
        if (SQLConf$.MODULE$.get().caseSensitiveAnalysis()) {
            return str;
        }
        return str.toLowerCase();
    }

    public Object[] getExistenceDefaultValues(StructType schema) {
        return (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            Option<String> defaultValue = field.getExistenceDefaultValue();
            return defaultValue.map((Function1 & Serializable & scala.Serializable)text -> {
                Expression expression;
                try {
                    Expression expr;
                    Expression expression2 = expr = MODULE$.analyze((StructField)field, "", MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY());
                    if (!(expression2 instanceof Literal ? true : expression2 instanceof Cast)) {
                        throw new MatchError((Object)expression2);
                    }
                    expression = expr;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof AnalysisException ? true : throwable2 instanceof MatchError) {
                        throw QueryCompilationErrors$.MODULE$.failedToParseExistenceDefaultAsLiteral(field.name(), (String)text);
                    }
                    throw throwable;
                }
                Expression expr = expression;
                return expr.eval(expr.eval$default$1());
            }).orNull(Predef$.MODULE$.$conforms());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
    }

    public boolean[] getExistenceDefaultsBitmask(StructType schema) {
        return (boolean[])Array$.MODULE$.fill(Predef$.MODULE$.genericArrayOps((Object)schema.existenceDefaultValues()).size(), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true, ClassTag$.MODULE$.Boolean());
    }

    public void resetExistenceDefaultsBitmask(StructType schema) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.genericArrayOps((Object)schema.existenceDefaultValues()).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            schema$1.existenceDefaultsBitmask()[i] = schema.existenceDefaultValues()[i] != null;
        });
    }

    public void applyExistenceDefaultValuesToRow(StructType schema, InternalRow row) {
        if (schema.hasExistenceDefaultValues()) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.genericArrayOps((Object)schema.existenceDefaultValues()).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (schema.existenceDefaultsBitmask()[i]) {
                    row.update(i, schema.existenceDefaultValues()[i]);
                    return;
                }
            });
            return;
        }
    }

    public Seq<Tuple3<String, String, String>> getDescribeMetadata(StructType schema) {
        ArrayBuffer rows;
        block0: {
            rows = new ArrayBuffer();
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$getDescribeMetadata$1(x$7)))) break block0;
            rows.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"", (Object)"", (Object)"")}));
            rows.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"# Column Default Values", (Object)"", (Object)"")}));
            schema.foreach((Function1 & Serializable & scala.Serializable)column -> column.getCurrentDefaultValue().map((Function1 & Serializable & scala.Serializable)value -> {
                rows.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)column.name(), (Object)column.dataType().simpleString(), (Object)value)}));
                return BoxedUnit.UNIT;
            }));
        }
        return rows.toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$validateCatalogForDefaultValue$1(StructField x$1) {
        return x$1.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY());
    }

    public static final /* synthetic */ boolean $anonfun$validateTableProviderForDefaultValue$1(StructField x$2) {
        return x$2.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY());
    }

    private static final /* synthetic */ CatalystSqlParser parser$lzycompute$1(LazyRef parser$lzy$1) {
        CatalystSqlParser catalystSqlParser;
        LazyRef lazyRef = parser$lzy$1;
        synchronized (lazyRef) {
            catalystSqlParser = parser$lzy$1.initialized() ? (CatalystSqlParser)parser$lzy$1.value() : (CatalystSqlParser)parser$lzy$1.initialize((Object)new CatalystSqlParser());
        }
        return catalystSqlParser;
    }

    private static final CatalystSqlParser parser$1(LazyRef parser$lzy$1) {
        if (parser$lzy$1.initialized()) {
            return (CatalystSqlParser)parser$lzy$1.value();
        }
        return ResolveDefaultColumns$.parser$lzycompute$1(parser$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$getDescribeMetadata$1(StructField x$7) {
        return x$7.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY());
    }

    private ResolveDefaultColumns$() {
        MODULE$ = this;
        this.CURRENT_DEFAULT_COLUMN_METADATA_KEY = "CURRENT_DEFAULT";
        this.EXISTS_DEFAULT_COLUMN_METADATA_KEY = "EXISTS_DEFAULT";
        this.CURRENT_DEFAULT_COLUMN_NAME = "DEFAULT";
    }
}

