/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.CovPopulation;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.RegrIntercept$;
import org.apache.spark.sql.catalyst.expressions.aggregate.VariancePop;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(y, x) - Returns the intercept of the univariate linear regression line for non-null pairs in a group, where `y` is the dependent variable and `x` is the independent variable.", examples="\n    Examples:\n      > SELECT _FUNC_(y, x) FROM VALUES (1,1), (2,2), (3,3) AS tab(y, x);\n       0.0\n      > SELECT _FUNC_(y, x) FROM VALUES (1, null) AS tab(y, x);\n       NULL\n      > SELECT _FUNC_(y, x) FROM VALUES (null, 1) AS tab(y, x);\n       NULL\n  ", group="agg_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0001\t%a\u0001B\u0013'\u0001VB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t%\u0002\u0011\t\u0012)A\u0005\t\"A1\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005U\u0001\tE\t\u0015!\u0003E\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u001dQ\u0006A1A\u0005\nmCaa\u0018\u0001!\u0002\u0013a\u0006b\u00021\u0001\u0005\u0004%I!\u0019\u0005\u0007K\u0002\u0001\u000b\u0011\u00022\t\u000b\u0019\u0004A\u0011I4\t\u000b-\u0004A\u0011\t7\t\u000bM\u0004A\u0011\t;\t\u0015\u0005%\u0001\u0001#b\u0001\n\u0003\nY\u0001\u0003\u0006\u0002\u0016\u0001A)\u0019!C!\u0003/A!\"a\u0007\u0001\u0011\u000b\u0007I\u0011IA\f\u0011)\ti\u0002\u0001EC\u0002\u0013\u0005\u0013q\u0003\u0005\n\u0003?\u0001\u0001R1A\u0005BEC!\"!\t\u0001\u0011\u000b\u0007I\u0011IA\u0006\u0011\u001d\t\u0019\u0003\u0001C!\u0003KAq!a\u000e\u0001\t#\nI\u0004C\u0005\u0002D\u0001\t\t\u0011\"\u0001\u0002F!I\u00111\n\u0001\u0012\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003G\u0002\u0011\u0013!C\u0001\u0003\u001bB\u0011\"!\u001a\u0001\u0003\u0003%\t%a\u001a\t\u0013\u0005]\u0004!!A\u0005\u0002\u0005e\u0004\"CAA\u0001\u0005\u0005I\u0011AAB\u0011%\ty\tAA\u0001\n\u0003\n\t\nC\u0005\u0002 \u0002\t\t\u0011\"\u0001\u0002\"\"I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0013qU\u0004\n\u0003\u00174\u0013\u0011!E\u0001\u0003\u001b4\u0001\"\n\u0014\u0002\u0002#\u0005\u0011q\u001a\u0005\u0007+~!\t!!8\t\u0013\u0005}w$!A\u0005F\u0005\u0005\b\"CAr?\u0005\u0005I\u0011QAs\u0011%\tYoHA\u0001\n\u0003\u000bi\u000fC\u0005\u0002\u0000~\t\t\u0011\"\u0003\u0003\u0002\ti!+Z4s\u0013:$XM]2faRT!a\n\u0015\u0002\u0013\u0005<wM]3hCR,'BA\u0015+\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005-b\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00055r\u0013aA:rY*\u0011q\u0006M\u0001\u0006gB\f'o\u001b\u0006\u0003cI\na!\u00199bG\",'\"A\u001a\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u00011$HP$N!\t9\u0004(D\u0001'\u0013\tIdE\u0001\u000bEK\u000ed\u0017M]1uSZ,\u0017iZ4sK\u001e\fG/\u001a\t\u0003wqj\u0011\u0001K\u0005\u0003{!\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0004\u007f\t#U\"\u0001!\u000b\u0005\u0005S\u0013!\u0002;sK\u0016\u001c\u0018BA\"A\u0005)\u0011\u0015N\\1ss2K7.\u001a\t\u0003w\u0015K!A\u0012\u0015\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015JA\u0004Qe>$Wo\u0019;\u0011\u0005!s\u0015BA(J\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003\u0011\u000bQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002X1f\u0003\"a\u000e\u0001\t\u000bA+\u0001\u0019\u0001#\t\u000bM+\u0001\u0019\u0001#\u0002\u0011\r|g/\u0019:Q_B,\u0012\u0001\u0018\t\u0003ouK!A\u0018\u0014\u0003\u001b\r{g\u000fU8qk2\fG/[8o\u0003%\u0019wN^1s!>\u0004\b%\u0001\u0004wCJ\u0004v\u000e]\u000b\u0002EB\u0011qgY\u0005\u0003I\u001a\u00121BV1sS\u0006t7-\u001a)pa\u00069a/\u0019:Q_B\u0004\u0013\u0001\u00038vY2\f'\r\\3\u0016\u0003!\u0004\"\u0001S5\n\u0005)L%a\u0002\"p_2,\u0017M\\\u0001\tI\u0006$\u0018\rV=qKV\tQ\u000e\u0005\u0002oc6\tqN\u0003\u0002qY\u0005)A/\u001f9fg&\u0011!o\u001c\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003U\u0004BA\u001e@\u0002\u00049\u0011q\u000f \b\u0003qnl\u0011!\u001f\u0006\u0003uR\na\u0001\u0010:p_Rt\u0014\"\u0001&\n\u0005uL\u0015a\u00029bG.\fw-Z\u0005\u0004\u007f\u0006\u0005!aA*fc*\u0011Q0\u0013\t\u0004]\u0006\u0015\u0011bAA\u0004_\nQAi\\;cY\u0016$\u0016\u0010]3\u0002'\u0005<wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u0016\u0005\u00055\u0001\u0003\u0002<\u007f\u0003\u001f\u00012aOA\t\u0013\r\t\u0019\u0002\u000b\u0002\u0013\u0003R$(/\u001b2vi\u0016\u0014VMZ3sK:\u001cW-A\u0007j]&$\u0018.\u00197WC2,Xm]\u000b\u0003\u00033\u00012A\u001e@E\u0003E)\b\u000fZ1uK\u0016C\bO]3tg&|gn]\u0001\u0011[\u0016\u0014x-Z#yaJ,7o]5p]N\f!#\u001a<bYV\fG/Z#yaJ,7o]5p]\u0006A\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002(A!\u0011\u0011FA\u0019\u001d\u0011\tY#!\f\u0011\u0005aL\u0015bAA\u0018\u0013\u00061\u0001K]3eK\u001aLA!a\r\u00026\t11\u000b\u001e:j]\u001eT1!a\fJ\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003X\u0003w\ty\u0004\u0003\u0004\u0002>Q\u0001\r\u0001R\u0001\b]\u0016<H*\u001a4u\u0011\u0019\t\t\u0005\u0006a\u0001\t\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#B,\u0002H\u0005%\u0003b\u0002)\u0016!\u0003\u0005\r\u0001\u0012\u0005\b'V\u0001\n\u00111\u0001E\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0014+\u0007\u0011\u000b\tf\u000b\u0002\u0002TA!\u0011QKA0\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013!C;oG\",7m[3e\u0015\r\ti&S\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA1\u0003/\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA5!\u0011\tY'!\u001e\u000e\u0005\u00055$\u0002BA8\u0003c\nA\u0001\\1oO*\u0011\u00111O\u0001\u0005U\u00064\u0018-\u0003\u0003\u00024\u00055\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAA>!\rA\u0015QP\u0005\u0004\u0003\u007fJ%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAC\u0003\u0017\u00032\u0001SAD\u0013\r\tI)\u0013\u0002\u0004\u0003:L\b\"CAG5\u0005\u0005\t\u0019AA>\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0013\t\u0007\u0003+\u000bY*!\"\u000e\u0005\u0005]%bAAM\u0013\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u0015q\u0013\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002i\u0003GC\u0011\"!$\u001d\u0003\u0003\u0005\r!!\"\u0002\r\u0015\fX/\u00197t)\rA\u0017\u0011\u0016\u0005\n\u0003\u001bk\u0012\u0011!a\u0001\u0003\u000bC3\u0003AAW\u0003g\u000b),!/\u0002<\u0006}\u0016\u0011YAc\u0003\u000f\u00042aOAX\u0013\r\t\t\f\u000b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t9,AA6?\u001a+fjQ0)s2\u0002\u00030\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011j]R,'oY3qi\u0002zg\r\t;iK\u0002*h.\u001b<be&\fG/\u001a\u0011mS:,\u0017M\u001d\u0011sK\u001e\u0014Xm]:j_:\u0004C.\u001b8fA\u0019|'\u000f\t8p]6rW\u000f\u001c7!a\u0006L'o\u001d\u0011j]\u0002\n\u0007e\u001a:pkBd\u0003e\u001e5fe\u0016\u0004\u0003-\u001f1!SN\u0004C\u000f[3!I\u0016\u0004XM\u001c3f]R\u0004c/\u0019:jC\ndW\rI1oI\u0002\u0002\u0007\u0010\u0019\u0011jg\u0002\"\b.\u001a\u0011j]\u0012,\u0007/\u001a8eK:$\bE^1sS\u0006\u0014G.\u001a\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!0\u0002\u0003{T\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u001f\u0017!q&\u0002cIU(NAY\u000bE*V#TA!\nD&M\u0015-A!\u0012DFM\u0015-A!\u001aDfM\u0015!\u0003N\u0003C/\u00192)s2\u0002\u00030K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a9\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK=-AaL\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013\u0007\f\u0011ok2d\u0017\u0006I!TAQ\f'\rK=-AaL3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u001f\u0017!q&\u0002cIU(NAY\u000bE*V#TA!rW\u000f\u001c7-AEJ\u0003%Q*!i\u0006\u0014\u0007&\u001f\u0017!q&Z$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002D\u0006I\u0011mZ4`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003\u0013\fQa\r\u00185]A\nQBU3he&sG/\u001a:dKB$\bCA\u001c '\u0011y\u0012\u0011['\u0011\u000f\u0005M\u0017\u0011\u001c#E/6\u0011\u0011Q\u001b\u0006\u0004\u0003/L\u0015a\u0002:v]RLW.Z\u0005\u0005\u00037\f)NA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!!4\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u001b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b]\u000b9/!;\t\u000bA\u0013\u0003\u0019\u0001#\t\u000bM\u0013\u0003\u0019\u0001#\u0002\u000fUt\u0017\r\u001d9msR!\u0011q^A~!\u0015A\u0015\u0011_A{\u0013\r\t\u00190\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b!\u000b9\u0010\u0012#\n\u0007\u0005e\u0018J\u0001\u0004UkBdWM\r\u0005\t\u0003{\u001c\u0013\u0011!a\u0001/\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0007\u0001B!a\u001b\u0003\u0006%!!qAA7\u0005\u0019y%M[3di\u0002")
public class RegrIntercept
extends DeclarativeAggregate
implements ImplicitCastInputTypes,
BinaryLike<Expression> {
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Expression> initialValues;
    private Seq<Expression> updateExpressions;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private Seq<AttributeReference> inputAggBufferAttributes;
    private final Expression left;
    private final Expression right;
    private final CovPopulation covarPop;
    private final VariancePop varPop;
    private transient Seq<Expression> children;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(RegrIntercept regrIntercept) {
        return RegrIntercept$.MODULE$.unapply(regrIntercept);
    }

    public static Function1<Tuple2<Expression, Expression>, RegrIntercept> tupled() {
        return RegrIntercept$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, RegrIntercept>> curried() {
        return RegrIntercept$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        RegrIntercept regrIntercept = this;
        synchronized (regrIntercept) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private CovPopulation covarPop() {
        return this.covarPop;
    }

    private VariancePop varPop() {
        return this.varPop;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    public Seq<DoubleType> inputTypes() {
        return (Seq)new .colon.colon((Object)DoubleType$.MODULE$, (List)new .colon.colon((Object)DoubleType$.MODULE$, (List)Nil$.MODULE$));
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        RegrIntercept regrIntercept = this;
        synchronized (regrIntercept) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.aggBufferAttributes = (Seq)this.covarPop().aggBufferAttributes().$plus$plus(this.varPop().aggBufferAttributes(), Seq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.aggBufferAttributes$lzycompute();
        }
        return this.aggBufferAttributes;
    }

    private Seq<Expression> initialValues$lzycompute() {
        RegrIntercept regrIntercept = this;
        synchronized (regrIntercept) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.initialValues = (Seq)this.covarPop().initialValues().$plus$plus(this.varPop().initialValues(), Seq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.initialValues;
    }

    @Override
    public Seq<Expression> initialValues() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.initialValues$lzycompute();
        }
        return this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        RegrIntercept regrIntercept = this;
        synchronized (regrIntercept) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.updateExpressions = (Seq)this.covarPop().updateExpressions().$plus$plus(this.varPop().updateExpressions(), Seq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.updateExpressions$lzycompute();
        }
        return this.updateExpressions;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        RegrIntercept regrIntercept = this;
        synchronized (regrIntercept) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.mergeExpressions = (Seq)this.covarPop().mergeExpressions().$plus$plus(this.varPop().mergeExpressions(), Seq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.mergeExpressions$lzycompute();
        }
        return this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        RegrIntercept regrIntercept = this;
        synchronized (regrIntercept) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.evaluateExpression = new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.varPop().m2()).$eq$eq$eq(package$expressions$.MODULE$.doubleToLiteral(0.0))), Literal$.MODULE$.create(null, DoubleType$.MODULE$), package$expressions$.MODULE$.DslExpression(this.covarPop().yAvg()).$minus(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.covarPop().ck()).$div(this.varPop().m2())).$times(this.covarPop().xAvg())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.evaluateExpression$lzycompute();
        }
        return this.evaluateExpression;
    }

    private Seq<AttributeReference> inputAggBufferAttributes$lzycompute() {
        RegrIntercept regrIntercept = this;
        synchronized (regrIntercept) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.inputAggBufferAttributes = (Seq)this.covarPop().inputAggBufferAttributes().$plus$plus(this.varPop().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.inputAggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.inputAggBufferAttributes$lzycompute();
        }
        return this.inputAggBufferAttributes;
    }

    @Override
    public String prettyName() {
        return "regr_intercept";
    }

    @Override
    public RegrIntercept withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public RegrIntercept copy(Expression left, Expression right) {
        return new RegrIntercept(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "RegrIntercept";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegrIntercept;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegrIntercept)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegrIntercept regrIntercept = (RegrIntercept)x$1;
        Expression expression = this.left();
        Expression expression2 = regrIntercept.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = regrIntercept.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!regrIntercept.canEqual(this)) return false;
        return true;
    }

    public RegrIntercept(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        this.covarPop = new CovPopulation(right, left);
        this.varPop = new VariancePop(right);
    }
}

