/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.expressions.CsvToStructs$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(csvStr, schema[, options]) - Returns a struct value with the given `csvStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('1, 0.8', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('26/08/2015', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00}\n  ", since="3.0.0", group="csv_funcs")
@ScalaSignature(bytes="\u0006\u0001\t-f\u0001B\u001a5\u0001\u0006C\u0001B\u0019\u0001\u0003\u0016\u0004%\ta\u0019\u0005\tU\u0002\u0011\t\u0012)A\u0005I\"A1\u000e\u0001BK\u0002\u0013\u0005A\u000e\u0003\u0005|\u0001\tE\t\u0015!\u0003n\u0011!a\bA!f\u0001\n\u0003i\b\"CA\u0002\u0001\tE\t\u0015!\u0003\u007f\u0011)\t)\u0001\u0001BK\u0002\u0013\u0005\u0011q\u0001\u0005\u000b\u0003\u001f\u0001!\u0011#Q\u0001\n\u0005%\u0001BCA\t\u0001\tU\r\u0011\"\u0001\u0002\u0014!Q\u0011q\u0003\u0001\u0003\u0012\u0003\u0006I!!\u0006\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002\u0002CA\u001a\u0001\t\u0007I\u0011A2\t\u000f\u0005U\u0002\u0001)A\u0005I\"9\u0011\u0011\u0004\u0001\u0005\u0002\u0005]\u0002bBA\r\u0001\u0011\u0005\u0011q\b\u0005\b\u00033\u0001A\u0011AA#\u0011)\ti\u0005\u0001EC\u0002\u0013\u0005\u0011q\n\u0005\n\u0003o\u0002!\u0019!C\u0001\u0003sBq!a\u001f\u0001A\u0003%\u0001\u0010\u0003\u0006\u0002~\u0001A)\u0019!C\u0001\u0003\u007fBq!a$\u0001\t\u0003\n\t\nC\u0004\u0002\u001a\u0002!\t%a'\t\u000f\u0005}\u0005\u0001\"\u0011\u0002\"\"9\u0011Q\u0016\u0001\u0005B\u0005=\u0006bBA_\u0001\u0011\u0005\u0013\u0011\u0010\u0005\b\u0003\u007f\u0003A\u0011KAa\u0011%\t9\rAA\u0001\n\u0003\tI\rC\u0005\u0002V\u0002\t\n\u0011\"\u0001\u0002X\"I\u0011Q\u001e\u0001\u0012\u0002\u0013\u0005\u0011q\u001e\u0005\n\u0003g\u0004\u0011\u0013!C\u0001\u0003kD\u0011\"!?\u0001#\u0003%\t!a?\t\u0013\u0005}\b!%A\u0005\u0002\t\u0005\u0001\"\u0003B\u0003\u0001\u0005\u0005I\u0011\tB\u0004\u0011%\u00119\u0002AA\u0001\n\u0003\u0011I\u0002C\u0005\u0003\"\u0001\t\t\u0011\"\u0001\u0003$!I!\u0011\u0006\u0001\u0002\u0002\u0013\u0005#1\u0006\u0005\n\u0005o\u0001\u0011\u0011!C\u0001\u0005sA\u0011B!\u0010\u0001\u0003\u0003%\tEa\u0010\b\u0013\t\rD'!A\t\u0002\t\u0015d\u0001C\u001a5\u0003\u0003E\tAa\u001a\t\u000f\u0005e\u0011\u0006\"\u0001\u0003v!I!qO\u0015\u0002\u0002\u0013\u0015#\u0011\u0010\u0005\n\u0005wJ\u0013\u0011!CA\u0005{B\u0011B!#*#\u0003%\t!a?\t\u0013\t-\u0015&%A\u0005\u0002\t\u0005\u0001\"\u0003BGS\u0005\u0005I\u0011\u0011BH\u0011%\u0011i*KI\u0001\n\u0003\tY\u0010C\u0005\u0003 &\n\n\u0011\"\u0001\u0003\u0002!I!\u0011U\u0015\u0002\u0002\u0013%!1\u0015\u0002\r\u0007N4Hk\\*ueV\u001cGo\u001d\u0006\u0003kY\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0007O\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011HO\u0001\u0004gFd'BA\u001e=\u0003\u0015\u0019\b/\u0019:l\u0015\tid(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0005\u0019qN]4\u0004\u0001MA\u0001A\u0011$J\u001fJKv\f\u0005\u0002D\t6\tA'\u0003\u0002Fi\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002D\u000f&\u0011\u0001\n\u000e\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:\u0004\"AS'\u000e\u0003-S!\u0001\u0014\u001b\u0002\u000f\r|G-Z4f]&\u0011aj\u0013\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u00111\tU\u0005\u0003#R\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\t\u0019fK\u0004\u0002D)&\u0011Q\u000bN\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0006L\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005U#\u0004C\u0001.^\u001b\u0005Y&\"\u0001/\u0002\u000bM\u001c\u0017\r\\1\n\u0005y[&a\u0002)s_\u0012,8\r\u001e\t\u00035\u0002L!!Y.\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rM\u001c\u0007.Z7b+\u0005!\u0007CA3i\u001b\u00051'BA49\u0003\u0015!\u0018\u0010]3t\u0013\tIgM\u0001\u0006TiJ,8\r\u001e+za\u0016\fqa]2iK6\f\u0007%A\u0004paRLwN\\:\u0016\u00035\u0004BA\\;yq:\u0011qn\u001d\t\u0003ank\u0011!\u001d\u0006\u0003e\u0002\u000ba\u0001\u0010:p_Rt\u0014B\u0001;\\\u0003\u0019\u0001&/\u001a3fM&\u0011ao\u001e\u0002\u0004\u001b\u0006\u0004(B\u0001;\\!\tq\u00170\u0003\u0002{o\n11\u000b\u001e:j]\u001e\f\u0001b\u001c9uS>t7\u000fI\u0001\u0006G\"LG\u000eZ\u000b\u0002}B\u00111i`\u0005\u0004\u0003\u0003!$AC#yaJ,7o]5p]\u000611\r[5mI\u0002\n!\u0002^5nKj{g.Z%e+\t\tI\u0001\u0005\u0003[\u0003\u0017A\u0018bAA\u00077\n1q\n\u001d;j_:\f1\u0002^5nKj{g.Z%eA\u0005q!/Z9vSJ,GmU2iK6\fWCAA\u000b!\u0011Q\u00161\u00023\u0002\u001fI,\u0017/^5sK\u0012\u001c6\r[3nC\u0002\na\u0001P5oSRtD\u0003DA\u000f\u0003?\t\t#a\t\u0002&\u0005\u001d\u0002CA\"\u0001\u0011\u0015\u00117\u00021\u0001e\u0011\u0015Y7\u00021\u0001n\u0011\u0015a8\u00021\u0001\u007f\u0011%\t)a\u0003I\u0001\u0002\u0004\tI\u0001C\u0005\u0002\u0012-\u0001\n\u00111\u0001\u0002\u0016\u0005Aa.\u001e7mC\ndW-\u0006\u0002\u0002.A\u0019!,a\f\n\u0007\u0005E2LA\u0004C_>dW-\u00198\u0002\u001d9,H\u000e\\1cY\u0016\u001c6\r[3nC\u0006ya.\u001e7mC\ndWmU2iK6\f\u0007\u0005\u0006\u0005\u0002\u001e\u0005e\u00121HA\u001f\u0011\u0015ax\u00021\u0001\u007f\u0011\u0015\u0011w\u00021\u0001\u007f\u0011\u0015Yw\u00021\u0001n)\u0019\ti\"!\u0011\u0002D!)A\u0010\u0005a\u0001}\")!\r\u0005a\u0001}RA\u0011QDA$\u0003\u0013\nY\u0005C\u0003}#\u0001\u0007a\u0010C\u0003c#\u0001\u0007a\u0010C\u0003l#\u0001\u0007a0A\u0005d_:4XM\u001d;feV\u0011\u0011\u0011\u000b\t\b5\u0006M\u0013qKA4\u0013\r\t)f\u0017\u0002\n\rVt7\r^5p]F\u0002b!!\u0017\u0002b\u0005\u001dd\u0002BA.\u0003?r1\u0001]A/\u0013\u0005a\u0016BA+\\\u0013\u0011\t\u0019'!\u001a\u0003\u0011%#XM]1u_JT!!V.\u0011\t\u0005%\u00141N\u0007\u0002m%\u0019\u0011Q\u000e\u001c\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0015\u0004%\u0005E\u0004c\u0001.\u0002t%\u0019\u0011QO.\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018a\u00058b[\u0016|emQ8seV\u0004HOU3d_J$W#\u0001=\u0002)9\fW.Z(g\u0007>\u0014(/\u001e9u%\u0016\u001cwN\u001d3!\u0003\u0019\u0001\u0018M]:feV\u0011\u0011\u0011\u0011\t\u0006\u0003\u0007\u000bI\t_\u0007\u0003\u0003\u000bS1!a\"7\u0003\u0011)H/\u001b7\n\t\u0005-\u0015Q\u0011\u0002\u0012\r\u0006LG.\u001e:f'\u00064W\rU1sg\u0016\u0014\bfA\u000b\u0002r\u0005AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\u0014B\u0019Q-!&\n\u0007\u0005]eM\u0001\u0005ECR\fG+\u001f9f\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\r1\u0015Q\u0014\u0005\u0007\u0003\u000b9\u0002\u0019\u0001=\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\t\u0005\r\u0016\u0011\u0016\t\u00045\u0006\u0015\u0016bAAT7\n\u0019\u0011I\\=\t\u000f\u0005-\u0006\u00041\u0001\u0002$\u0006)\u0011N\u001c9vi\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005E\u0006CBA-\u0003g\u000b9,\u0003\u0003\u00026\u0006\u0015$aA*fcB\u0019Q-!/\n\u0007\u0005mfM\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006Q\u0001O]3uift\u0015-\\3\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\u0011\ti\"a1\t\r\u0005\u00157\u00041\u0001\u007f\u0003!qWm^\"iS2$\u0017\u0001B2paf$B\"!\b\u0002L\u00065\u0017qZAi\u0003'DqA\u0019\u000f\u0011\u0002\u0003\u0007A\rC\u0004l9A\u0005\t\u0019A7\t\u000fqd\u0002\u0013!a\u0001}\"I\u0011Q\u0001\u000f\u0011\u0002\u0003\u0007\u0011\u0011\u0002\u0005\n\u0003#a\u0002\u0013!a\u0001\u0003+\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002Z*\u001aA-a7,\u0005\u0005u\u0007\u0003BAp\u0003Sl!!!9\u000b\t\u0005\r\u0018Q]\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a:\\\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\f\tOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002r*\u001aQ.a7\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u001f\u0016\u0004}\u0006m\u0017AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003{TC!!\u0003\u0002\\\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*TC\u0001B\u0002U\u0011\t)\"a7\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011I\u0001\u0005\u0003\u0003\f\tUQB\u0001B\u0007\u0015\u0011\u0011yA!\u0005\u0002\t1\fgn\u001a\u0006\u0003\u0005'\tAA[1wC&\u0019!P!\u0004\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\tm\u0001c\u0001.\u0003\u001e%\u0019!qD.\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\r&Q\u0005\u0005\n\u0005O!\u0013\u0011!a\u0001\u00057\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0017!\u0019\u0011yC!\u000e\u0002$6\u0011!\u0011\u0007\u0006\u0004\u0005gY\u0016AC2pY2,7\r^5p]&!\u00111\rB\u0019\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0017\u0005wA\u0011Ba\n'\u0003\u0003\u0005\r!a)\u0002\r\u0015\fX/\u00197t)\u0011\tiC!\u0011\t\u0013\t\u001dr%!AA\u0002\u0005\r\u0006f\u0005\u0001\u0003F\t-#Q\nB)\u0005'\u00129F!\u0017\u0003^\t}\u0003cA\"\u0003H%\u0019!\u0011\n\u001b\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!qJ\u0001a?\u001a+fjQ0)GN48\u000b\u001e:-AM\u001c\u0007.Z7b72\u0002s\u000e\u001d;j_:\u001cX,\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007e\u001d;sk\u000e$\bE^1mk\u0016\u0004s/\u001b;iAQDW\rI4jm\u0016t\u0007\u0005Y2tmN#(\u000f\u0019\u0011b]\u0012\u0004\u0003m]2iK6\f\u0007ML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!QK\u0001\u0002<*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u0017!a9Bt\u0005\f\u0011(C\u0002Je\n\u0016\u0017!E\u0002\"u*\u0016\"M\u000b\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>#C\nR\u0014\u0007\f\u0012cEi\u0002d\u0006O?\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012dg\f\u00199_I\u0002\u0014'N\u0014-A\u001d\"\u0018.\\3!)&lWm\u001d;b[B<C\u0006I7ba\":C/[7fgR\fW\u000e\u001d$pe6\fGo\n\u0017!O\u0011$w&T'0sfL\u0018pJ\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(\u0005^5nK\nR$\u0007M\u00196[ABTF\r\u001c!aAR\u0004\u0007\r\u001e1auT\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u00057\nQa\r\u00181]A\nQa\u001a:pkB\f#A!\u0019\u0002\u0013\r\u001cho\u00184v]\u000e\u001c\u0018\u0001D\"tmR{7\u000b\u001e:vGR\u001c\bCA\"*'\u0011I#\u0011N0\u0011\u001b\t-$\u0011\u000f3n}\u0006%\u0011QCA\u000f\u001b\t\u0011iGC\u0002\u0003pm\u000bqA];oi&lW-\u0003\u0003\u0003t\t5$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8okQ\u0011!QM\u0001\ti>\u001cFO]5oOR\u0011!\u0011B\u0001\u0006CB\u0004H.\u001f\u000b\r\u0003;\u0011yH!!\u0003\u0004\n\u0015%q\u0011\u0005\u0006E2\u0002\r\u0001\u001a\u0005\u0006W2\u0002\r!\u001c\u0005\u0006y2\u0002\rA \u0005\n\u0003\u000ba\u0003\u0013!a\u0001\u0003\u0013A\u0011\"!\u0005-!\u0003\u0005\r!!\u0006\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq\"\u00199qYf$C-\u001a4bk2$H%N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tJ!'\u0011\u000bi\u000bYAa%\u0011\u0015i\u0013)\nZ7\u007f\u0003\u0013\t)\"C\u0002\u0003\u0018n\u0013a\u0001V;qY\u0016,\u0004\"\u0003BN_\u0005\u0005\t\u0019AA\u000f\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0015\u0006\u0003\u0002B\u0006\u0005OKAA!+\u0003\u000e\t1qJ\u00196fGR\u0004")
public class CsvToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient Function1<Iterator<InternalRow>, InternalRow> converter;
    private transient FailureSafeParser<String> parser;
    private final StructType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final Option<StructType> requiredSchema;
    private final StructType nullableSchema;
    private final String nameOfCorruptRecord;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<StructType> $lessinit$greater$default$5() {
        return CsvToStructs$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return CsvToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<StructType, Map<String, String>, Expression, Option<String>, Option<StructType>>> unapply(CsvToStructs csvToStructs) {
        return CsvToStructs$.MODULE$.unapply(csvToStructs);
    }

    public static Option<StructType> apply$default$5() {
        return CsvToStructs$.MODULE$.apply$default$5();
    }

    public static Option<String> apply$default$4() {
        return CsvToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple5<StructType, Map<String, String>, Expression, Option<String>, Option<StructType>>, CsvToStructs> tupled() {
        return CsvToStructs$.MODULE$.tupled();
    }

    public static Function1<StructType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, Function1<Option<StructType>, CsvToStructs>>>>> curried() {
        return CsvToStructs$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public StructType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public Option<StructType> requiredSchema() {
        return this.requiredSchema;
    }

    @Override
    public boolean nullable() {
        return this.child().nullable();
    }

    public StructType nullableSchema() {
        return this.nullableSchema;
    }

    private Function1<Iterator<InternalRow>, InternalRow> converter$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.converter = (Function1 & Serializable & scala.Serializable)rows -> {
                    if (rows.hasNext()) {
                        InternalRow result = (InternalRow)rows.next();
                        Predef$.MODULE$.assert(!rows.hasNext());
                        return result;
                    }
                    throw new IllegalStateException("Expected one row from CSV parser.");
                };
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    public Function1<Iterator<InternalRow>, InternalRow> converter() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.converter$lzycompute();
        }
        return this.converter;
    }

    public String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    private FailureSafeParser<String> parser$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                ParseMode mode;
                Map exprOptions = this.options().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lineSep"), (Object)Character.toString('\uffff'))})));
                CSVOptions parsedOptions = new CSVOptions((Map<String, String>)exprOptions, true, (String)this.timeZoneId().get(), this.nameOfCorruptRecord());
                ParseMode parseMode = mode = parsedOptions.parseMode();
                PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
                    ParseMode parseMode2 = mode;
                    FailFastMode$ failFastMode$ = FailFastMode$.MODULE$;
                    if (parseMode2 == null ? failFastMode$ != null : !parseMode2.equals(failFastMode$)) {
                        throw QueryCompilationErrors$.MODULE$.parseModeUnsupportedError("from_csv", mode);
                    }
                }
                ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(this.nullableSchema(), parsedOptions.columnNameOfCorruptRecord());
                StructType actualSchema = StructType$.MODULE$.apply((Seq<StructField>)((Seq)this.nullableSchema().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CsvToStructs.$anonfun$parser$1(parsedOptions, x$1)))));
                StructType actualRequiredSchema = StructType$.MODULE$.apply((Seq<StructField>)((Seq)((TraversableLike)this.requiredSchema().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.asNullable()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.nullableSchema())).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CsvToStructs.$anonfun$parser$4(parsedOptions, x$3)))));
                UnivocityParser rawParser = new UnivocityParser(actualSchema, actualRequiredSchema, parsedOptions);
                this.parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> Option$.MODULE$.option2Iterable((Option)rawParser.parse().apply(input)), mode, this.nullableSchema(), parsedOptions.columnNameOfCorruptRecord());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    public FailureSafeParser<String> parser() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.parser$lzycompute();
        }
        return this.parser;
    }

    @Override
    public DataType dataType() {
        return ((StructType)this.requiredSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.schema())).asNullable();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        StructType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Option<StructType> x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1, x$5);
    }

    @Override
    public Object nullSafeEval(Object input) {
        String csv = ((UTF8String)input).toString();
        return this.converter().apply(this.parser().parse(csv));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)stringType$);
    }

    @Override
    public String prettyName() {
        return "from_csv";
    }

    @Override
    public CsvToStructs withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        StructType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$4();
        Option<StructType> x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$1, x$4, x$5);
    }

    public CsvToStructs copy(StructType schema, Map<String, String> options, Expression child, Option<String> timeZoneId, Option<StructType> requiredSchema) {
        return new CsvToStructs(schema, options, child, timeZoneId, requiredSchema);
    }

    public StructType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    public Option<StructType> copy$default$5() {
        return this.requiredSchema();
    }

    @Override
    public String productPrefix() {
        return "CsvToStructs";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.schema();
            }
            case 1: {
                return this.options();
            }
            case 2: {
                return this.child();
            }
            case 3: {
                return this.timeZoneId();
            }
            case 4: {
                return this.requiredSchema();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CsvToStructs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CsvToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        CsvToStructs csvToStructs = (CsvToStructs)x$1;
        StructType structType = this.schema();
        StructType structType2 = csvToStructs.schema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!((Object)structType).equals(structType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = csvToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = csvToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = csvToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<StructType> option3 = this.requiredSchema();
        Option<StructType> option4 = csvToStructs.requiredSchema();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!csvToStructs.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$parser$1(CSVOptions parsedOptions$1, StructField x$1) {
        String string = x$1.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$parser$4(CSVOptions parsedOptions$1, StructField x$3) {
        String string = x$3.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public CsvToStructs(StructType schema, Map<String, String> options, Expression child, Option<String> timeZoneId, Option<StructType> requiredSchema) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        this.requiredSchema = requiredSchema;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.nullableSchema = schema.asNullable();
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
    }

    public CsvToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalSchemaExpr(schema), options, child, (Option<String>)None$.MODULE$, CsvToStructs$.MODULE$.$lessinit$greater$default$5());
    }

    public CsvToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public CsvToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalSchemaExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$, CsvToStructs$.MODULE$.$lessinit$greater$default$5());
    }
}

