/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Ceil;
import org.apache.spark.sql.catalyst.expressions.CeilFloorExpressionBuilderBase;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RoundCeil;
import scala.collection.Seq;

@ExpressionDescription(usage="_FUNC_(expr[, scale]) - Returns the smallest number after rounding up that is not smaller than `expr`. An optional `scale` parameter can be specified to control the rounding behavior.", examples="\n    Examples:\n      > SELECT _FUNC_(-0.1);\n       0\n      > SELECT _FUNC_(5);\n       5\n      > SELECT _FUNC_(3.1411, 3);\n       3.142\n      > SELECT _FUNC_(3.1411, -3);\n       1000\n  ", since="3.3.0", group="math_funcs")
public final class CeilExpressionBuilder$
implements CeilFloorExpressionBuilderBase {
    public static CeilExpressionBuilder$ MODULE$;

    static {
        new CeilExpressionBuilder$();
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        return CeilFloorExpressionBuilderBase.build$(this, funcName, expressions);
    }

    @Override
    public Expression buildWithOneParam(Expression param) {
        return new Ceil(param);
    }

    @Override
    public Expression buildWithTwoParams(Expression param1, Expression param2) {
        return new RoundCeil(param1, param2);
    }

    private CeilExpressionBuilder$() {
        MODULE$ = this;
        CeilFloorExpressionBuilderBase.$init$(this);
    }
}

