/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateTimeFormatterHelper;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00114AAC\u0006\u00011!Aa\u0005\u0001B\u0001B\u0003%q\u0005\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011\u0015Q\u0004\u0001\"\u0001<\u0011!y\u0004\u0001#b\u0001\n\u0013\u0001\u0005bB'\u0001\u0005\u0004%IA\u0014\u0005\u0007'\u0002\u0001\u000b\u0011B(\t\u000bQ\u0003A\u0011B+\t\u000bm\u0003A\u0011\t/\t\u000b\u0011\u0003A\u0011I1\u0003)%\u001bx\u000e\u000f\u001c1c\u0011\u000bG/\u001a$pe6\fG\u000f^3s\u0015\taQ\"\u0001\u0003vi&d'B\u0001\b\u0010\u0003!\u0019\u0017\r^1msN$(B\u0001\t\u0012\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003%M\tQa\u001d9be.T!\u0001F\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u001a?\r\u0002\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007C\u0001\u0011\"\u001b\u0005Y\u0011B\u0001\u0012\f\u00055!\u0015\r^3G_Jl\u0017\r\u001e;feB\u0011\u0001\u0005J\u0005\u0003K-\u0011q\u0003R1uKRKW.\u001a$pe6\fG\u000f^3s\u0011\u0016d\u0007/\u001a:\u0002\u000fA\fG\u000f^3s]B\u0011\u0001f\f\b\u0003S5\u0002\"AK\u000e\u000e\u0003-R!\u0001L\f\u0002\rq\u0012xn\u001c;?\u0013\tq3$\u0001\u0004Qe\u0016$WMZ\u0005\u0003aE\u0012aa\u0015;sS:<'B\u0001\u0018\u001c\u0003\u0019awnY1mKB\u0011A\u0007O\u0007\u0002k)\u0011AB\u000e\u0006\u0002o\u0005!!.\u0019<b\u0013\tITG\u0001\u0004M_\u000e\fG.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007qjd\b\u0005\u0002!\u0001!)ae\u0001a\u0001O!)!g\u0001a\u0001g\u0005Iam\u001c:nCR$XM]\u000b\u0002\u0003B\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0007M>\u0014X.\u0019;\u000b\u0005\u00193\u0014\u0001\u0002;j[\u0016L!\u0001S\"\u0003#\u0011\u000bG/\u001a+j[\u00164uN]7biR,'\u000f\u000b\u0002\u0005\u0015B\u0011!dS\u0005\u0003\u0019n\u0011\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0007U#6)F\u0001P!\t\u0001\u0016+D\u0001F\u0013\t\u0011VI\u0001\u0004[_:,\u0017\nZ\u0001\u0005+R\u001b\u0005%A\u0005u_&s7\u000f^1oiR\u0011a+\u0017\t\u0003!^K!\u0001W#\u0003\u000f%s7\u000f^1oi\")!l\u0002a\u0001O\u0005\t1/A\u0003qCJ\u001cX\r\u0006\u0002^AB\u0011!DX\u0005\u0003?n\u00111!\u00138u\u0011\u0015Q\u0006\u00021\u0001()\t9#\rC\u0003d\u0013\u0001\u0007Q,\u0001\u0003eCf\u001c\b")
public class Iso8601DateFormatter
implements DateFormatter,
DateTimeFormatterHelper {
    private transient DateTimeFormatter formatter;
    private final String pattern;
    private final Locale locale;
    private final ZoneId UTC;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Instant toInstantWithZoneId(TemporalAccessor temporalAccessor, ZoneId zoneId) {
        return DateTimeFormatterHelper.toInstantWithZoneId$(this, temporalAccessor, zoneId);
    }

    @Override
    public DateTimeFormatter getOrCreateFormatter(String pattern, Locale locale) {
        return DateTimeFormatterHelper.getOrCreateFormatter$(this, pattern, locale);
    }

    private DateTimeFormatter formatter$lzycompute() {
        Iso8601DateFormatter iso8601DateFormatter = this;
        synchronized (iso8601DateFormatter) {
            if (!this.bitmap$trans$0) {
                this.formatter = this.getOrCreateFormatter(this.pattern, this.locale);
                this.bitmap$trans$0 = true;
            }
        }
        return this.formatter;
    }

    private DateTimeFormatter formatter() {
        return !this.bitmap$trans$0 ? this.formatter$lzycompute() : this.formatter;
    }

    private ZoneId UTC() {
        return this.UTC;
    }

    private Instant toInstant(String s) {
        TemporalAccessor temporalAccessor = this.formatter().parse(s);
        return this.toInstantWithZoneId(temporalAccessor, this.UTC());
    }

    @Override
    public int parse(String s) {
        return DateTimeUtils$.MODULE$.instantToDays(this.toInstant(s));
    }

    @Override
    public String format(int days) {
        Instant instant = Instant.ofEpochSecond((long)days * 86400L);
        return this.formatter().withZone(this.UTC()).format(instant);
    }

    public Iso8601DateFormatter(String pattern, Locale locale) {
        this.pattern = pattern;
        this.locale = locale;
        DateTimeFormatterHelper.$init$(this);
        this.UTC = ZoneId.of("UTC");
    }
}

