/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.spark.SparkException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.util.DropMalformedMode$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class JsonInferSchema$ {
    public static JsonInferSchema$ MODULE$;
    private final Comparator<StructField> structFieldComparator;
    private final StructField[] emptyStructFieldArray;

    static {
        new JsonInferSchema$();
    }

    public <T> StructType infer(RDD<T> json, JSONOptions configOptions, Function2<JsonFactory, T, JsonParser> createParser) {
        StructType structType;
        Some some;
        DataType st;
        ParseMode parseMode = configOptions.parseMode();
        String columnNameOfCorruptRecord = configOptions.columnNameOfCorruptRecord();
        Function2<DataType, DataType, DataType> typeMerger = this.compatibleRootType(columnNameOfCorruptRecord, parseMode);
        RDD mergedTypesFromPartitions = json.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            JsonFactory factory = new JsonFactory();
            configOptions.setJacksonOptions(factory);
            return Option$.MODULE$.option2Iterable(iter.flatMap((Function1 & Serializable & scala.Serializable)row -> {
                Iterable iterable;
                try {
                    iterable = Option$.MODULE$.option2Iterable((Option)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> (JsonParser)createParser.apply((Object)factory, row), (Function1 & Serializable & scala.Serializable)parser -> {
                        parser.nextToken();
                        return new Some((Object)MODULE$.inferField((JsonParser)parser, configOptions));
                    }));
                    return iterable;
                }
                catch (Throwable throwable) {
                    Iterable iterable2;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof RuntimeException ? true : throwable2 instanceof JsonProcessingException;
                    if (!bl) throw throwable;
                    ParseMode parseMode = parseMode;
                    if (PermissiveMode$.MODULE$.equals(parseMode)) {
                        iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)StructType$.MODULE$.apply((Seq<StructField>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField(columnNameOfCorruptRecord, StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))))));
                    } else if (DropMalformedMode$.MODULE$.equals(parseMode)) {
                        iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    } else {
                        if (!FailFastMode$.MODULE$.equals(parseMode)) throw new MatchError((Object)parseMode);
                        throw new SparkException(new StringBuilder(52).append("Malformed records are detected in schema inference. ").append(new StringBuilder(13).append("Parse Mode: ").append(FailFastMode$.MODULE$.name()).append(".").toString()).toString(), throwable2);
                    }
                    Iterable iterable3 = iterable2;
                    iterable = iterable3;
                }
                return iterable;
            }).reduceOption(typeMerger)).toIterator();
        }, json.mapPartitions$default$2(), ClassTag$.MODULE$.apply(DataType.class));
        SQLConf existingConf = SQLConf$.MODULE$.get();
        ObjectRef rootType = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$));
        Function1 & Serializable & scala.Serializable foldPartition = (Function1 & Serializable & scala.Serializable)iter -> (DataType)iter.fold((Object)StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$), typeMerger);
        Function2 & Serializable & scala.Serializable mergeResult = (Function2 & Serializable & scala.Serializable)(index, taskResult) -> {
            rootType.elem = (DataType)SQLConf$.MODULE$.withExistingConf(existingConf, (Function0 & Serializable & scala.Serializable)() -> (DataType)typeMerger$1.apply((Object)((DataType)rootType$1.elem), (Object)taskResult));
            return BoxedUnit.UNIT;
        };
        json.sparkContext().runJob(mergedTypesFromPartitions, (Function1)foldPartition, (Function2)mergeResult, ClassTag$.MODULE$.apply(DataType.class));
        Option<DataType> option = this.canonicalizeType((DataType)rootType.elem, configOptions);
        StructType structType2 = option instanceof Some && (st = (DataType)(some = (Some)option).value()) instanceof StructType ? (structType = (StructType)st) : StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$);
        return structType2;
    }

    private boolean isSorted(StructField[] arr) {
        for (int i = 0; i < arr.length - 1; ++i) {
            if (this.structFieldComparator.compare(arr[i], arr[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public DataType inferField(JsonParser parser, JSONOptions configOptions) {
        void var4_16;
        JsonToken jsonToken;
        JsonToken jsonToken2;
        boolean bl;
        while (true) {
            bl = false;
            jsonToken2 = null;
            jsonToken = parser.getCurrentToken();
            boolean bl2 = jsonToken == null ? true : JsonToken.VALUE_NULL.equals(jsonToken);
            if (bl2) {
                NullType$ nullType$ = NullType$.MODULE$;
                return var4_16;
            }
            if (!JsonToken.FIELD_NAME.equals(jsonToken)) break;
            parser.nextToken();
        }
        if (JsonToken.VALUE_STRING.equals(jsonToken)) {
            bl = true;
            jsonToken2 = jsonToken;
            if (parser.getTextLength() < 1) {
                NullType$ nullType$ = NullType$.MODULE$;
                return var4_16;
            }
        }
        if (bl) {
            StringType$ stringType$ = StringType$.MODULE$;
            return var4_16;
        }
        if (JsonToken.START_OBJECT.equals(jsonToken)) {
            ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(StructField.class));
            while (true) {
                if (!JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
                    StructField[] fields = (StructField[])builder.result();
                    Arrays.sort((Object[])fields, this.structFieldComparator);
                    StructType structType = new StructType(fields);
                    return var4_16;
                }
                builder.$plus$eq((Object)new StructField(parser.getCurrentName(), this.inferField(parser, configOptions), true, StructField$.MODULE$.apply$default$4()));
            }
        }
        if (JsonToken.START_ARRAY.equals(jsonToken)) {
            NullType$ nullType$ = NullType$.MODULE$;
            while (true) {
                void var20_20;
                if (!JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
                    ArrayType arrayType = ArrayType$.MODULE$.apply((DataType)var20_20);
                    return var4_16;
                }
                DataType dataType = this.compatibleType((DataType)var20_20, this.inferField(parser, configOptions));
            }
        }
        boolean bl3 = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
        if (bl3 && configOptions.primitivesAsString()) {
            StringType$ stringType$ = StringType$.MODULE$;
            return var4_16;
        }
        boolean bl4 = JsonToken.VALUE_TRUE.equals(jsonToken) ? true : JsonToken.VALUE_FALSE.equals(jsonToken);
        if (bl4 && configOptions.primitivesAsString()) {
            StringType$ stringType$ = StringType$.MODULE$;
            return var4_16;
        }
        boolean bl5 = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
        if (bl5) {
            void var6_31;
            JsonParser.NumberType numberType = parser.getNumberType();
            boolean bl6 = JsonParser.NumberType.INT.equals(numberType) ? true : JsonParser.NumberType.LONG.equals(numberType);
            if (bl6) {
                LongType$ longType$ = LongType$.MODULE$;
            } else {
                boolean bl7 = JsonParser.NumberType.BIG_INTEGER.equals(numberType) ? true : JsonParser.NumberType.BIG_DECIMAL.equals(numberType);
                if (bl7) {
                    BigDecimal v = parser.getDecimalValue();
                    FractionalType fractionalType = Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION() ? new DecimalType(Math.max(v.precision(), v.scale()), v.scale()) : DoubleType$.MODULE$;
                } else {
                    boolean bl8 = JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType);
                    if (bl8 && configOptions.prefersDecimal()) {
                        BigDecimal v = parser.getDecimalValue();
                        FractionalType fractionalType = Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION() ? new DecimalType(Math.max(v.precision(), v.scale()), v.scale()) : DoubleType$.MODULE$;
                    } else {
                        boolean bl9 = JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType);
                        if (!bl9) throw new MatchError((Object)numberType);
                        DoubleType$ doubleType$ = DoubleType$.MODULE$;
                    }
                }
            }
            void var4_14 = var6_31;
            return var4_16;
        }
        boolean bl10 = JsonToken.VALUE_TRUE.equals(jsonToken) ? true : JsonToken.VALUE_FALSE.equals(jsonToken);
        if (!bl10) throw new MatchError((Object)jsonToken);
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return var4_16;
    }

    private Option<DataType> canonicalizeType(DataType tpe, JSONOptions options) {
        Object object;
        DataType dataType = tpe;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            object = this.canonicalizeType(arrayType.elementType(), options).map((Function1 & Serializable & scala.Serializable)t -> arrayType.copy((DataType)t, arrayType.copy$default$2()));
        } else {
            StructType structType;
            StructField[] fields;
            StructField[] canonicalFields;
            object = dataType instanceof StructType ? (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(canonicalFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(fields = (structType = (StructType)dataType).fields()))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JsonInferSchema$.$anonfun$canonicalizeType$2(x$1))))).flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(MODULE$.canonicalizeType(f.dataType(), options).map((Function1 & Serializable & scala.Serializable)t -> {
                DataType x$1 = t;
                String x$2 = f.copy$default$1();
                boolean x$3 = f.copy$default$3();
                Metadata x$4 = f.copy$default$4();
                return f.copy(x$2, x$1, x$3, x$4);
            })), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))))).isEmpty() ? None$.MODULE$ : new Some((Object)new StructType(canonicalFields))) : (NullType$.MODULE$.equals(dataType) ? (options.dropFieldIfAllNull() ? None$.MODULE$ : new Some((Object)StringType$.MODULE$)) : new Some((Object)dataType));
        }
        return object;
    }

    private StructType withCorruptField(StructType struct, DataType other, String columnNameOfCorruptRecords, ParseMode parseMode) {
        StructType structType;
        ParseMode parseMode2 = parseMode;
        if (PermissiveMode$.MODULE$.equals(parseMode2)) {
            StructType structType2;
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])struct.fieldNames())).contains((Object)columnNameOfCorruptRecords)) {
                StructField structField = new StructField(columnNameOfCorruptRecords, StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                StructField[] newFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])struct.fields())).$plus$colon((Object)structField, ClassTag$.MODULE$.apply(StructField.class));
                Arrays.sort((Object[])newFields, this.structFieldComparator);
                structType2 = new StructType(newFields);
            } else {
                structType2 = struct;
            }
            structType = structType2;
        } else if (DropMalformedMode$.MODULE$.equals(parseMode2)) {
            structType = struct;
        } else {
            if (FailFastMode$.MODULE$.equals(parseMode2)) {
                throw new SparkException(new StringBuilder(52).append("Malformed records are detected in schema inference. ").append(new StringBuilder(56).append("Parse Mode: ").append(FailFastMode$.MODULE$.name()).append(". Reasons: Failed to infer a common schema. ").toString()).append(new StringBuilder(44).append("Struct types are expected, but `").append(other.catalogString()).append("` was found.").toString()).toString());
            }
            throw new MatchError((Object)parseMode2);
        }
        return structType;
    }

    private Function2<DataType, DataType, DataType> compatibleRootType(String columnNameOfCorruptRecords, ParseMode parseMode) {
        return (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType ty2 = (DataType)tuple2._2();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType ty1 = arrayType.elementType();
                    return (DataType)MODULE$.compatibleRootType(columnNameOfCorruptRecords, parseMode).apply((Object)ty1, (Object)ty2);
                }
            }
            if (tuple2 != null) {
                DataType ty1 = (DataType)tuple2._1();
                DataType dataType = (DataType)tuple2._2();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType ty2 = arrayType.elementType();
                    return (DataType)MODULE$.compatibleRootType(columnNameOfCorruptRecords, parseMode).apply((Object)ty1, (Object)ty2);
                }
            }
            if (tuple2 != null) {
                DataType struct = (DataType)tuple2._1();
                DataType dataType = (DataType)tuple2._2();
                if (struct instanceof StructType) {
                    StructType structType = (StructType)struct;
                    if (NullType$.MODULE$.equals(dataType)) {
                        return structType;
                    }
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType struct = (DataType)tuple2._2();
                if (NullType$.MODULE$.equals(dataType) && struct instanceof StructType) {
                    StructType structType = (StructType)struct;
                    return structType;
                }
            }
            if (tuple2 != null) {
                DataType struct = (DataType)tuple2._1();
                DataType o = (DataType)tuple2._2();
                if (struct instanceof StructType) {
                    StructType structType = (StructType)struct;
                    if (!(o instanceof StructType)) {
                        return MODULE$.withCorruptField(structType, o, columnNameOfCorruptRecords, parseMode);
                    }
                }
            }
            if (tuple2 != null) {
                DataType o = (DataType)tuple2._1();
                DataType struct = (DataType)tuple2._2();
                if (struct instanceof StructType) {
                    StructType structType = (StructType)struct;
                    if (!(o instanceof StructType)) {
                        return MODULE$.withCorruptField(structType, o, columnNameOfCorruptRecords, parseMode);
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            DataType ty1 = (DataType)tuple2._1();
            DataType ty2 = (DataType)tuple2._2();
            return MODULE$.compatibleType(ty1, ty2);
        };
    }

    public DataType compatibleType(DataType t1, DataType t2) {
        return (DataType)((Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)t1, (Object)t2)).getOrElse(() -> JsonInferSchema$.$anonfun$compatibleType$1(t1, t2));
    }

    public static final /* synthetic */ boolean $anonfun$canonicalizeType$2(StructField x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1.name())).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$compatibleType$2(StructField[] fields1$1) {
        return new StringBuilder(27).append(StructType$.MODULE$.simpleString()).append("'s fields were not sorted: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields1$1)).toSeq()).toString();
    }

    public static final /* synthetic */ String $anonfun$compatibleType$3(StructField[] fields2$1) {
        return new StringBuilder(27).append(StructType$.MODULE$.simpleString()).append("'s fields were not sorted: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields2$1)).toSeq()).toString();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ DataType $anonfun$compatibleType$1(DataType t1$1, DataType t2$1) {
        block14: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block13: {
                                block12: {
                                    block11: {
                                        var4_2 = new Tuple2((Object)t1$1, (Object)t2$1);
                                        if (var4_2 == null || !DoubleType$.MODULE$.equals(var5_3 = (DataType)var4_2._1()) || !(var4_2._2() instanceof DecimalType)) break block11;
                                        var3_4 = true;
                                        break block12;
                                    }
                                    if (var4_2 == null) ** GOTO lbl-1000
                                    var6_5 = (DataType)var4_2._2();
                                    if (var4_2._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var6_5)) {
                                        var3_4 = true;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        var3_4 = false;
                                    }
                                }
                                if (!var3_4) break block13;
                                var2_6 /* !! */  = DoubleType$.MODULE$;
                                break block14;
                            }
                            if (var4_2 == null) break block15;
                            t1 = (DataType)var4_2._1();
                            t2 = (DataType)var4_2._2();
                            if (!(t1 instanceof DecimalType)) break block15;
                            var9_9 = (DecimalType)t1;
                            if (!(t2 instanceof DecimalType)) break block15;
                            var10_10 = (DecimalType)t2;
                            scale = package$.MODULE$.max(var9_9.scale(), var10_10.scale());
                            range = package$.MODULE$.max(var9_9.precision() - var9_9.scale(), var10_10.precision() - var10_10.scale());
                            var2_6 /* !! */  = range + scale > 38 ? DoubleType$.MODULE$ : new DecimalType(range + scale, scale);
                            break block14;
                        }
                        if (var4_2 == null) break block16;
                        var13_13 = (DataType)var4_2._1();
                        var14_14 = (DataType)var4_2._2();
                        if (!(var13_13 instanceof StructType)) break block16;
                        var15_15 = (StructType)var13_13;
                        fields1 = var15_15.fields();
                        if (!(var14_14 instanceof StructType)) break block16;
                        var17_17 = (StructType)var14_14;
                        fields2 = var17_17.fields();
                        Predef$.MODULE$.assert(JsonInferSchema$.MODULE$.isSorted(fields1), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$compatibleType$2(org.apache.spark.sql.types.StructField[] ), ()Ljava/lang/String;)((StructField[])fields1));
                        Predef$.MODULE$.assert(JsonInferSchema$.MODULE$.isSorted(fields2), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$compatibleType$3(org.apache.spark.sql.types.StructField[] ), ()Ljava/lang/String;)((StructField[])fields2));
                        newFields = new ArrayList<StructField>();
                        f1Idx = 0;
                        f2Idx = 0;
                        while (f1Idx < fields1.length && f2Idx < fields2.length) {
                            f1Name = fields1[f1Idx].name();
                            comp = f1Name.compareTo(f2Name = fields2[f2Idx].name());
                            if (comp == 0) {
                                dataType = JsonInferSchema$.MODULE$.compatibleType(fields1[f1Idx].dataType(), fields2[f2Idx].dataType());
                                newFields.add(new StructField(f1Name, dataType, true, StructField$.MODULE$.apply$default$4()));
                                ++f1Idx;
                                ++f2Idx;
                                continue;
                            }
                            if (comp < 0) {
                                newFields.add(fields1[f1Idx]);
                                ++f1Idx;
                                continue;
                            }
                            newFields.add(fields2[f2Idx]);
                            ++f2Idx;
                        }
                        while (f1Idx < fields1.length) {
                            newFields.add(fields1[f1Idx]);
                            ++f1Idx;
                        }
                        while (f2Idx < fields2.length) {
                            newFields.add(fields2[f2Idx]);
                            ++f2Idx;
                        }
                        var2_6 /* !! */  = new StructType((StructField[])newFields.toArray((Object[])JsonInferSchema$.MODULE$.emptyStructFieldArray));
                        break block14;
                    }
                    if (var4_2 == null) break block17;
                    var26_26 = (DataType)var4_2._1();
                    var27_27 = (DataType)var4_2._2();
                    if (!(var26_26 instanceof ArrayType)) break block17;
                    var28_28 = (ArrayType)var26_26;
                    elementType1 = var28_28.elementType();
                    containsNull1 = var28_28.containsNull();
                    if (!(var27_27 instanceof ArrayType)) break block17;
                    var31_31 = (ArrayType)var27_27;
                    elementType2 = var31_31.elementType();
                    containsNull2 = var31_31.containsNull();
                    var2_6 /* !! */  = new ArrayType(JsonInferSchema$.MODULE$.compatibleType(elementType1, elementType2), containsNull1 != false || containsNull2 != false);
                    break block14;
                }
                if (var4_2 == null) break block18;
                t1 = (DataType)var4_2._1();
                t2 = (DataType)var4_2._2();
                if (!(t1 instanceof IntegralType)) break block18;
                var36_36 = (IntegralType)t1;
                if (!(t2 instanceof DecimalType)) break block18;
                var37_37 = (DecimalType)t2;
                var2_6 /* !! */  = JsonInferSchema$.MODULE$.compatibleType(DecimalType$.MODULE$.forType(var36_36), var37_37);
                break block14;
            }
            if (var4_2 == null) ** GOTO lbl-1000
            t1 = (DataType)var4_2._1();
            t2 = (DataType)var4_2._2();
            if (!(t1 instanceof DecimalType)) ** GOTO lbl-1000
            var40_40 = (DecimalType)t1;
            if (t2 instanceof IntegralType) {
                var41_41 = (IntegralType)t2;
                var2_6 /* !! */  = JsonInferSchema$.MODULE$.compatibleType(var40_40, DecimalType$.MODULE$.forType(var41_41));
            } else if (var4_2 != null) {
                var2_6 /* !! */  = StringType$.MODULE$;
            } else {
                throw new MatchError((Object)var4_2);
            }
        }
        return var2_6 /* !! */ ;
    }

    private JsonInferSchema$() {
        MODULE$ = this;
        this.structFieldComparator = new Comparator<StructField>(){

            public Comparator<StructField> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<StructField> thenComparing(Comparator<? super StructField> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<StructField> thenComparing(Function<? super StructField, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<StructField> thenComparing(Function<? super StructField, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<StructField> thenComparingInt(ToIntFunction<? super StructField> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<StructField> thenComparingLong(ToLongFunction<? super StructField> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<StructField> thenComparingDouble(ToDoubleFunction<? super StructField> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(StructField o1, StructField o2) {
                return o1.name().compareTo(o2.name());
            }
        };
        this.emptyStructFieldArray = (StructField[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StructField.class));
    }
}

