/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HashExpression;
import org.apache.spark.sql.catalyst.expressions.Murmur3Hash$;
import org.apache.spark.sql.catalyst.expressions.Murmur3HashFunction$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr1, expr2, ...) - Returns a hash value of the arguments.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', array(123), 2);\n       -1321691492\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u000e\u001d\u0001&B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005y!AA\n\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005O\u0001\tE\t\u0015!\u0003/\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015y\u0005\u0001\"\u0001U\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015I\u0007\u0001\"\u0015a\u0011\u0015Q\u0007\u0001\"\u0015l\u0011\u001d\u0019\b!!A\u0005\u0002QDqa\u001e\u0001\u0012\u0002\u0013\u0005\u0001\u0010C\u0005\u0002\b\u0001\t\n\u0011\"\u0001\u0002\n!I\u0011Q\u0002\u0001\u0002\u0002\u0013\u0005\u0013q\u0002\u0005\t\u0003?\u0001\u0011\u0011!C\u0001\u001b\"I\u0011\u0011\u0005\u0001\u0002\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003S\u0001\u0011\u0011!C!\u0003WA\u0011\"!\u000f\u0001\u0003\u0003%\t!a\u000f\t\u0013\u0005\u0015\u0003!!A\u0005B\u0005\u001ds!CA09\u0005\u0005\t\u0012AA1\r!YB$!A\t\u0002\u0005\r\u0004BB(\u0016\t\u0003\t\t\bC\u0005\u0002tU\t\t\u0011\"\u0012\u0002v!I\u0011qO\u000b\u0002\u0002\u0013\u0005\u0015\u0011\u0010\u0005\n\u0003\u007f*\u0012\u0011!CA\u0003\u0003C\u0011\"a%\u0016\u0003\u0003%I!!&\u0003\u00175+(/\\;sg!\u000b7\u000f\u001b\u0006\u0003;y\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0004I\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M!\u0001A\u000b\u001b8!\rYCFL\u0007\u00029%\u0011Q\u0006\b\u0002\u000f\u0011\u0006\u001c\b.\u0012=qe\u0016\u001c8/[8o!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\rIe\u000e\u001e\t\u0003_UJ!A\u000e\u0019\u0003\u000fA\u0013x\u000eZ;diB\u0011q\u0006O\u0005\u0003sA\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002yA\u0019Q(\u0012%\u000f\u0005y\u001aeBA C\u001b\u0005\u0001%BA!)\u0003\u0019a$o\\8u}%\t\u0011'\u0003\u0002Ea\u00059\u0001/Y2lC\u001e,\u0017B\u0001$H\u0005\r\u0019V-\u001d\u0006\u0003\tB\u0002\"aK%\n\u0005)c\"AC#yaJ,7o]5p]\u0006I1\r[5mIJ,g\u000eI\u0001\u0005g\u0016,G-F\u0001/\u0003\u0015\u0019X-\u001a3!\u0003\u0019a\u0014N\\5u}Q\u0019\u0011KU*\u0011\u0005-\u0002\u0001\"\u0002\u001e\u0006\u0001\u0004a\u0004\"\u0002'\u0006\u0001\u0004qCCA)V\u0011\u00151f\u00011\u0001=\u0003%\t'oZ;nK:$8/\u0001\u0005eCR\fG+\u001f9f+\u0005I\u0006C\u0001.^\u001b\u0005Y&B\u0001/!\u0003\u0015!\u0018\u0010]3t\u0013\tq6L\u0001\u0005ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002CB\u0011!M\u001a\b\u0003G\u0012\u0004\"a\u0010\u0019\n\u0005\u0015\u0004\u0014A\u0002)sK\u0012,g-\u0003\u0002hQ\n11\u000b\u001e:j]\u001eT!!\u001a\u0019\u0002\u001f!\f7\u000f[3s\u00072\f7o\u001d(b[\u0016\f1bY8naV$X\rS1tQR!a\u0006\\9s\u0011\u0015i'\u00021\u0001o\u0003\u00151\u0018\r\\;f!\tys.\u0003\u0002qa\t\u0019\u0011I\\=\t\u000b]S\u0001\u0019A-\t\u000b1S\u0001\u0019\u0001\u0018\u0002\t\r|\u0007/\u001f\u000b\u0004#V4\bb\u0002\u001e\f!\u0003\u0005\r\u0001\u0010\u0005\b\u0019.\u0001\n\u00111\u0001/\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u001f\u0016\u0003yi\\\u0013a\u001f\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018!C;oG\",7m[3e\u0015\r\t\t\u0001M\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0003{\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0002\u0016\u0003]i\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\t!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\tA\u0001\\1oO*\u0011\u00111D\u0001\u0005U\u00064\u0018-C\u0002h\u0003+\tA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002o\u0003KA\u0001\"a\n\u0011\u0003\u0003\u0005\rAL\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u00055\u0002#BA\u0018\u0003kqWBAA\u0019\u0015\r\t\u0019\u0004M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001c\u0003c\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QHA\"!\ry\u0013qH\u0005\u0004\u0003\u0003\u0002$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003O\u0011\u0012\u0011!a\u0001]\u00061Q-];bYN$B!!\u0010\u0002J!A\u0011qE\n\u0002\u0002\u0003\u0007a\u000eK\u0006\u0001\u0003\u001b\n\u0019&!\u0016\u0002Z\u0005m\u0003cA\u0016\u0002P%\u0019\u0011\u0011\u000b\u000f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qK\u0001C?\u001a+fjQ0)Kb\u0004(/\r\u0017!Kb\u0004(O\r\u0017!]9r\u0013\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u0004\u0003.Y:iAY\fG.^3!_\u001a\u0004C\u000f[3!CJ<W/\\3oiNt\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0013a\u0015\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6(Y\u0001\n'O]1zQE\u00124'\u000b\u0017!e%Z$\u0002\t\u0011!A\u0001\u0002\u0003%L\u00194eE2\u0014(\r\u001b:e)\u0001\u0003%A\u0006NkJlWO]\u001aICND\u0007CA\u0016\u0016'\u0011)\u0012QM\u001c\u0011\u000f\u0005\u001d\u0014Q\u000e\u001f/#6\u0011\u0011\u0011\u000e\u0006\u0004\u0003W\u0002\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003_\nIGA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!!\u0019\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0005\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bE\u000bY(! \t\u000biB\u0002\u0019\u0001\u001f\t\u000b1C\u0002\u0019\u0001\u0018\u0002\u000fUt\u0017\r\u001d9msR!\u00111QAH!\u0015y\u0013QQAE\u0013\r\t9\t\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b=\nY\t\u0010\u0018\n\u0007\u00055\u0005G\u0001\u0004UkBdWM\r\u0005\t\u0003#K\u0012\u0011!a\u0001#\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003/\u0003B!a\u0005\u0002\u001a&!\u00111TA\u000b\u0005\u0019y%M[3di\u0002")
public class Murmur3Hash
extends HashExpression<Object>
implements Serializable {
    private final Seq<Expression> children;
    private final int seed;

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(Murmur3Hash murmur3Hash) {
        return Murmur3Hash$.MODULE$.unapply(murmur3Hash);
    }

    public static Function1<Tuple2<Seq<Expression>, Object>, Murmur3Hash> tupled() {
        return Murmur3Hash$.MODULE$.tupled();
    }

    public static Function1<Seq<Expression>, Function1<Object, Murmur3Hash>> curried() {
        return Murmur3Hash$.MODULE$.curried();
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public int seed() {
        return this.seed;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "hash";
    }

    @Override
    public String hasherClassName() {
        return Murmur3_x86_32.class.getName();
    }

    @Override
    public int computeHash(Object value, DataType dataType, int seed) {
        return (int)Murmur3HashFunction$.MODULE$.hash(value, dataType, seed);
    }

    public Murmur3Hash copy(Seq<Expression> children2, int seed) {
        return new Murmur3Hash(children2, seed);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public int copy$default$2() {
        return this.seed();
    }

    @Override
    public String productPrefix() {
        return "Murmur3Hash";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.seed());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Murmur3Hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Murmur3Hash)) return false;
        boolean bl = true;
        if (!bl) return false;
        Murmur3Hash murmur3Hash = (Murmur3Hash)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = murmur3Hash.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.seed() != murmur3Hash.seed()) return false;
        if (!murmur3Hash.canEqual(this)) return false;
        return true;
    }

    public Murmur3Hash(Seq<Expression> children2, int seed) {
        this.children = children2;
        this.seed = seed;
    }

    public Murmur3Hash(Seq<Expression> arguments) {
        this(arguments, 42);
    }
}

