/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.MonotonicallyIncreasingID$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Stateful;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_() - Returns monotonically increasing 64-bit integers. The generated ID is guaranteed\n      to be monotonically increasing and unique, but not consecutive. The current implementation\n      puts the partition ID in the upper 31 bits, and the lower 33 bits represent the record number\n      within each partition. The assumption is that the data frame has less than 1 billion\n      partitions, and each partition has less than 8 billion records.\n      The function is non-deterministic because its result depends on partition IDs.\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001\u0002\u000e\u001c\u0001\"BQ!\u000f\u0001\u0005\u0002iB\u0011\u0002\u0010\u0001A\u0002\u0003\u0005\u000b\u0015B\u001f\t\u0013\u0011\u0003\u0001\u0019!A!B\u0013i\u0004\"\u0002$\u0001\t#:\u0005\"\u0002)\u0001\t\u0003\n\u0006\"B+\u0001\t\u00032\u0006\"B/\u0001\t#r\u0006\"B3\u0001\t\u00032\u0007\"\u0002;\u0001\t\u0003*\b\"\u0002\u0011\u0001\t\u0003*\bBBA\u0002\u0001\u0011\u0005#\b\u0003\u0005\u0002\u0006\u0001\t\t\u0011\"\u0001;\u0011%\t9\u0001AA\u0001\n\u0003\nI\u0001C\u0005\u0002\u001a\u0001\t\t\u0011\"\u0001\u0002\u001c!I\u0011Q\u0004\u0001\u0002\u0002\u0013\u0005\u0011q\u0004\u0005\n\u0003W\u0001\u0011\u0011!C!\u0003[A\u0011\"a\u000f\u0001\u0003\u0003%\t!!\u0010\t\u0013\u0005\u0005\u0003!!A\u0005B\u0005\rs!CA+7\u0005\u0005\t\u0012AA,\r!Q2$!A\t\u0002\u0005e\u0003BB\u001d\u0015\t\u0003\t9\u0007C\u0005\u0002jQ\t\t\u0011\"\u0012\u0002l!A\u0011Q\u000e\u000b\u0002\u0002\u0013\u0005%\bC\u0005\u0002pQ\t\t\u0011\"!\u0002r!I\u0011q\u000f\u000b\u0002\u0002\u0013%\u0011\u0011\u0010\u0002\u001a\u001b>tw\u000e^8oS\u000e\fG\u000e\\=J]\u000e\u0014X-Y:j]\u001eLEI\u0003\u0002\u001d;\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tqr$\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0013%A\u0002tc2T!AI\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0011&\f\u00197!\tQ3&D\u0001\u001c\u0013\ta3D\u0001\bMK\u00064W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005)r\u0013BA\u0018\u001c\u0005!\u0019F/\u0019;fMVd\u0007CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$a\u0002)s_\u0012,8\r\u001e\t\u0003c]J!\u0001\u000f\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005Y\u0004C\u0001\u0016\u0001\u0003\u0015\u0019w.\u001e8u!\t\td(\u0003\u0002@e\t!Aj\u001c8hQ\t\u0011\u0011\t\u0005\u00022\u0005&\u00111I\r\u0002\niJ\fgn]5f]R\fQ\u0002]1si&$\u0018n\u001c8NCN\\\u0007FA\u0002B\u0003IIg.\u001b;jC2L'0Z%oi\u0016\u0014h.\u00197\u0015\u0005![\u0005CA\u0019J\u0013\tQ%G\u0001\u0003V]&$\b\"\u0002'\u0005\u0001\u0004i\u0015A\u00049beRLG/[8o\u0013:$W\r\u001f\t\u0003c9K!a\u0014\u001a\u0003\u0007%sG/\u0001\u0005ok2d\u0017M\u00197f+\u0005\u0011\u0006CA\u0019T\u0013\t!&GA\u0004C_>dW-\u00198\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u0016\t\u00031nk\u0011!\u0017\u0006\u00035~\tQ\u0001^=qKNL!\u0001X-\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fA\"\u001a<bY&sG/\u001a:oC2$\"!P0\t\u000b\u0001<\u0001\u0019A1\u0002\u000b%t\u0007/\u001e;\u0011\u0005\t\u001cW\"A\u000f\n\u0005\u0011l\"aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007\u001dl'\u000f\u0005\u0002iW6\t\u0011N\u0003\u0002k7\u000591m\u001c3fO\u0016t\u0017B\u00017j\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u00028\t\u0001\u0004y\u0017aA2uqB\u0011\u0001\u000e]\u0005\u0003c&\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003t\u0011\u0001\u0007q-\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003Y\u0004\"a\u001e@\u000f\u0005ad\bCA=3\u001b\u0005Q(BA>(\u0003\u0019a$o\\8u}%\u0011QPM\u0001\u0007!J,G-\u001a4\n\u0007}\f\tA\u0001\u0004TiJLgn\u001a\u0006\u0003{J\n\u0011B\u001a:fg\"\u001cu\u000e]=\u0002\t\r|\u0007/_\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0016\u0005!!.\u0019<b\u0013\ry\u0018qB\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002\u001b\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0011\u0003O\u00012!MA\u0012\u0013\r\t)C\r\u0002\u0004\u0003:L\b\u0002CA\u0015\u001f\u0005\u0005\t\u0019A'\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u0003\u0005\u0004\u00022\u0005]\u0012\u0011E\u0007\u0003\u0003gQ1!!\u000e3\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003s\t\u0019D\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001*\u0002@!I\u0011\u0011F\t\u0002\u0002\u0003\u0007\u0011\u0011E\u0001\u0007KF,\u0018\r\\:\u0015\u0007I\u000b)\u0005C\u0005\u0002*I\t\t\u00111\u0001\u0002\"!:\u0001!!\u0013\u0002P\u0005E\u0003c\u0001\u0016\u0002L%\u0019\u0011QJ\u000e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111K\u0001\u0005>)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015*A5\u0002#+\u001a;ve:\u001c\b%\\8o_R|g.[2bY2L\b%\u001b8de\u0016\f7/\u001b8hAY\"TFY5uA%tG/Z4feNt\u0003\u0005\u00165fA\u001d,g.\u001a:bi\u0016$\u0007%\u0013#!SN\u0004s-^1sC:$X-\u001a3\u000bA\u0001\u0002\u0003\u0005\t\u0011u_\u0002\u0012W\rI7p]>$xN\\5dC2d\u0017\u0010I5oGJ,\u0017m]5oO\u0002\ng\u000e\u001a\u0011v]&\fX/\u001a\u0017!EV$\bE\\8uA\r|gn]3dkRLg/\u001a\u0018!)\",\u0007eY;se\u0016tG\u000fI5na2,W.\u001a8uCRLwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t9viN\u0004C\u000f[3!a\u0006\u0014H/\u001b;j_:\u0004\u0013\n\u0012\u0011j]\u0002\"\b.\u001a\u0011vaB,'\u000fI\u001a2A\tLGo\u001d\u0017!C:$\u0007\u0005\u001e5fA1|w/\u001a:!gM\u0002#-\u001b;tAI,\u0007O]3tK:$\b\u0005\u001e5fAI,7m\u001c:eA9,XNY3s\u0015\u0001\u0002\u0003\u0005\t\u0011!o&$\b.\u001b8!K\u0006\u001c\u0007\u000e\t9beRLG/[8o]\u0001\"\u0006.\u001a\u0011bgN,X\u000e\u001d;j_:\u0004\u0013n\u001d\u0011uQ\u0006$\b\u0005\u001e5fA\u0011\fG/\u0019\u0011ge\u0006lW\r\t5bg\u0002bWm]:!i\"\fg\u000eI\u0019!E&dG.[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!a\u0006\u0014H/\u001b;j_:\u001cH\u0006I1oI\u0002*\u0017m\u00195!a\u0006\u0014H/\u001b;j_:\u0004\u0003.Y:!Y\u0016\u001c8\u000f\t;iC:\u0004\u0003\b\t2jY2LwN\u001c\u0011sK\u000e|'\u000fZ:/\u0015\u0001\u0002\u0003\u0005\t\u0011!)\",\u0007EZ;oGRLwN\u001c\u0011jg\u0002rwN\\\u0017eKR,'/\\5oSN$\u0018n\u0019\u0011cK\u000e\fWo]3!SR\u001c\bE]3tk2$\b\u0005Z3qK:$7\u000fI8oAA\f'\u000f^5uS>t\u0007%\u0013#t])\u0001\u0003%A\rN_:|Go\u001c8jG\u0006dG._%oGJ,\u0017m]5oO&#\u0005C\u0001\u0016\u0015'\u0011!\u00121\f\u001c\u0011\u000b\u0005u\u00131M\u001e\u000e\u0005\u0005}#bAA1e\u00059!/\u001e8uS6,\u0017\u0002BA3\u0003?\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c81)\t\t9&\u0001\u0005u_N#(/\u001b8h)\t\tY!A\u0003baBd\u00170A\u0004v]\u0006\u0004\b\u000f\\=\u0015\u0007I\u000b\u0019\b\u0003\u0005\u0002va\t\t\u00111\u0001<\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002|A!\u0011QBA?\u0013\u0011\ty(a\u0004\u0003\r=\u0013'.Z2u\u0001")
public class MonotonicallyIncreasingID
extends LeafExpression
implements Stateful,
Serializable {
    private transient long count;
    private transient long partitionMask;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile boolean bitmap$0;

    public static boolean unapply(MonotonicallyIncreasingID monotonicallyIncreasingID) {
        return MonotonicallyIncreasingID$.MODULE$.unapply(monotonicallyIncreasingID);
    }

    @Override
    public boolean fastEquals(TreeNode<?> other) {
        return Stateful.fastEquals$(this, other);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    private boolean deterministic$lzycompute() {
        MonotonicallyIncreasingID monotonicallyIncreasingID = this;
        synchronized (monotonicallyIncreasingID) {
            if (!this.bitmap$0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = true;
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        return !this.bitmap$0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.count = 0L;
        this.partitionMask = (long)partitionIndex << 33;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    public long evalInternal(InternalRow input) {
        long currentCount = this.count++;
        return this.partitionMask + currentCount;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String countTerm = ctx.addMutableState("long", "count", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String partitionMaskTerm = "partitionMask";
        ctx.addImmutableStateIfNotExists("long", partitionMaskTerm, ctx.addImmutableStateIfNotExists$default$3());
        ctx.addPartitionInitializationStatement(new StringBuilder(6).append(countTerm).append(" = 0L;").toString());
        ctx.addPartitionInitializationStatement(new StringBuilder(33).append(partitionMaskTerm).append(" = ((long) partitionIndex) << 33;").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", " + ", ";\n      ", "++;"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), partitionMaskTerm, countTerm, countTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "monotonically_increasing_id";
    }

    @Override
    public String sql() {
        return new StringBuilder(2).append(this.prettyName()).append("()").toString();
    }

    @Override
    public MonotonicallyIncreasingID freshCopy() {
        return new MonotonicallyIncreasingID();
    }

    public MonotonicallyIncreasingID copy() {
        return new MonotonicallyIncreasingID();
    }

    @Override
    public String productPrefix() {
        return "MonotonicallyIncreasingID";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonotonicallyIncreasingID;
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        boolean bl = object instanceof MonotonicallyIncreasingID;
        return bl && ((MonotonicallyIncreasingID)x$1).canEqual(this);
    }

    public MonotonicallyIncreasingID() {
        Nondeterministic.$init$(this);
        Stateful.$init$(this);
    }
}

