/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AssertTrue$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.TrueLiteral$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Throws an exception if `expr` is not true.", examples="\n    Examples:\n      > SELECT _FUNC_(0 < 1);\n       NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001\u0002\u000f\u001e\u0001*B\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0012)A\u0005{!)\u0011\t\u0001C\u0001\u0005\")Q\t\u0001C!\r\")!\n\u0001C!\u0017\")a\f\u0001C!?\")\u0001\r\u0001C!C\"9!\u000e\u0001b\u0001\n\u0013\t\u0007BB6\u0001A\u0003%!\rC\u0003m\u0001\u0011\u0005S\u000eC\u0003x\u0001\u0011\u0005\u0003\u0010C\u0003#\u0001\u0011\u0005\u0013\rC\u0005\u0002\u000e\u0001\t\t\u0011\"\u0001\u0002\u0010!I\u00111\u0003\u0001\u0012\u0002\u0013\u0005\u0011Q\u0003\u0005\n\u0003W\u0001\u0011\u0011!C!\u0003[A\u0011\"!\u0010\u0001\u0003\u0003%\t!a\u0010\t\u0013\u0005\u001d\u0003!!A\u0005\u0002\u0005%\u0003\"CA(\u0001\u0005\u0005I\u0011IA)\u0011%\ty\u0006AA\u0001\n\u0003\t\t\u0007C\u0005\u0002f\u0001\t\t\u0011\"\u0011\u0002h\u001dI\u0011qP\u000f\u0002\u0002#\u0005\u0011\u0011\u0011\u0004\t9u\t\t\u0011#\u0001\u0002\u0004\"1\u0011I\u0006C\u0001\u0003#C\u0011\"a%\u0017\u0003\u0003%)%!&\t\u0013\u0005]e#!A\u0005\u0002\u0006e\u0005\"CAO-\u0005\u0005I\u0011QAP\u0011%\tYKFA\u0001\n\u0013\tiK\u0001\u0006BgN,'\u000f\u001e+sk\u0016T!AH\u0010\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003A\u0005\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003E\r\n1a]9m\u0015\t!S%A\u0003ta\u0006\u00148N\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<7\u0001A\n\u0006\u0001-z#\u0007\u000f\t\u0003Y5j\u0011!H\u0005\u0003]u\u0011q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003YAJ!!M\u000f\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00024s%\u0011!\b\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006G\"LG\u000eZ\u000b\u0002{A\u0011AFP\u0005\u0003\u007fu\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"\"a\u0011#\u0011\u00051\u0002\u0001\"B\u001e\u0004\u0001\u0004i\u0014\u0001\u00038vY2\f'\r\\3\u0016\u0003\u001d\u0003\"a\r%\n\u0005%#$a\u0002\"p_2,\u0017M\\\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001'\u0011\u00075+\u0006L\u0004\u0002O':\u0011qJU\u0007\u0002!*\u0011\u0011+K\u0001\u0007yI|w\u000e\u001e \n\u0003UJ!\u0001\u0016\u001b\u0002\u000fA\f7m[1hK&\u0011ak\u0016\u0002\u0004'\u0016\f(B\u0001+5!\tIF,D\u0001[\u0015\tY\u0016%A\u0003usB,7/\u0003\u0002^5\nAA)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005A\u0016A\u00039sKR$\u0018PT1nKV\t!\r\u0005\u0002dO:\u0011A-\u001a\t\u0003\u001fRJ!A\u001a\u001b\u0002\rA\u0013X\rZ3g\u0013\tA\u0017N\u0001\u0004TiJLgn\u001a\u0006\u0003MR\na!\u001a:s\u001bN<\u0017aB3se6\u001bx\rI\u0001\u0005KZ\fG\u000e\u0006\u0002ocB\u00111g\\\u0005\u0003aR\u00121!\u00118z\u0011\u001d\u0011(\u0002%AA\u0002M\fQ!\u001b8qkR\u0004\"\u0001^;\u000e\u0003}I!A^\u0010\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$B!_@\u0002\nA\u0011!0`\u0007\u0002w*\u0011A0H\u0001\bG>$WmZ3o\u0013\tq8P\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t\ta\u0003a\u0001\u0003\u0007\t1a\u0019;y!\rQ\u0018QA\u0005\u0004\u0003\u000fY(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u0017Y\u0001\u0019A=\u0002\u0005\u00154\u0018\u0001B2paf$2aQA\t\u0011\u001dYT\u0002%AA\u0002u\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0018)\u001aQ(!\u0007,\u0005\u0005m\u0001\u0003BA\u000f\u0003Oi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\n5\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003S\tyBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0018!\u0011\t\t$a\u000f\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\tA\u0001\\1oO*\u0011\u0011\u0011H\u0001\u0005U\u00064\u0018-C\u0002i\u0003g\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0011\u0011\u0007M\n\u0019%C\u0002\u0002FQ\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2A\\A&\u0011%\ti%EA\u0001\u0002\u0004\t\t%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003'\u0002R!!\u0016\u0002\\9l!!a\u0016\u000b\u0007\u0005eC'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0018\u0002X\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r9\u00151\r\u0005\t\u0003\u001b\u001a\u0012\u0011!a\u0001]\u00061Q-];bYN$2aRA5\u0011!\ti\u0005FA\u0001\u0002\u0004q\u0007f\u0003\u0001\u0002n\u0005M\u0014QOA=\u0003w\u00022\u0001LA8\u0013\r\t\t(\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t9(A\u001d`\rVs5i\u0018\u0015fqB\u0014\u0018\u0006I\u0017!)\"\u0014xn^:!C:\u0004S\r_2faRLwN\u001c\u0011jM\u0002\u0002W\r\u001f9sA\u0002J7\u000f\t8pi\u0002\"(/^3/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA?\u0003mR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006\r\u0011=AEJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005I\u0001\u000b\u0003N\u001cXM\u001d;UeV,\u0007C\u0001\u0017\u0017'\u00111\u0012Q\u0011\u001d\u0011\r\u0005\u001d\u0015QR\u001fD\u001b\t\tIIC\u0002\u0002\fR\nqA];oi&lW-\u0003\u0003\u0002\u0010\u0006%%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011\u0011\u0011Q\u0001\ti>\u001cFO]5oOR\u0011\u0011qF\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u0007\u0006m\u0005\"B\u001e\u001a\u0001\u0004i\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003C\u000b9\u000b\u0005\u00034\u0003Gk\u0014bAASi\t1q\n\u001d;j_:D\u0001\"!+\u001b\u0003\u0003\u0005\raQ\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a,\u0011\t\u0005E\u0012\u0011W\u0005\u0005\u0003g\u000b\u0019D\u0001\u0004PE*,7\r\u001e")
public class AssertTrue
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression child;
    private final String errMsg;

    public static Option<Expression> unapply(AssertTrue assertTrue) {
        return AssertTrue$.MODULE$.unapply(assertTrue);
    }

    public static <A> Function1<Expression, A> andThen(Function1<AssertTrue, A> function1) {
        return AssertTrue$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, AssertTrue> compose(Function1<A, Expression> function1) {
        return AssertTrue$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BooleanType$[]{BooleanType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return NullType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "assert_true";
    }

    private String errMsg() {
        return this.errMsg;
    }

    @Override
    public Object eval(InternalRow input) {
        Object v = this.child().eval(input);
        if (v == null || Boolean.FALSE.equals(v)) {
            throw new RuntimeException(this.errMsg());
        }
        return null;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval = this.child().genCode(ctx);
        String errMsgField = ctx.addReferenceObj("errMsg", this.errMsg(), ctx.addReferenceObj$default$3());
        return new ExprCode(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\n       |if (", " || !", ") {\n       |  throw new RuntimeException(", ");\n       |}"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), eval.isNull(), eval.value(), errMsgField})).stripMargin(), TrueLiteral$.MODULE$, JavaCode$.MODULE$.defaultLiteral(this.dataType()));
    }

    @Override
    public String sql() {
        return new StringBuilder(13).append("assert_true(").append(this.child().sql()).append(")").toString();
    }

    public AssertTrue copy(Expression child) {
        return new AssertTrue(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "AssertTrue";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AssertTrue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AssertTrue)) return false;
        boolean bl = true;
        if (!bl) return false;
        AssertTrue assertTrue = (AssertTrue)x$1;
        Expression expression = this.child();
        Expression expression2 = assertTrue.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!assertTrue.canEqual(this)) return false;
        return true;
    }

    public AssertTrue(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
        this.errMsg = new StringBuilder(15).append("'").append(child.simpleString()).append("' is not true!").toString();
    }
}

