/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathFloat$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a float value that matches the xpath expression", extended="> SELECT _FUNC_('<a><b>1</b><b>2</b></a>','sum(a/b)');\n3.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001F\u0011!\u0002\u0017)bi\"4En\\1u\u0015\t\u0019A!A\u0002y[2T!!\u0002\u0004\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000f!\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0005\u0001I1B\u0004\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\ta\u0001\fU1uQ\u0016CHO]1diB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t9\u0001K]8ek\u000e$\bCA\f\u001e\u0013\tq\u0002D\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0004\u0001\tU\r\u0011\"\u0001!+\u0005\t\u0003C\u0001\u0012$\u001b\u0005!\u0011B\u0001\u0013\u0005\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tM\u0001\u0011\t\u0012)A\u0005C\u0005!\u00010\u001c7!\u0011!A\u0003A!f\u0001\n\u0003\u0001\u0013\u0001\u00029bi\"D\u0001B\u000b\u0001\u0003\u0012\u0003\u0006I!I\u0001\u0006a\u0006$\b\u000e\t\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00079z\u0003\u0007\u0005\u0002\u0014\u0001!)1a\u000ba\u0001C!)\u0001f\u000ba\u0001C!)!\u0007\u0001C!g\u0005Q\u0001O]3uift\u0015-\\3\u0016\u0003Q\u0002\"!\u000e\u001d\u000f\u0005]1\u0014BA\u001c\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011H\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]B\u0002\"\u0002\u001f\u0001\t\u0003j\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003y\u0002\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0005\u0002\u000bQL\b/Z:\n\u0005\r\u0003%\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000b\u0015\u0003A\u0011\t$\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007\u001dS5\n\u0005\u0002\u0018\u0011&\u0011\u0011\n\u0007\u0002\u0004\u0003:L\b\"B\u0002E\u0001\u00049\u0005\"\u0002\u0015E\u0001\u00049\u0005bB'\u0001\u0003\u0003%\tAT\u0001\u0005G>\u0004\u0018\u0010F\u0002/\u001fBCqa\u0001'\u0011\u0002\u0003\u0007\u0011\u0005C\u0004)\u0019B\u0005\t\u0019A\u0011\t\u000fI\u0003\u0011\u0013!C\u0001'\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u0001++\u0005\u0005*6&\u0001,\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016!C;oG\",7m[3e\u0015\tY\u0006$\u0001\u0006b]:|G/\u0019;j_:L!!\u0018-\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004`\u0001E\u0005I\u0011A*\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!9\u0011\rAA\u0001\n\u0003\u0012\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001d!\t!\u0017.D\u0001f\u0015\t1w-\u0001\u0003mC:<'\"\u00015\u0002\t)\fg/Y\u0005\u0003s\u0015Dqa\u001b\u0001\u0002\u0002\u0013\u0005A.\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001n!\t9b.\u0003\u0002p1\t\u0019\u0011J\u001c;\t\u000fE\u0004\u0011\u0011!C\u0001e\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HCA$t\u0011\u001d!\b/!AA\u00025\f1\u0001\u001f\u00132\u0011\u001d1\b!!A\u0005B]\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0002qB\u0019\u0011\u0010`$\u000e\u0003iT!a\u001f\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002~u\nA\u0011\n^3sCR|'\u000f\u0003\u0005\u0000\u0001\u0005\u0005I\u0011AA\u0001\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0002\u0003\u0013\u00012aFA\u0003\u0013\r\t9\u0001\u0007\u0002\b\u0005>|G.Z1o\u0011\u001d!h0!AA\u0002\u001dC\u0011\"!\u0004\u0001\u0003\u0003%\t%a\u0004\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019!!\u0005\t\u0011Q\fY!!AA\u0002\u001dC3\u0002AA\u000b\u00037\ti\"!\t\u0002$A\u0019!%a\u0006\n\u0007\u0005eAAA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005}\u0011\u0001T0G+:\u001bu\f\u000b=nY2\u0002\u0003\u0010]1uQ&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bA\u0019dw.\u0019;!m\u0006dW/\u001a\u0011uQ\u0006$\b%\\1uG\",7\u000f\t;iK\u0002B\b/\u0019;iA\u0015D\bO]3tg&|g.\u0001\u0005fqR,g\u000eZ3eC\t\t)#\u0001\u001e?AM+E*R\"UA}3UKT\"`Q\u001db\u0014M\u0010\u001fc}EbtF\u0019 =Ez\u0012Dh\f2?y=\ngh\n\u0017(gVl\u0007&Y\u0018cS\u001dJ3HC\u001a/a\u001dI\u0011\u0011\u0006\u0002\u0002\u0002#\u0005\u00111F\u0001\u000b1B\u000bG\u000f\u001b$m_\u0006$\bcA\n\u0002.\u0019A\u0011AAA\u0001\u0012\u0003\tycE\u0003\u0002.\u0005EB\u0004E\u0004\u00024\u0005e\u0012%\t\u0018\u000e\u0005\u0005U\"bAA\u001c1\u00059!/\u001e8uS6,\u0017\u0002BA\u001e\u0003k\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001da\u0013Q\u0006C\u0001\u0003\u007f!\"!a\u000b\t\u0015\u0005\r\u0013QFA\u0001\n\u000b\n)%\u0001\u0005u_N#(/\u001b8h)\u0005\u0019\u0007BCA%\u0003[\t\t\u0011\"!\u0002L\u0005)\u0011\r\u001d9msR)a&!\u0014\u0002P!11!a\u0012A\u0002\u0005Ba\u0001KA$\u0001\u0004\t\u0003BCA*\u0003[\t\t\u0011\"!\u0002V\u00059QO\\1qa2LH\u0003BA,\u0003G\u0002RaFA-\u0003;J1!a\u0017\u0019\u0005\u0019y\u0005\u000f^5p]B)q#a\u0018\"C%\u0019\u0011\u0011\r\r\u0003\rQ+\b\u000f\\33\u0011%\t)'!\u0015\u0002\u0002\u0003\u0007a&A\u0002yIAB!\"!\u001b\u0002.\u0005\u0005I\u0011BA6\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u00055\u0004c\u00013\u0002p%\u0019\u0011\u0011O3\u0003\r=\u0013'.Z2u\u0001")
public class XPathFloat
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Function1<Tuple2<Expression, Expression>, XPathFloat> tupled() {
        return XPathFloat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathFloat>> curried() {
        return XPathFloat$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_float";
    }

    @Override
    public DataType dataType() {
        return FloatType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        return ret == null ? null : BoxesRunTime.boxToFloat((float)ret.floatValue());
    }

    public XPathFloat copy(Expression xml, Expression path) {
        return new XPathFloat(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathFloat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.path();
                break;
            }
            case 0: {
                expression = this.xml();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathFloat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathFloat)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathFloat xPathFloat = (XPathFloat)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathFloat.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathFloat.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathFloat.canEqual(this)) return false;
        return true;
    }

    public XPathFloat(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

