/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroKey;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.package$;
import org.apache.spark.sql.avro.AvroSerializer;
import org.apache.spark.sql.avro.SparkAvroKeyOutputFormat;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.MapLike;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b!B\b\u0011\u0001AQ\u0002\u0002C\u0012\u0001\u0005\u000b\u0007I\u0011A\u0013\t\u0011M\u0002!\u0011!Q\u0001\n\u0019B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u001dA\u0006A1A\u0005\neCa!\u001a\u0001!\u0002\u0013Q\u0006\u0002\u00034\u0001\u0011\u000b\u0007I\u0011B4\t\u000f-\u0004!\u0019!C\u0005Y\"9\u0011Q\u0001\u0001!\u0002\u0013i\u0007bBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003C\u0001A\u0011IA\u0012\u0005A\teO]8PkR\u0004X\u000f^,sSR,'O\u0003\u0002\u0012%\u0005!\u0011M\u001e:p\u0015\t\u0019B#A\u0002tc2T!!\u0006\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\n\u0003\u0001m\u0001\"\u0001H\u0011\u000e\u0003uQ!AH\u0010\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003AI\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005\tj\"\u0001D(viB,Ho\u0016:ji\u0016\u0014\u0018\u0001\u00029bi\"\u001c\u0001!F\u0001'!\t9\u0003G\u0004\u0002)]A\u0011\u0011\u0006L\u0007\u0002U)\u00111\u0006J\u0001\u0007yI|w\u000e\u001e \u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0002\rA\u0013X\rZ3g\u0013\t\t$G\u0001\u0004TiJLgn\u001a\u0006\u0003_1\nQ\u0001]1uQ\u0002\nqaY8oi\u0016DH\u000f\u0005\u00027w5\tqG\u0003\u00029s\u0005IQ.\u00199sK\u0012,8-\u001a\u0006\u0003uY\ta\u0001[1e_>\u0004\u0018B\u0001\u001f8\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\u0002\rM\u001c\u0007.Z7b!\ty$)D\u0001A\u0015\t\t%#A\u0003usB,7/\u0003\u0002D\u0001\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002/A|7/\u001b;j_:\fGNR5fY\u0012l\u0015\r^2iS:<\u0007C\u0001$H\u001b\u0005a\u0013B\u0001%-\u0005\u001d\u0011un\u001c7fC:\f!\"\u0019<s_N\u001b\u0007.Z7b!\tYU*D\u0001M\u0015\t\tb#\u0003\u0002O\u0019\n11k\u00195f[\u0006\fa\u0001P5oSRtDCB)T)V3v\u000b\u0005\u0002S\u00015\t\u0001\u0003C\u0003$\u000f\u0001\u0007a\u0005C\u00035\u000f\u0001\u0007Q\u0007C\u0003>\u000f\u0001\u0007a\bC\u0003E\u000f\u0001\u0007Q\tC\u0003J\u000f\u0001\u0007!*\u0001\neCR,G/[7f%\u0016\u0014\u0017m]3N_\u0012,W#\u0001.\u0011\u0005m\u000bgB\u0001/`\u001b\u0005i&B\u00010\u0013\u0003!Ig\u000e^3s]\u0006d\u0017B\u00011^\u0003QaUmZ1ds\n+\u0007.\u0019<j_J\u0004v\u000e\\5ds&\u0011!m\u0019\u0002\u0006-\u0006dW/Z\u0005\u0003I2\u00121\"\u00128v[\u0016\u0014\u0018\r^5p]\u0006\u0019B-\u0019;fi&lWMU3cCN,Wj\u001c3fA\u0005Q1/\u001a:jC2L'0\u001a:\u0016\u0003!\u0004\"AU5\n\u0005)\u0004\"AD!we>\u001cVM]5bY&TXM]\u0001\re\u0016\u001cwN\u001d3Xe&$XM]\u000b\u0002[B!aG\u001c9}\u0013\tywG\u0001\u0007SK\u000e|'\u000fZ,sSR,'\u000fE\u0002riZl\u0011A\u001d\u0006\u0003g2\u000ba!\\1qe\u0016$\u0017BA;s\u0005\u001d\teO]8LKf\u0004\"a\u001e>\u000e\u0003aT!!\u001f'\u0002\u000f\u001d,g.\u001a:jG&\u00111\u0010\u001f\u0002\u000e\u000f\u0016tWM]5d%\u0016\u001cwN\u001d3\u0011\u0007u\f\t!D\u0001\u007f\u0015\ty\u0018(\u0001\u0002j_&\u0019\u00111\u0001@\u0003\u00199+H\u000e\\,sSR\f'\r\\3\u0002\u001bI,7m\u001c:e/JLG/\u001a:!\u0003\u00159(/\u001b;f)\u0011\tY!!\u0005\u0011\u0007\u0019\u000bi!C\u0002\u0002\u00101\u0012A!\u00168ji\"9\u00111C\u0007A\u0002\u0005U\u0011a\u0001:poB!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001cI\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003?\tIBA\u0006J]R,'O\\1m%><\u0018!B2m_N,GCAA\u0006\u0001")
public class AvroOutputWriter
extends OutputWriter {
    private AvroSerializer serializer;
    private final String path;
    public final TaskAttemptContext org$apache$spark$sql$avro$AvroOutputWriter$$context;
    private StructType schema;
    private final boolean positionalFieldMatching;
    private Schema avroSchema;
    private final Enumeration.Value datetimeRebaseMode;
    private final RecordWriter<AvroKey<GenericRecord>, NullWritable> recordWriter;
    private volatile boolean bitmap$0;

    public String path() {
        return this.path;
    }

    private Enumeration.Value datetimeRebaseMode() {
        return this.datetimeRebaseMode;
    }

    private AvroSerializer serializer$lzycompute() {
        AvroOutputWriter avroOutputWriter = this;
        synchronized (avroOutputWriter) {
            if (!this.bitmap$0) {
                this.serializer = new AvroSerializer((DataType)this.schema, this.avroSchema, false, this.positionalFieldMatching, this.datetimeRebaseMode());
                this.bitmap$0 = true;
            }
        }
        this.schema = null;
        this.avroSchema = null;
        return this.serializer;
    }

    private AvroSerializer serializer() {
        if (!this.bitmap$0) {
            return this.serializer$lzycompute();
        }
        return this.serializer;
    }

    private RecordWriter<AvroKey<GenericRecord>, NullWritable> recordWriter() {
        return this.recordWriter;
    }

    public void write(InternalRow row) {
        AvroKey key = new AvroKey((Object)((GenericRecord)this.serializer().serialize(row)));
        this.recordWriter().write((Object)key, (Object)NullWritable.get());
    }

    public void close() {
        this.recordWriter().close(this.org$apache$spark$sql$avro$AvroOutputWriter$$context);
    }

    public AvroOutputWriter(String path, TaskAttemptContext context, StructType schema, boolean positionalFieldMatching, Schema avroSchema) {
        this.path = path;
        this.org$apache$spark$sql$avro$AvroOutputWriter$$context = context;
        this.schema = schema;
        this.positionalFieldMatching = positionalFieldMatching;
        this.avroSchema = avroSchema;
        this.datetimeRebaseMode = LegacyBehaviorPolicy$.MODULE$.withName((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_WRITE()));
        Enumeration.Value value = this.datetimeRebaseMode();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        scala.collection.immutable.Map fileMeta = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.sql.package$.MODULE$.SPARK_VERSION_METADATA_KEY()), (Object)package$.MODULE$.SPARK_VERSION_SHORT())}))).$plus$plus((GenTraversableOnce)(!(value != null ? !value.equals(value2) : value2 != null) ? Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.sql.package$.MODULE$.SPARK_LEGACY_DATETIME_METADATA_KEY()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.sql.package$.MODULE$.SPARK_TIMEZONE_METADATA_KEY()), (Object)SQLConf$.MODULE$.get().sessionLocalTimeZone())})) : Predef$.MODULE$.Map().empty()));
        this.recordWriter = new SparkAvroKeyOutputFormat(this, fileMeta){
            private final /* synthetic */ AvroOutputWriter $outer;

            public Path getDefaultWorkFile(TaskAttemptContext context, String extension) {
                return new Path(this.$outer.path());
            }

            public OutputStream getAvroFileOutputStream(TaskAttemptContext c) throws IOException {
                Path path = this.getDefaultWorkFile(this.$outer.org$apache$spark$sql$avro$AvroOutputWriter$$context, ".avro");
                return path.getFileSystem(this.$outer.org$apache$spark$sql$avro$AvroOutputWriter$$context.getConfiguration()).create(path);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)fileMeta$1).asJava());
            }
        }.getRecordWriter(context);
    }
}

