/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.random.EmpiricalDistribution;
import org.apache.commons.math3.stat.Frequency;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.util.Precision;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eval.DbscanEvaluator;
import org.apache.solr.client.solrj.io.eval.KmeansEvaluator;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ZplotStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private StreamContext streamContext;
    private Map letParams = new LinkedHashMap();
    private Iterator<Tuple> out;

    public ZplotStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        for (StreamExpressionParameter streamExpressionParameter : namedParams) {
            String name = ((StreamExpressionNamedParameter)streamExpressionParameter).getName();
            StreamExpressionParameter param = ((StreamExpressionNamedParameter)streamExpressionParameter).getParameter();
            if (param instanceof StreamExpressionValue) {
                String paramValue = ((StreamExpressionValue)param).getValue();
                this.letParams.put(name, factory.constructPrimitiveObject(paramValue));
                continue;
            }
            if (!factory.isEvaluator((StreamExpression)param)) continue;
            StreamEvaluator evaluator = factory.constructEvaluator((StreamExpression)param);
            this.letParams.put(name, evaluator);
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-decorator");
        explanation.setExpression(this.toExpression(factory, false).toString());
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        return l;
    }

    @Override
    public Tuple read() throws IOException {
        if (this.out.hasNext()) {
            return this.out.next();
        }
        return Tuple.EOF();
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void open() throws IOException {
        String rowLabel;
        List<String> rowLabels;
        Matrix m;
        Object o;
        Map<String, Object> lets = this.streamContext.getLets();
        Set entries = this.letParams.entrySet();
        HashMap<String, Object> evaluated = new HashMap<String, Object>();
        int numTuples = -1;
        int columns = 0;
        boolean table = false;
        boolean distribution = false;
        boolean clusters = false;
        boolean heat = false;
        for (Map.Entry entry : entries) {
            ++columns;
            String name = (String)entry.getKey();
            if (name.equals("table")) {
                table = true;
            } else if (name.equals("dist")) {
                distribution = true;
            } else if (name.equals("clusters")) {
                clusters = true;
            } else if (name.equals("heat")) {
                heat = true;
            }
            Object o2 = entry.getValue();
            if (o2 instanceof StreamEvaluator) {
                Tuple tuple = new Tuple(lets);
                StreamEvaluator streamEvaluator = (StreamEvaluator)o2;
                streamEvaluator.setStreamContext(this.streamContext);
                Object object = streamEvaluator.evaluate(tuple);
                if (object instanceof List) {
                    List l2 = (List)object;
                    if (numTuples == -1) {
                        numTuples = l2.size();
                    } else if (l2.size() != numTuples) {
                        throw new IOException("All lists provided to the zplot function must be the same length.");
                    }
                    evaluated.put(name, l2);
                    continue;
                }
                if (object instanceof Tuple) {
                    evaluated.put(name, object);
                    continue;
                }
                evaluated.put(name, object);
                continue;
            }
            Object object = lets.get(o2);
            if (object instanceof List) {
                List list = (List)object;
                if (numTuples == -1) {
                    numTuples = list.size();
                } else if (list.size() != numTuples) {
                    throw new IOException("All lists provided to the zplot function must be the same length.");
                }
                evaluated.put(name, list);
                continue;
            }
            if (object instanceof Tuple) {
                evaluated.put(name, object);
                continue;
            }
            if (!(object instanceof Matrix)) continue;
            evaluated.put(name, object);
        }
        if (columns > 1 && (table || distribution)) {
            throw new IOException("If the table or dist parameter is set there can only be one parameter.");
        }
        ArrayList<Tuple> outTuples = new ArrayList<Tuple>();
        if (!(table || distribution || clusters || heat)) {
            for (int i = 0; i < numTuples; ++i) {
                Tuple tuple = new Tuple();
                for (Map.Entry entry : evaluated.entrySet()) {
                    List list = (List)entry.getValue();
                    tuple.put(entry.getKey(), list.get(i));
                }
                outTuples.add(tuple);
            }
            if (((Tuple)outTuples.get(0)).getFields().containsKey("y") && !((Tuple)outTuples.get(0)).getFields().containsKey("x")) {
                int x = 0;
                for (Tuple tuple : outTuples) {
                    tuple.put("x", x++);
                }
            }
        } else if (clusters) {
            List points;
            List<CentroidCluster<KmeansEvaluator.ClusterPoint>> cs;
            Tuple ct;
            o = evaluated.get("clusters");
            if (o instanceof KmeansEvaluator.ClusterTuple) {
                ct = (KmeansEvaluator.ClusterTuple)o;
                cs = ((KmeansEvaluator.ClusterTuple)ct).getClusters();
                boolean bl = false;
                for (CentroidCluster<KmeansEvaluator.ClusterPoint> centroidCluster : cs) {
                    void var14_21;
                    ++var14_21;
                    points = centroidCluster.getPoints();
                    for (KmeansEvaluator.ClusterPoint p : points) {
                        Tuple tuple = new Tuple();
                        tuple.put("x", p.getPoint()[0]);
                        tuple.put("y", p.getPoint()[1]);
                        tuple.put("cluster", "cluster" + (int)var14_21);
                        outTuples.add(tuple);
                    }
                }
            } else if (o instanceof DbscanEvaluator.ClusterTuple) {
                ct = (DbscanEvaluator.ClusterTuple)o;
                cs = ((DbscanEvaluator.ClusterTuple)ct).getClusters();
                boolean bl = false;
                for (Cluster cluster : cs) {
                    void var14_23;
                    ++var14_23;
                    points = cluster.getPoints();
                    for (DbscanEvaluator.ClusterPoint p : points) {
                        Tuple tuple = new Tuple();
                        tuple.put("x", p.getPoint()[0]);
                        tuple.put("y", p.getPoint()[1]);
                        tuple.put("cluster", "cluster" + (int)var14_23);
                        outTuples.add(tuple);
                    }
                }
            }
        } else if (distribution) {
            List list;
            o = evaluated.get("dist");
            if (o instanceof RealDistribution) {
                void var16_56;
                void var16_54;
                RealDistribution realDistribution = (RealDistribution)o;
                List binStats = null;
                if (realDistribution instanceof EmpiricalDistribution) {
                    EmpiricalDistribution empiricalDistribution = (EmpiricalDistribution)realDistribution;
                    binStats = empiricalDistribution.getBinStats();
                } else {
                    double[] dArray = realDistribution.sample(500000);
                    EmpiricalDistribution empiricalDistribution = new EmpiricalDistribution(32);
                    empiricalDistribution.load(dArray);
                    binStats = empiricalDistribution.getBinStats();
                }
                double[] dArray = new double[binStats.size()];
                double[] dArray2 = new double[binStats.size()];
                boolean bl = false;
                while (var16_54 < binStats.size()) {
                    dArray[var16_54] = ((SummaryStatistics)binStats.get((int)var16_54)).getMean();
                    dArray2[var16_54] = realDistribution.density(dArray[var16_54]);
                    ++var16_54;
                }
                boolean bl2 = false;
                while (var16_56 < dArray.length) {
                    Tuple tuple = new Tuple();
                    if (!Double.isNaN(dArray[var16_56])) {
                        tuple.put("x", Precision.round((double)dArray[var16_56], (int)2));
                        if (dArray2[var16_56] == Double.NEGATIVE_INFINITY || dArray2[var16_56] == Double.POSITIVE_INFINITY) {
                            tuple.put("y", 0);
                        } else {
                            tuple.put("y", dArray2[var16_56]);
                        }
                        outTuples.add(tuple);
                    }
                    ++var16_56;
                }
            } else if (o instanceof IntegerDistribution) {
                int i;
                IntegerDistribution integerDistribution = (IntegerDistribution)o;
                int[] samples = integerDistribution.sample(50000);
                Frequency frequency = new Frequency();
                for (int i2 : samples) {
                    frequency.addValue(i2);
                }
                Iterator iterator = frequency.valuesIterator();
                ArrayList<Long> arrayList = new ArrayList<Long>();
                while (iterator.hasNext()) {
                    arrayList.add((Long)iterator.next());
                }
                System.out.println(arrayList);
                int[] x = new int[arrayList.size()];
                double[] y = new double[arrayList.size()];
                for (i = 0; i < arrayList.size(); ++i) {
                    x[i] = ((Long)arrayList.get(i)).intValue();
                    y[i] = integerDistribution.probability(x[i]);
                }
                for (i = 0; i < x.length; ++i) {
                    Tuple tuple = new Tuple();
                    tuple.put("x", x[i]);
                    tuple.put("y", y[i]);
                    outTuples.add(tuple);
                }
            } else if (o instanceof List && (list = (List)o).get(0) instanceof Tuple) {
                Tuple outtuple;
                List tlist = (List)o;
                Tuple tuple = (Tuple)tlist.get(0);
                if (tuple.getFields().containsKey("N")) {
                    for (Tuple tuple2 : tlist) {
                        outtuple = new Tuple();
                        outtuple.put("x", Precision.round((double)((Double)tuple2.get("mean")), (int)2));
                        outtuple.put("y", tuple2.get("prob"));
                        outTuples.add(outtuple);
                    }
                } else if (tuple.getFields().containsKey("count")) {
                    for (Tuple tuple3 : tlist) {
                        outtuple = new Tuple();
                        outtuple.put("x", tuple3.get("value"));
                        outtuple.put("y", tuple3.get("pct"));
                        outTuples.add(outtuple);
                    }
                }
            }
        } else if (table) {
            o = evaluated.get("table");
            if (o instanceof Matrix) {
                void var16_64;
                m = (Matrix)o;
                rowLabels = m.getRowLabels();
                List<String> list = m.getColumnLabels();
                double[][] dArray = m.getData();
                boolean bl = false;
                while (var16_64 < dArray.length) {
                    rowLabel = null;
                    rowLabel = rowLabels != null ? rowLabels.get((int)var16_64) : Integer.toString((int)var16_64);
                    Tuple tuple = new Tuple();
                    tuple.put("rowLabel", rowLabel);
                    double[] row = dArray[var16_64];
                    for (int j = 0; j < row.length; ++j) {
                        String colLabel = null;
                        colLabel = list != null ? list.get(j) : "col" + Integer.toString(j);
                        tuple.put(colLabel, dArray[var16_64][j]);
                    }
                    outTuples.add(tuple);
                    ++var16_64;
                }
            }
        } else if (heat && (o = evaluated.get("heat")) instanceof Matrix) {
            void var16_66;
            m = (Matrix)o;
            rowLabels = m.getRowLabels();
            List<String> list = m.getColumnLabels();
            double[][] dArray = m.getData();
            boolean bl = false;
            while (var16_66 < dArray.length) {
                rowLabel = null;
                rowLabel = rowLabels != null ? rowLabels.get((int)var16_66) : "row" + ZplotStream.pad(Integer.toString((int)var16_66), dArray.length);
                double[] row = dArray[var16_66];
                for (int j = 0; j < row.length; ++j) {
                    Tuple tuple = new Tuple();
                    tuple.put("y", rowLabel);
                    String colLabel = null;
                    colLabel = list != null ? list.get(j) : "col" + ZplotStream.pad(Integer.toString(j), row.length);
                    tuple.put("x", colLabel);
                    tuple.put("z", dArray[var16_66][j]);
                    outTuples.add(tuple);
                }
                ++var16_66;
            }
        }
        this.out = outTuples.iterator();
    }

    public static String pad(String v, int length) {
        if (length < 11) {
            return v;
        }
        if (length < 101) {
            return ZplotStream.prepend(v, 2);
        }
        if (length < 1001) {
            return ZplotStream.prepend(v, 3);
        }
        if (length < 10001) {
            return ZplotStream.prepend(v, 4);
        }
        return ZplotStream.prepend(v, 5);
    }

    private static String prepend(String v, int length) {
        while (v.length() < length) {
            v = "0" + v;
        }
        return v;
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

