/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.beans;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.beans.BindingException;
import org.apache.solr.client.solrj.beans.Field;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.SuppressForbidden;

public class DocumentObjectBinder {
    private final Map<Class, List<DocField>> infocache = new ConcurrentHashMap<Class, List<DocField>>();
    public static final String DEFAULT = "#default";

    public <T> List<T> getBeans(Class<T> clazz, SolrDocumentList solrDocList) {
        List<DocField> fields = this.getDocFields(clazz);
        ArrayList<T> result = new ArrayList<T>(solrDocList.size());
        for (SolrDocument sdoc : solrDocList) {
            result.add(this.getBean(clazz, fields, sdoc));
        }
        return result;
    }

    public <T> T getBean(Class<T> clazz, SolrDocument solrDoc) {
        return this.getBean(clazz, null, solrDoc);
    }

    private <T> T getBean(Class<T> clazz, List<DocField> fields, SolrDocument solrDoc) {
        if (fields == null) {
            fields = this.getDocFields(clazz);
        }
        try {
            T obj = clazz.newInstance();
            for (DocField docField : fields) {
                docField.inject(obj, solrDoc);
            }
            return obj;
        }
        catch (Exception e) {
            throw new BindingException("Could not instantiate object of " + clazz, e);
        }
    }

    public SolrInputDocument toSolrInputDocument(Object obj) {
        List<DocField> fields = this.getDocFields(obj.getClass());
        if (fields.isEmpty()) {
            throw new BindingException("class: " + obj.getClass() + " does not define any fields.");
        }
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        for (DocField field : fields) {
            if (field.dynamicFieldNamePatternMatcher != null && field.get(obj) != null && field.isContainedInMap) {
                Map mapValue = (Map)field.get(obj);
                for (Map.Entry e : mapValue.entrySet()) {
                    doc.setField((String)e.getKey(), e.getValue(), 1.0f);
                }
                continue;
            }
            if (field.child != null) {
                this.addChild(obj, field, doc);
                continue;
            }
            doc.setField(field.name, field.get(obj), 1.0f);
        }
        return doc;
    }

    private void addChild(Object obj, DocField field, SolrInputDocument doc) {
        Object val = field.get(obj);
        if (val == null) {
            return;
        }
        if (val instanceof Collection) {
            Collection collection = (Collection)val;
            for (Object o : collection) {
                SolrInputDocument child = this.toSolrInputDocument(o);
                doc.addChildDocument(child);
            }
        } else if (val.getClass().isArray()) {
            Object[] objs;
            for (Object o : objs = (Object[])val) {
                doc.addChildDocument(this.toSolrInputDocument(o));
            }
        } else {
            doc.addChildDocument(this.toSolrInputDocument(val));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DocField> getDocFields(Class clazz) {
        List<DocField> fields = this.infocache.get(clazz);
        if (fields == null) {
            Map<Class, List<DocField>> map = this.infocache;
            synchronized (map) {
                fields = this.collectInfo(clazz);
                this.infocache.put(clazz, fields);
            }
        }
        return fields;
    }

    @SuppressForbidden(reason="Needs access to possibly private @Field annotated fields/methods")
    private List<DocField> collectInfo(Class clazz) {
        ArrayList<DocField> fields = new ArrayList<DocField>();
        ArrayList<AccessibleObject> members = new ArrayList<AccessibleObject>();
        for (Class superClazz = clazz; superClazz != null && superClazz != Object.class; superClazz = superClazz.getSuperclass()) {
            members.addAll(Arrays.asList(superClazz.getDeclaredFields()));
            members.addAll(Arrays.asList(superClazz.getDeclaredMethods()));
        }
        boolean childFieldFound = false;
        for (AccessibleObject member : members) {
            if (!member.isAnnotationPresent(Field.class)) continue;
            AccessController.doPrivileged(() -> {
                member.setAccessible(true);
                return null;
            });
            DocField df = new DocField(member);
            if (df.child != null) {
                if (childFieldFound) {
                    throw new BindingException(clazz.getName() + " cannot have more than one Field with child=true");
                }
                childFieldFound = true;
            }
            fields.add(df);
        }
        return fields;
    }

    private class DocField {
        private Field annotation;
        private String name;
        private java.lang.reflect.Field field;
        private Method setter;
        private Method getter;
        private Class type;
        private boolean isArray;
        private boolean isList;
        private List<DocField> child;
        private boolean isContainedInMap;
        private Pattern dynamicFieldNamePatternMatcher;

        public DocField(AccessibleObject member) {
            block7: {
                String gname;
                if (member instanceof java.lang.reflect.Field) {
                    this.field = (java.lang.reflect.Field)member;
                } else {
                    this.setter = (Method)member;
                }
                this.annotation = member.getAnnotation(Field.class);
                this.storeName(this.annotation);
                this.storeType();
                if (this.setter != null && (gname = this.setter.getName()).startsWith("set")) {
                    gname = "get" + gname.substring(3);
                    try {
                        this.getter = this.setter.getDeclaringClass().getMethod(gname, null);
                    }
                    catch (Exception ex) {
                        if (this.type != Boolean.class) break block7;
                        gname = "is" + this.setter.getName().substring(3);
                        try {
                            this.getter = this.setter.getDeclaringClass().getMethod(gname, null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        private void storeName(Field annotation) {
            if (annotation.value().equals(DocumentObjectBinder.DEFAULT)) {
                String setterName;
                this.name = this.field != null ? this.field.getName() : ((setterName = this.setter.getName()).startsWith("set") && setterName.length() > 3 ? setterName.substring(3, 4).toLowerCase(Locale.ROOT) + setterName.substring(4) : this.setter.getName());
            } else if (annotation.value().indexOf(42) >= 0) {
                this.name = annotation.value().replaceFirst("\\*", "\\.*");
                this.dynamicFieldNamePatternMatcher = Pattern.compile("^" + this.name + "$");
            } else {
                this.name = annotation.value();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void storeType() {
            if (this.field != null) {
                this.type = this.field.getType();
            } else {
                Class<?>[] params = this.setter.getParameterTypes();
                if (params.length != 1) {
                    throw new BindingException("Invalid setter method. Must have one and only one parameter");
                }
                this.type = params[0];
            }
            if (this.type == Collection.class || this.type == List.class || this.type == ArrayList.class) {
                this.isList = true;
                if (this.annotation.child()) {
                    this.populateChild(this.field.getGenericType());
                    return;
                } else {
                    this.type = Object.class;
                }
                return;
            } else {
                if (this.type == byte[].class) return;
                if (this.type.isArray()) {
                    this.isArray = true;
                    if (this.annotation.child()) {
                        this.populateChild(this.type.getComponentType());
                        return;
                    } else {
                        this.type = this.type.getComponentType();
                    }
                    return;
                } else if (this.type == Map.class || this.type == HashMap.class) {
                    ParameterizedType parameterizedType;
                    Type[] types;
                    if (this.annotation.child()) {
                        throw new BindingException("Map should is not a valid type for a child document");
                    }
                    this.isContainedInMap = true;
                    this.type = Object.class;
                    if (this.field == null || !(this.field.getGenericType() instanceof ParameterizedType) || (types = (parameterizedType = (ParameterizedType)this.field.getGenericType()).getActualTypeArguments()) == null || types.length != 2 || types[0] != String.class) return;
                    if (types[1] instanceof Class) {
                        if (types[1] == Collection.class || types[1] == List.class || types[1] == ArrayList.class) {
                            this.type = Object.class;
                            this.isList = true;
                            return;
                        } else {
                            this.type = (Class)types[1];
                        }
                        return;
                    } else if (types[1] instanceof ParameterizedType) {
                        Type rawType = ((ParameterizedType)types[1]).getRawType();
                        if (rawType != Collection.class && rawType != List.class && rawType != ArrayList.class) return;
                        this.type = Object.class;
                        this.isList = true;
                        return;
                    } else {
                        if (!(types[1] instanceof GenericArrayType)) throw new BindingException("Allowed type for values of mapping a dynamicField are : Object, Object[] and List");
                        this.type = (Class)((GenericArrayType)types[1]).getGenericComponentType();
                        this.isArray = true;
                    }
                    return;
                } else {
                    if (!this.annotation.child()) return;
                    this.populateChild(this.type);
                }
            }
        }

        private void populateChild(Type typ) {
            if (typ == null) {
                throw new RuntimeException("no type information available for" + (this.field == null ? this.setter : this.field));
            }
            if (typ.getClass() == Class.class) {
                this.type = (Class)typ;
            } else if (typ instanceof ParameterizedType) {
                try {
                    this.type = Class.forName(((ParameterizedType)typ).getActualTypeArguments()[0].getTypeName());
                }
                catch (ClassNotFoundException e) {
                    throw new BindingException("Invalid type information available for" + (this.field == null ? this.setter : this.field));
                }
            } else {
                throw new BindingException("Invalid type information available for" + (this.field == null ? this.setter : this.field));
            }
            this.child = DocumentObjectBinder.this.getDocFields(this.type);
        }

        private Object getFieldValue(SolrDocument solrDocument) {
            if (this.child != null) {
                List<SolrDocument> children = solrDocument.getChildDocuments();
                if (children == null || children.isEmpty()) {
                    return null;
                }
                if (this.isList) {
                    ArrayList<Object> list = new ArrayList<Object>(children.size());
                    for (SolrDocument c : children) {
                        list.add(DocumentObjectBinder.this.getBean(this.type, this.child, c));
                    }
                    return list;
                }
                if (this.isArray) {
                    Object[] arr = (Object[])Array.newInstance(this.type, children.size());
                    for (int i = 0; i < children.size(); ++i) {
                        arr[i] = DocumentObjectBinder.this.getBean(this.type, this.child, children.get(i));
                    }
                    return arr;
                }
                return DocumentObjectBinder.this.getBean(this.type, this.child, children.get(0));
            }
            Object fieldValue = solrDocument.getFieldValue(this.name);
            if (fieldValue != null) {
                return fieldValue;
            }
            if (this.dynamicFieldNamePatternMatcher == null) {
                return null;
            }
            HashMap allValuesMap = null;
            ArrayList allValuesList = null;
            if (this.isContainedInMap) {
                allValuesMap = new HashMap();
            } else {
                allValuesList = new ArrayList();
            }
            for (String field : solrDocument.getFieldNames()) {
                Object[] val;
                if (!this.dynamicFieldNamePatternMatcher.matcher(field).find() || (val = solrDocument.getFieldValue(field)) == null) continue;
                if (this.isContainedInMap) {
                    if (this.isList) {
                        if (!(val instanceof List)) {
                            ArrayList al = new ArrayList();
                            al.add(val);
                            val = al;
                        }
                    } else if (this.isArray) {
                        if (!(val instanceof List)) {
                            Object[] arr = (Object[])Array.newInstance(this.type, 1);
                            arr[0] = val;
                            val = arr;
                        } else {
                            val = Array.newInstance(this.type, ((List)val).size());
                        }
                    }
                    allValuesMap.put(field, val);
                    continue;
                }
                if (val instanceof Collection) {
                    allValuesList.addAll((Collection)val);
                    continue;
                }
                allValuesList.add(val);
            }
            if (this.isContainedInMap) {
                return allValuesMap.isEmpty() ? null : allValuesMap;
            }
            return allValuesList.isEmpty() ? null : allValuesList;
        }

        <T> void inject(T obj, SolrDocument sdoc) {
            ArrayList val = this.getFieldValue(sdoc);
            if (val == null) {
                return;
            }
            if (this.isArray && !this.isContainedInMap) {
                ArrayList list;
                if (val.getClass().isArray()) {
                    this.set(obj, val);
                    return;
                }
                if (val instanceof List) {
                    list = val;
                } else {
                    list = new ArrayList();
                    list.add(val);
                }
                this.set(obj, list.toArray((Object[])Array.newInstance(this.type, list.size())));
            } else if (this.isList && !this.isContainedInMap) {
                if (!(val instanceof List)) {
                    ArrayList list = new ArrayList();
                    list.add(val);
                    val = list;
                }
                this.set(obj, val);
            } else if (this.isContainedInMap) {
                if (val instanceof Map) {
                    this.set(obj, val);
                }
            } else {
                this.set(obj, val);
            }
        }

        private void set(Object obj, Object v) {
            if (v != null && this.type == ByteBuffer.class && v.getClass() == byte[].class) {
                v = ByteBuffer.wrap((byte[])v);
            }
            try {
                if (this.field != null) {
                    this.field.set(obj, v);
                } else if (this.setter != null) {
                    this.setter.invoke(obj, v);
                }
            }
            catch (Exception e) {
                throw new BindingException("Exception while setting value : " + v + " on " + (this.field != null ? this.field : this.setter), e);
            }
        }

        public Object get(Object obj) {
            if (this.field != null) {
                try {
                    return this.field.get(obj);
                }
                catch (Exception e) {
                    throw new BindingException("Exception while getting value: " + this.field, e);
                }
            }
            if (this.getter == null) {
                throw new BindingException("Missing getter for field: " + this.name + " -- You can only call the 'get' for fields that have a field of 'get' method");
            }
            try {
                return this.getter.invoke(obj, (Object[])null);
            }
            catch (Exception e) {
                throw new BindingException("Exception while getting value: " + this.getter, e);
            }
        }
    }
}

