/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.timeouts;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutsProvider {
    private static final Logger log = LoggerFactory.getLogger(TimeoutsProvider.class);
    public static final String PROP_TIMEOUT_MULTIPLIER = "sling.testing.timeout.multiplier";
    private static float timeoutFactor = -1.0f;
    private static TimeoutsProvider INSTANCE;

    private TimeoutsProvider() {
        if (timeoutFactor < 0.0f) {
            timeoutFactor = 1.0f;
            String str = System.getProperty(PROP_TIMEOUT_MULTIPLIER);
            if (str != null) {
                try {
                    timeoutFactor = Float.valueOf(str.trim()).floatValue();
                    log.info("Timeout factor set to {} from system property {}", (Object)Float.valueOf(timeoutFactor), (Object)PROP_TIMEOUT_MULTIPLIER);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalStateException("Invalid timeout factor: sling.testing.timeout.multiplier=" + str);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TimeoutsProvider getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<TimeoutsProvider> clazz = TimeoutsProvider.class;
        synchronized (TimeoutsProvider.class) {
            INSTANCE = new TimeoutsProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public long getTimeout(long nomimalValue) {
        long result = (long)((float)nomimalValue * timeoutFactor);
        return result;
    }

    public int getTimeout(int nomimalValue) {
        int result = (int)((float)nomimalValue * timeoutFactor);
        return result;
    }

    public int getTimeout(String systemPropertyName, int defaultNominalValue) {
        int result = defaultNominalValue;
        String str = System.getProperty(systemPropertyName);
        if (str != null) {
            result = Integer.parseInt(str);
        }
        return this.getTimeout(result);
    }
}

