/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.osgi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.osgi.ServiceInfo;
import org.codehaus.jackson.JsonNode;

public class ServicesInfo {
    private JsonNode root = null;

    public ServicesInfo(JsonNode root) throws ClientException {
        this.root = root;
        if (root.get("status") == null) {
            throw new ClientException("No Status returned!");
        }
        if (root.get("serviceCount") == null) {
            throw new ClientException("No serviceCount returned!");
        }
    }

    public int getTotalNumOfServices() {
        return this.root.get("serviceCount").getIntValue();
    }

    public ServiceInfo forId(String id) throws ClientException {
        JsonNode serviceInfo = this.findBy("id", id);
        return serviceInfo != null ? new ServiceInfo(serviceInfo) : null;
    }

    public Collection<ServiceInfo> forType(String type) throws ClientException {
        LinkedList<ServiceInfo> results = new LinkedList<ServiceInfo>();
        List<JsonNode> serviceInfoNodes = this.findAllContainingValueInArray("types", type);
        for (JsonNode serviceInfoNode : serviceInfoNodes) {
            results.add(new ServiceInfo(serviceInfoNode));
        }
        return results;
    }

    private JsonNode findBy(String key, String value) {
        List<JsonNode> result = this.findBy(key, value, true, false);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    private List<JsonNode> findAllContainingValueInArray(String key, String value) {
        return this.findBy(key, value, false, true);
    }

    private List<JsonNode> findBy(String key, String value, boolean onlyReturnFirstMatch, boolean arrayContainingMatch) {
        Iterator nodes = this.root.get("data").getElements();
        LinkedList<JsonNode> results = new LinkedList<JsonNode>();
        while (nodes.hasNext()) {
            JsonNode node = (JsonNode)nodes.next();
            if (null == node.get(key) || !node.get(key).isValueNode()) continue;
            String valueNode = node.get(key).getTextValue();
            if (arrayContainingMatch) {
                if (!ServicesInfo.splitPseudoJsonValueArray(valueNode).contains(value)) continue;
                results.add(node);
                continue;
            }
            if (!valueNode.equals(value)) continue;
            results.add(node);
        }
        return results;
    }

    static final List<String> splitPseudoJsonValueArray(String value) {
        if (value.startsWith("[") && value.length() >= 2) {
            String pureArrayValues = value.substring(1, value.length() - 1);
            String[] resultArray = pureArrayValues.split(", |,");
            return Arrays.asList(resultArray);
        }
        return Collections.singletonList(value);
    }
}

