/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.osgi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.osgi.Bundle;
import org.codehaus.jackson.JsonNode;

public class BundleInfo {
    private JsonNode bundle;

    public BundleInfo(JsonNode root) throws ClientException {
        if (root.get("id") != null) {
            if (root.get("id") == null) {
                throw new ClientException("No Bundle Info returned");
            }
            this.bundle = root;
        } else {
            if (root.get("data") == null && root.get("data").size() < 1) {
                throw new ClientException("No Bundle Info returned");
            }
            this.bundle = root.get("data").get(0);
        }
    }

    public int getId() {
        return this.bundle.get("id").getIntValue();
    }

    public String getName() {
        return this.bundle.get("name").getTextValue();
    }

    public String getVersion() {
        return this.bundle.get("version").getTextValue();
    }

    public boolean isFragment() {
        return this.bundle.get("fragment").getBooleanValue();
    }

    public Bundle.Status getStatus() {
        return Bundle.Status.value(this.bundle.get("state").getTextValue());
    }

    public String getSymbolicName() {
        return this.bundle.get("symbolicName").getTextValue();
    }

    public String getCategory() {
        return this.bundle.get("category").getTextValue();
    }

    public String getProperty(String key) {
        Map<String, String> props = this.getProperties();
        return props.get(key);
    }

    public Map<String, String> getProperties() {
        JsonNode props = this.bundle.get("props");
        HashMap<String, String> entries = new HashMap<String, String>();
        if (props != null) {
            Iterator it = props.getElements();
            while (it.hasNext()) {
                JsonNode n = (JsonNode)it.next();
                entries.put(n.get("key").getTextValue(), n.get("value").getTextValue());
            }
        }
        return entries;
    }
}

