/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.resourceresolver.impl.mapping.MapConfigurationProvider;
import org.apache.sling.resourceresolver.impl.mapping.MapEntry;
import org.apache.sling.resourceresolver.impl.mapping.Mapping;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapEntries
implements EventHandler {
    public static final MapEntries EMPTY = new MapEntries();
    private static final String PROP_REG_EXP = "sling:match";
    public static final String PROP_REDIRECT_EXTERNAL = "sling:redirect";
    public static final String PROP_REDIRECT_EXTERNAL_STATUS = "sling:status";
    public static final String PROP_REDIRECT_EXTERNAL_REDIRECT_STATUS = "sling:redirectStatus";
    private static final String GLOBAL_LIST_KEY = "*";
    public static final String DEFAULT_MAP_ROOT = "/etc/map";
    public static final int DEFAULT_DEFAULT_VANITY_PATH_REDIRECT_STATUS = 302;
    private static final String JCR_SYSTEM_PREFIX = "/jcr:system/";
    static final String ANY_SCHEME_HOST = "[^/]+/[^/]+";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private MapConfigurationProvider factory;
    private volatile ResourceResolver resolver;
    private final String mapRoot;
    private Map<String, List<MapEntry>> resolveMapsMap;
    private Collection<MapEntry> mapMaps;
    private Collection<String> vanityTargets;
    private Map<String, Map<String, String>> aliasMap;
    private ServiceRegistration registration;
    private EventAdmin eventAdmin;
    private final Semaphore initTrigger = new Semaphore(0);
    private final ReentrantLock initializing = new ReentrantLock();
    private final boolean enabledVanityPaths;
    private final boolean enableOptimizeAliasResolution;
    private final List<MapConfigurationProvider.VanityPathConfig> vanityPathConfig;

    private MapEntries() {
        this.factory = null;
        this.resolver = null;
        this.mapRoot = DEFAULT_MAP_ROOT;
        this.resolveMapsMap = Collections.singletonMap(GLOBAL_LIST_KEY, Collections.EMPTY_LIST);
        this.mapMaps = Collections.emptyList();
        this.vanityTargets = Collections.emptySet();
        this.aliasMap = Collections.emptyMap();
        this.registration = null;
        this.eventAdmin = null;
        this.enabledVanityPaths = true;
        this.enableOptimizeAliasResolution = true;
        this.vanityPathConfig = null;
    }

    public MapEntries(MapConfigurationProvider factory, BundleContext bundleContext, EventAdmin eventAdmin) throws LoginException {
        this.resolver = factory.getAdministrativeResourceResolver(null);
        this.factory = factory;
        this.mapRoot = factory.getMapRoot();
        this.enabledVanityPaths = factory.isVanityPathEnabled();
        this.vanityPathConfig = factory.getVanityPathConfig();
        this.enableOptimizeAliasResolution = factory.isOptimizeAliasResolutionEnabled();
        this.eventAdmin = eventAdmin;
        this.resolveMapsMap = Collections.singletonMap(GLOBAL_LIST_KEY, Collections.EMPTY_LIST);
        this.mapMaps = Collections.emptyList();
        this.vanityTargets = Collections.emptySet();
        this.aliasMap = Collections.emptyMap();
        this.doInit();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("event.topics", "org/apache/sling/api/resource/*");
        ((Dictionary)props).put("event.filter", MapEntries.createFilter(this.enabledVanityPaths));
        ((Dictionary)props).put("service.description", "Map Entries Observation");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.registration = bundleContext.registerService(EventHandler.class.getName(), (Object)this, props);
        Thread updateThread = new Thread(new Runnable(){

            public void run() {
                MapEntries.this.init();
            }
        }, "MapEntries Update");
        updateThread.setDaemon(true);
        updateThread.start();
    }

    private void triggerInit() {
        if (this.initTrigger.availablePermits() < 1) {
            this.initTrigger.release();
        }
    }

    private void init() {
        while (this.resolver != null) {
            try {
                this.initTrigger.acquire();
                this.doInit();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInit() {
        this.initializing.lock();
        try {
            ResourceResolver resolver = this.resolver;
            MapConfigurationProvider factory = this.factory;
            if (resolver == null || factory == null) {
                return;
            }
            HashMap<String, List<MapEntry>> newResolveMapsMap = new HashMap<String, List<MapEntry>>();
            ArrayList<MapEntry> globalResolveMap = new ArrayList<MapEntry>();
            TreeMap<String, MapEntry> newMapMaps = new TreeMap<String, MapEntry>();
            this.loadResolverMap(resolver, globalResolveMap, newMapMaps);
            Set vanityTargets = this.enabledVanityPaths ? this.loadVanityPaths(resolver, newResolveMapsMap) : Collections.emptySet();
            this.loadConfiguration(factory, globalResolveMap);
            this.loadMapConfiguration(factory, newMapMaps);
            Collections.sort(globalResolveMap);
            newResolveMapsMap.put(GLOBAL_LIST_KEY, globalResolveMap);
            if (this.enableOptimizeAliasResolution) {
                Map<String, Map<String, String>> aliasMap = this.loadAliases(resolver);
                this.aliasMap = this.makeUnmodifiableMap(aliasMap);
            }
            this.vanityTargets = Collections.unmodifiableCollection(vanityTargets);
            this.resolveMapsMap = Collections.unmodifiableMap(newResolveMapsMap);
            this.mapMaps = Collections.unmodifiableSet(new TreeSet(newMapMaps.values()));
            this.sendChangeEvent();
        }
        catch (Exception e) {
            this.log.warn("doInit: Unexpected problem during initialization", (Throwable)e);
        }
        finally {
            this.initializing.unlock();
        }
    }

    public boolean isOptimizeAliasResolutionEnabled() {
        return this.enableOptimizeAliasResolution;
    }

    private <K1, K2, V> Map<K1, Map<K2, V>> makeUnmodifiableMap(Map<K1, Map<K2, V>> map) {
        HashMap<K1, Map<K2, V>> newMap = new HashMap<K1, Map<K2, V>>();
        for (K1 key : map.keySet()) {
            newMap.put(key, Collections.unmodifiableMap(map.get(key)));
        }
        return Collections.unmodifiableMap(newMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        boolean initLocked;
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        try {
            initLocked = this.initializing.tryLock(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            initLocked = false;
        }
        try {
            if (!initLocked) {
                this.log.warn("dispose: Could not acquire initialization lock within 10 seconds; ongoing intialization may fail");
            }
            ResourceResolver oldResolver = this.resolver;
            this.resolver = null;
            this.triggerInit();
            if (oldResolver != null) {
                oldResolver.close();
            } else {
                this.log.warn("dispose: ResourceResolver has already been cleared before; duplicate call to dispose ?");
            }
        }
        finally {
            if (initLocked) {
                this.initializing.unlock();
            }
        }
        this.factory = null;
        this.eventAdmin = null;
    }

    public List<MapEntry> getResolveMaps() {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        for (List<MapEntry> list : this.resolveMapsMap.values()) {
            entries.addAll(list);
        }
        Collections.sort(entries);
        return entries;
    }

    public Iterator<MapEntry> getResolveMapsIterator(String requestPath) {
        String key = null;
        int firstIndex = requestPath.indexOf(47);
        int secondIndex = requestPath.indexOf(47, firstIndex + 1);
        if (secondIndex != -1) {
            key = requestPath.substring(secondIndex);
        }
        return new MapEntryIterator(key, this.resolveMapsMap);
    }

    public Collection<MapEntry> getMapMaps() {
        return this.mapMaps;
    }

    public Map<String, String> getAliasMap(String parentPath) {
        return this.aliasMap.get(parentPath);
    }

    public void handleEvent(Event event) {
        Object p = event.getProperty("path");
        if (!(p instanceof String)) {
            return;
        }
        String path = (String)p;
        if (path.startsWith(JCR_SYSTEM_PREFIX)) {
            return;
        }
        boolean doInit = true;
        if ("org/apache/sling/api/resource/Resource/REMOVED".equals(event.getTopic()) && !path.startsWith(this.mapRoot)) {
            String checkPath = path.endsWith("/jcr:content") ? path.substring(0, path.length() - 12) : path;
            doInit = false;
            for (String target : this.vanityTargets) {
                if (!target.startsWith(checkPath)) continue;
                doInit = true;
                break;
            }
            for (String target : this.aliasMap.keySet()) {
                if (!target.startsWith(checkPath)) continue;
                doInit = true;
                break;
            }
        }
        if (doInit) {
            this.triggerInit();
        }
    }

    private void sendChangeEvent() {
        if (this.eventAdmin != null) {
            Event event = new Event("org/apache/sling/api/resource/ResourceResolverMapping/CHANGED", (Dictionary)null);
            this.eventAdmin.postEvent(event);
        }
    }

    private void loadResolverMap(ResourceResolver resolver, List<MapEntry> entries, Map<String, MapEntry> mapEntries) {
        Resource res = resolver.getResource(this.mapRoot);
        if (res != null) {
            this.gather(resolver, entries, mapEntries, res, "");
        }
    }

    private void gather(ResourceResolver resolver, List<MapEntry> entries, Map<String, MapEntry> mapEntries, Resource parent, String parentPath) {
        Iterator children = parent.listChildren();
        while (children.hasNext()) {
            List<MapEntry> childMapEntries;
            String childPath;
            Resource child = (Resource)children.next();
            ValueMap vm = ResourceUtil.getValueMap((Resource)child);
            String name = (String)vm.get(PROP_REG_EXP, String.class);
            boolean trailingSlash = false;
            if (name == null) {
                name = child.getName().concat("/");
                trailingSlash = true;
            }
            if (!(childPath = parentPath.concat(name)).endsWith("$")) {
                String childParent = childPath;
                if (!trailingSlash) {
                    childParent = childParent.concat("/");
                }
                this.gather(resolver, entries, mapEntries, child, childParent);
            }
            MapEntry childResolveEntry = null;
            try {
                childResolveEntry = MapEntry.createResolveEntry(childPath, child, trailingSlash);
            }
            catch (IllegalArgumentException iae) {
                this.log.debug("ignored entry due exception ", (Throwable)iae);
            }
            if (childResolveEntry != null) {
                entries.add(childResolveEntry);
            }
            if ((childMapEntries = MapEntry.createMapEntry(childPath, child, trailingSlash)) == null) continue;
            for (MapEntry mapEntry : childMapEntries) {
                this.addMapEntry(mapEntries, mapEntry.getPattern(), mapEntry.getRedirect()[0], mapEntry.getStatus());
            }
        }
    }

    private void addEntry(Map<String, List<MapEntry>> entryMap, String key, MapEntry entry) {
        if (entry == null) {
            return;
        }
        List<MapEntry> entries = entryMap.get(key);
        if (entries == null) {
            entries = new ArrayList<MapEntry>();
            entryMap.put(key, entries);
        }
        entries.add(entry);
        Collections.sort(entries);
    }

    private Map<String, Map<String, String>> loadAliases(ResourceResolver resolver) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        String queryString = "SELECT sling:alias FROM nt:base WHERE sling:alias IS NOT NULL";
        Iterator i = resolver.findResources("SELECT sling:alias FROM nt:base WHERE sling:alias IS NOT NULL", "sql");
        while (i.hasNext()) {
            String resourceName;
            String parentPath;
            Resource resource = (Resource)i.next();
            if (resource.getPath().startsWith(JCR_SYSTEM_PREFIX)) {
                this.log.debug("loadAliases: Ignoring {}", (Object)resource);
                continue;
            }
            ValueMap props = (ValueMap)resource.adaptTo(ValueMap.class);
            if (props == null) {
                this.log.debug("loadAliases: Ignoring {} without properties", (Object)resource);
                continue;
            }
            if (resource.getName().equals("jcr:content")) {
                Resource containingResource = resource.getParent();
                parentPath = containingResource.getParent().getPath();
                resourceName = containingResource.getName();
            } else {
                parentPath = resource.getParent().getPath();
                resourceName = resource.getName();
            }
            HashMap<String, String> parentMap = (HashMap<String, String>)map.get(parentPath);
            for (String alias : (String[])props.get("sling:alias", String[].class)) {
                boolean invalid;
                if (parentMap != null && parentMap.containsKey(alias)) {
                    this.log.warn("Encountered duplicate alias {} under parent path {}. Refusing to replace current target {} with {}.", new Object[]{alias, parentPath, parentMap.get(alias), resourceName});
                    continue;
                }
                boolean bl = invalid = alias.equals("..") || alias.equals(".");
                if (!invalid) {
                    for (char c : alias.toCharArray()) {
                        if (c != '/' && c != '#' && c != '?') continue;
                        invalid = true;
                        break;
                    }
                }
                if (invalid) {
                    this.log.warn("Encountered invalid alias {} under parent path {}. Refusing to use it.", (Object)alias, (Object)parentPath);
                    continue;
                }
                if (parentMap == null) {
                    parentMap = new HashMap<String, String>();
                    map.put(parentPath, parentMap);
                }
                parentMap.put(alias, resourceName);
            }
        }
        return map;
    }

    private Collection<String> loadVanityPaths(ResourceResolver resolver, Map<String, List<MapEntry>> entryMap) {
        HashSet<String> targetPaths = new HashSet<String>();
        String queryString = "SELECT sling:vanityPath, sling:redirect, sling:redirectStatus FROM sling:VanityPath WHERE sling:vanityPath IS NOT NULL ORDER BY sling:vanityOrder DESC";
        Iterator i = resolver.findResources("SELECT sling:vanityPath, sling:redirect, sling:redirectStatus FROM sling:VanityPath WHERE sling:vanityPath IS NOT NULL ORDER BY sling:vanityOrder DESC", "sql");
        HashSet<String> processedVanityPaths = new HashSet<String>();
        while (i.hasNext()) {
            String[] pVanityPaths;
            ValueMap props;
            Resource resource = (Resource)i.next();
            if (resource.getPath().startsWith(JCR_SYSTEM_PREFIX)) {
                this.log.debug("loadVanityPaths: Ignoring {}", (Object)resource);
                continue;
            }
            if (this.vanityPathConfig != null) {
                boolean allowed = false;
                for (MapConfigurationProvider.VanityPathConfig config : this.vanityPathConfig) {
                    if (!resource.getPath().startsWith(config.prefix)) continue;
                    allowed = !config.isExclude;
                    break;
                }
                if (!allowed) {
                    this.log.debug("loadVanityPaths: Ignoring as not in white list {}", (Object)resource);
                    continue;
                }
            }
            if ((props = (ValueMap)resource.adaptTo(ValueMap.class)) == null) {
                this.log.debug("loadVanityPaths: Ignoring {} without properties", (Object)resource);
                continue;
            }
            for (String pVanityPath : pVanityPaths = (String[])props.get("sling:vanityPath", (Object)new String[0])) {
                String url;
                String[] result = this.getVanityPathDefinition(pVanityPath);
                if (result == null || processedVanityPaths.contains(url = result[0] + result[1])) continue;
                processedVanityPaths.add(url);
                Resource redirectTarget = resource.getName().equals("jcr:content") ? resource.getParent() : resource;
                String redirect = redirectTarget.getPath();
                String redirectName = redirectTarget.getName();
                int status = (Boolean)props.get(PROP_REDIRECT_EXTERNAL, (Object)false) != false ? (Integer)props.get(PROP_REDIRECT_EXTERNAL_REDIRECT_STATUS, (Object)this.factory.getDefaultVanityPathRedirectStatus()) : -1;
                String checkPath = result[1];
                if (redirectName.indexOf(46) > -1) {
                    this.addEntry(entryMap, checkPath, this.getMapEntry(url + "$", status, false, redirect));
                    int idx = redirectName.lastIndexOf(46);
                    String extension = redirectName.substring(idx + 1);
                    this.addEntry(entryMap, checkPath, this.getMapEntry(url + "\\." + extension, status, false, redirect));
                } else {
                    this.addEntry(entryMap, checkPath, this.getMapEntry(url + "$", status, false, redirect + ".html"));
                    this.addEntry(entryMap, checkPath, this.getMapEntry(url + "(\\..*)", status, false, redirect + "$1"));
                }
                targetPaths.add(redirect);
            }
        }
        return targetPaths;
    }

    private String[] getVanityPathDefinition(String pVanityPath) {
        String info;
        String[] result = null;
        if (pVanityPath != null && (info = pVanityPath.trim()).length() > 0) {
            String prefix = null;
            String path = null;
            if (info.indexOf(":/") > -1) {
                try {
                    URL u = new URL(info);
                    prefix = u.getProtocol() + '/' + u.getHost() + '.' + u.getPort();
                    path = u.getPath();
                }
                catch (MalformedURLException e) {
                    this.log.warn("Ignoring malformed vanity path {}", (Object)pVanityPath);
                }
            } else {
                prefix = "^[^/]+/[^/]+";
                path = !info.startsWith("/") ? "/" + info : info;
            }
            if (prefix != null) {
                int lastSlash = path.lastIndexOf(47);
                int firstDot = path.indexOf(46, lastSlash + 1);
                if (firstDot != -1) {
                    path = path.substring(0, firstDot);
                    this.log.warn("Removing extension from vanity path {}", (Object)pVanityPath);
                }
                result = new String[]{prefix, path};
            }
        }
        return result;
    }

    private void loadConfiguration(MapConfigurationProvider factory, List<MapEntry> entries) {
        Mapping[] mappings;
        Map<?, ?> virtuals = factory.getVirtualURLMap();
        if (virtuals != null) {
            for (Map.Entry<?, ?> virtualEntry : virtuals.entrySet()) {
                String intPath;
                String extPath = (String)virtualEntry.getKey();
                if (extPath.equals(intPath = (String)virtualEntry.getValue())) continue;
                String url = "^[^/]+/[^/]+" + extPath + "$";
                String redirect = intPath;
                MapEntry mapEntry = this.getMapEntry(url, -1, false, redirect);
                if (mapEntry == null) continue;
                entries.add(mapEntry);
            }
        }
        if ((mappings = factory.getMappings()) != null) {
            HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
            for (Mapping mapping : mappings) {
                if (!mapping.mapsInbound()) continue;
                String url = mapping.getTo();
                String alias = mapping.getFrom();
                if (url.length() <= 0) continue;
                ArrayList<String> aliasList = (ArrayList<String>)map.get(url);
                if (aliasList == null) {
                    aliasList = new ArrayList<String>();
                    map.put(url, aliasList);
                }
                aliasList.add(alias);
            }
            for (Map.Entry entry : map.entrySet()) {
                MapEntry mapEntry = this.getMapEntry(ANY_SCHEME_HOST + (String)entry.getKey(), -1, false, ((List)entry.getValue()).toArray(new String[0]));
                if (mapEntry == null) continue;
                entries.add(mapEntry);
            }
        }
    }

    private void loadMapConfiguration(MapConfigurationProvider factory, Map<String, MapEntry> entries) {
        Map<?, ?> virtuals;
        Mapping[] mappings = factory.getMappings();
        if (mappings != null) {
            for (int i = mappings.length - 1; i >= 0; --i) {
                String alias;
                String url;
                Mapping mapping = mappings[i];
                if (!mapping.mapsOutbound() || (url = mapping.getTo()).equals(alias = mapping.getFrom())) continue;
                this.addMapEntry(entries, alias, url, -1);
            }
        }
        if ((virtuals = factory.getVirtualURLMap()) != null) {
            for (Map.Entry<?, ?> virtualEntry : virtuals.entrySet()) {
                String intPath;
                String extPath = (String)virtualEntry.getKey();
                if (extPath.equals(intPath = (String)virtualEntry.getValue())) continue;
                String path = "^" + intPath + "$";
                String url = extPath;
                this.addMapEntry(entries, path, url, -1);
            }
        }
    }

    private void addMapEntry(Map<String, MapEntry> entries, String path, String url, int status) {
        MapEntry entry = entries.get(path);
        if (entry == null) {
            entry = this.getMapEntry(path, status, false, url);
        } else {
            String[] redir = entry.getRedirect();
            String[] newRedir = new String[redir.length + 1];
            System.arraycopy(redir, 0, newRedir, 0, redir.length);
            newRedir[redir.length] = url;
            entry = this.getMapEntry(entry.getPattern(), entry.getStatus(), false, newRedir);
        }
        if (entry != null) {
            entries.put(path, entry);
        }
    }

    private static String createFilter(boolean vanityPathEnabled) {
        String[] nodeProps = new String[]{PROP_REDIRECT_EXTERNAL_REDIRECT_STATUS, PROP_REDIRECT_EXTERNAL, "sling:internalRedirect", PROP_REDIRECT_EXTERNAL_STATUS, PROP_REG_EXP, "sling:alias"};
        String[] eventProps = new String[]{"resourceAddedAttributes", "resourceChangedAttributes", "resourceRemovedAttributes"};
        StringBuilder filter = new StringBuilder();
        filter.append("(|");
        for (String eventProp : eventProps) {
            filter.append("(|");
            if (vanityPathEnabled) {
                filter.append('(').append(eventProp).append('=').append("sling:vanityPath").append(')');
                filter.append('(').append(eventProp).append('=').append("sling:vanityOrder").append(')');
            }
            for (String nodeProp : nodeProps) {
                filter.append('(').append(eventProp).append('=').append(nodeProp).append(')');
            }
            filter.append(")");
        }
        filter.append("(").append("event.topics").append("=").append("org/apache/sling/api/resource/Resource/REMOVED").append(")");
        filter.append(")");
        return filter.toString();
    }

    private MapEntry getMapEntry(String url, int status, boolean trailingSlash, String ... redirect) {
        MapEntry mapEntry = null;
        try {
            mapEntry = new MapEntry(url, status, trailingSlash, redirect);
        }
        catch (IllegalArgumentException iae) {
            this.log.debug("ignored entry due exception ", (Throwable)iae);
        }
        return mapEntry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapEntryIterator
    implements Iterator<MapEntry> {
        private final Map<String, List<MapEntry>> resolveMapsMap;
        private String key;
        private MapEntry next;
        private final Iterator<MapEntry> globalListIterator;
        private MapEntry nextGlobal;
        private Iterator<MapEntry> specialIterator;
        private MapEntry nextSpecial;

        public MapEntryIterator(String startKey, Map<String, List<MapEntry>> resolveMapsMap) {
            this.key = startKey;
            this.resolveMapsMap = resolveMapsMap;
            this.globalListIterator = this.resolveMapsMap.get(MapEntries.GLOBAL_LIST_KEY).iterator();
            this.seek();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public MapEntry next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            MapEntry result = this.next;
            this.seek();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void seek() {
            if (this.nextGlobal == null && this.globalListIterator.hasNext()) {
                this.nextGlobal = this.globalListIterator.next();
            }
            if (this.nextSpecial == null) {
                if (this.specialIterator != null && !this.specialIterator.hasNext()) {
                    this.specialIterator = null;
                }
                while (this.specialIterator == null && this.key != null) {
                    List<MapEntry> special;
                    int lastSlashPos = this.key.lastIndexOf(47);
                    int lastDotPos = this.key.indexOf(46, lastSlashPos);
                    if (lastDotPos != -1) {
                        this.key = this.key.substring(0, lastDotPos);
                    }
                    if ((special = this.resolveMapsMap.get(this.key)) != null) {
                        this.specialIterator = special.iterator();
                    }
                    if (this.key.length() > 1) {
                        int lastSlash = this.key.lastIndexOf("/");
                        if (lastSlash == 0) {
                            this.key = null;
                            continue;
                        }
                        this.key = this.key.substring(0, lastSlash);
                        continue;
                    }
                    this.key = null;
                }
                if (this.specialIterator != null && this.specialIterator.hasNext()) {
                    this.nextSpecial = this.specialIterator.next();
                }
            }
            if (this.nextSpecial == null) {
                this.next = this.nextGlobal;
                this.nextGlobal = null;
            } else if (this.nextGlobal == null) {
                this.next = this.nextSpecial;
                this.nextSpecial = null;
            } else if (this.nextGlobal.getPattern().length() >= this.nextSpecial.getPattern().length()) {
                this.next = this.nextGlobal;
                this.nextGlobal = null;
            } else {
                this.next = this.nextSpecial;
                this.nextSpecial = null;
            }
        }
    }
}

