/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;
import org.apache.sling.resourceresolver.impl.tree.ProviderHandler;
import org.apache.sling.resourceresolver.impl.tree.ResourceProviderFactoryHandler;
import org.apache.sling.resourceresolver.impl.tree.ResourceProviderHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedProviderList<T> {
    private final Class<T> genericClass;
    private Entry[] sortedList = new Entry[0];

    public SortedProviderList(Class<T> genericClass) {
        this.genericClass = genericClass;
    }

    public Iterator<T> getProviders(final ResourceResolverContext ctx, final Filter<T> filter) {
        return new Iterator<T>(){
            private final Entry[] list;
            private int index;
            private Object nextObject;
            {
                this.list = SortedProviderList.this.sortedList;
                this.index = 0;
                this.nextObject = this.seek();
            }

            private Object seek() {
                Object result;
                if (this.index < this.list.length) {
                    Entry entry = this.list[this.index];
                    result = entry.object;
                    ++this.index;
                    if (result instanceof ResourceProviderFactoryHandler) {
                        result = ((ResourceProviderFactoryHandler)result).getResourceProvider(ctx);
                        if (!SortedProviderList.this.genericClass.isAssignableFrom(result.getClass())) {
                            result = null;
                        }
                    }
                    if (result != null && filter != null && !filter.select(entry.handler, result)) {
                        result = null;
                    }
                    if (result == null) {
                        result = this.seek();
                    }
                } else {
                    result = null;
                }
                return result;
            }

            @Override
            public boolean hasNext() {
                return this.nextObject != null;
            }

            @Override
            public T next() {
                if (this.nextObject == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.nextObject;
                this.nextObject = this.seek();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private synchronized void addToList(Object obj, ProviderHandler handler) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        list.addAll(Arrays.asList(this.sortedList));
        list.add(new Entry(obj, handler));
        Collections.sort(list);
        this.sortedList = list.toArray(new Entry[list.size()]);
    }

    private synchronized void removeFromList(Object obj) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        list.addAll(Arrays.asList(this.sortedList));
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            if (!entry.object.equals(obj)) continue;
            i.remove();
            break;
        }
        this.sortedList = list.toArray(new Entry[list.size()]);
    }

    public void add(ResourceProviderHandler rpHandler) {
        if (this.genericClass.isAssignableFrom(rpHandler.getResourceProvider().getClass())) {
            this.addToList(rpHandler.getResourceProvider(), rpHandler);
        }
    }

    public void add(ResourceProviderFactoryHandler factory) {
        this.addToList(factory, factory);
    }

    public void remove(ResourceProviderHandler rpHandler) {
        if (this.genericClass.isAssignableFrom(rpHandler.getResourceProvider().getClass())) {
            this.removeFromList(rpHandler.getResourceProvider());
        }
    }

    public void remove(ResourceProviderFactoryHandler factory) {
        this.removeFromList(factory);
    }

    public ProviderHandler getProviderHandler(ResourceResolverContext ctx, ResourceProvider resourceProvider) {
        ProviderHandler returnValue = null;
        ArrayList<Entry> list = new ArrayList<Entry>();
        list.addAll(Arrays.asList(this.sortedList));
        for (Entry entry : list) {
            if (!entry.handler.getResourceProvider(ctx).equals(resourceProvider)) continue;
            returnValue = entry.handler;
            break;
        }
        return returnValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry
    implements Comparable<Entry> {
        private final String path;
        public final ProviderHandler handler;
        public final Object object;

        public Entry(Object object, ProviderHandler handler) {
            this.object = object;
            this.path = handler.getRoots() != null ? handler.getRoots()[0] : "";
            this.handler = handler;
        }

        @Override
        public int compareTo(Entry other) {
            int result = this.path.compareTo(other.path);
            if (result == 0) {
                result = this.handler.getServiceId().compareTo(other.handler.getServiceId());
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Filter<T> {
        public boolean select(ProviderHandler var1, T var2);
    }
}

