/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adapter;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.resourceresolver.impl.CommonResourceResolverFactoryImpl;
import org.apache.sling.resourceresolver.impl.helper.RedirectResource;
import org.apache.sling.resourceresolver.impl.helper.ResourceIterator;
import org.apache.sling.resourceresolver.impl.helper.ResourceIteratorDecorator;
import org.apache.sling.resourceresolver.impl.helper.ResourcePathIterator;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;
import org.apache.sling.resourceresolver.impl.helper.StarResource;
import org.apache.sling.resourceresolver.impl.helper.URI;
import org.apache.sling.resourceresolver.impl.helper.URIException;
import org.apache.sling.resourceresolver.impl.mapping.MapEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Adaptable(adaptableClass=ResourceResolver.class, adapters={@Adapter(value={Session.class})})
public class ResourceResolverImpl
extends SlingAdaptable
implements ResourceResolver {
    private final Logger logger = LoggerFactory.getLogger(ResourceResolverImpl.class);
    private static final String MANGLE_NAMESPACE_IN_SUFFIX = "_";
    private static final String MANGLE_NAMESPACE_IN_PREFIX = "/_";
    private static final Pattern MANGLE_NAMESPACE_IN_PATTERN = Pattern.compile("/_([^_/]+)_");
    private static final String MANGLE_NAMESPACE_OUT_SUFFIX = ":";
    private static final String MANGLE_NAMESPACE_OUT_PREFIX = "/";
    private static final Pattern MANLE_NAMESPACE_OUT_PATTERN = Pattern.compile("/([^:/]+):");
    public static final String PROP_REDIRECT_INTERNAL = "sling:internalRedirect";
    public static final String PROP_ALIAS = "sling:alias";
    private static final String JCR_CONTENT_LEAF = "/jcr:content";
    private final CommonResourceResolverFactoryImpl factory;
    private volatile boolean closed = false;
    private final ResourceResolverContext context;
    private static final String DEFAULT_QUERY_LANGUAGE = "xpath";
    private Session cachedSession;
    private boolean searchedSession = false;

    public ResourceResolverImpl(CommonResourceResolverFactoryImpl factory, ResourceResolverContext ctx) {
        this.factory = factory;
        this.context = ctx;
    }

    public ResourceResolver clone(Map<String, Object> authenticationInfo) throws LoginException {
        this.checkClosed();
        HashMap<String, Object> newAuthenticationInfo = new HashMap<String, Object>();
        if (this.context.getAuthenticationInfo() != null) {
            newAuthenticationInfo.putAll(this.context.getAuthenticationInfo());
        }
        if (authenticationInfo != null) {
            newAuthenticationInfo.putAll(authenticationInfo);
        }
        ResourceResolverContext newContext = new ResourceResolverContext(this.context.isAdmin(), newAuthenticationInfo, this.factory.getResourceAccessSecurityTracker());
        this.factory.getRootProviderEntry().loginToRequiredFactories(newContext);
        return new ResourceResolverImpl(this.factory, newContext);
    }

    public boolean isLive() {
        return !this.closed && this.context.isLive();
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.context.close();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Resource resolver is already closed.");
        }
    }

    public Iterator<String> getAttributeNames() {
        this.checkClosed();
        return this.factory.getRootProviderEntry().getAttributeNames(this.context, this);
    }

    public Object getAttribute(String name) {
        this.checkClosed();
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.factory.getRootProviderEntry().getAttribute(this.context, this, name);
    }

    public Resource resolve(String absPath) {
        this.checkClosed();
        return this.resolve(null, absPath);
    }

    public Resource resolve(HttpServletRequest request) {
        this.checkClosed();
        return this.resolve(request, request.getPathInfo());
    }

    public Resource resolve(HttpServletRequest request, String absPath) {
        this.checkClosed();
        if (absPath == null) {
            absPath = MANGLE_NAMESPACE_OUT_PREFIX;
        } else if (!absPath.startsWith(MANGLE_NAMESPACE_OUT_PREFIX)) {
            absPath = MANGLE_NAMESPACE_OUT_PREFIX + absPath;
        }
        absPath = this.unmangleNamespaces(absPath);
        String[] realPathList = new String[]{absPath};
        String requestPath = request != null ? ResourceResolverImpl.getMapPath(request.getScheme(), request.getServerName(), request.getServerPort(), absPath) : ResourceResolverImpl.getMapPath("http", "localhost", 80, absPath);
        this.logger.debug("resolve: Resolving request path {}", (Object)requestPath);
        for (int i = 0; i < 100; ++i) {
            Object[] mappedPath = null;
            Iterator<MapEntry> mapEntriesIterator = this.factory.getMapEntries().getResolveMapsIterator(requestPath);
            while (mapEntriesIterator.hasNext()) {
                MapEntry mapEntry = mapEntriesIterator.next();
                mappedPath = mapEntry.replace(requestPath);
                if (mappedPath == null) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("resolve: MapEntry {} matches, mapped path is {}", (Object)mapEntry, (Object)Arrays.toString(mappedPath));
                }
                if (mapEntry.isInternal()) {
                    this.logger.debug("resolve: Redirecting internally");
                    break;
                }
                this.logger.debug("resolve: Returning external redirect");
                return this.factory.getResourceDecoratorTracker().decorate((Resource)new RedirectResource(this, absPath, (String)mappedPath[0], mapEntry.getStatus()));
            }
            if (mappedPath == null) {
                this.logger.debug("resolve: Request path {} does not match any MapEntry", (Object)requestPath);
                break;
            }
            if (!mappedPath[0].contains("://")) {
                this.logger.debug("resolve: Mapped path is for resource tree");
                realPathList = mappedPath;
                break;
            }
            try {
                URI uri = new URI(mappedPath[0], false);
                requestPath = ResourceResolverImpl.getMapPath(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath());
                realPathList = new String[]{uri.getPath()};
                this.logger.debug("resolve: Mapped path is an URL, using new request path {}", (Object)requestPath);
                continue;
            }
            catch (URIException use) {
                throw new ResourceNotFoundException(absPath);
            }
        }
        Object res = null;
        for (int i = 0; res == null && i < realPathList.length; ++i) {
            String realPath = realPathList[i];
            if (StarResource.appliesTo(realPath)) {
                this.logger.debug("resolve: Mapped path {} is a Star Resource", (Object)realPath);
                res = new StarResource(this, this.ensureAbsPath(realPath));
                continue;
            }
            if (realPath.startsWith(MANGLE_NAMESPACE_OUT_PREFIX)) {
                this.logger.debug("resolve: Try absolute mapped path {}", (Object)realPath);
                res = this.resolveInternal(realPath);
                continue;
            }
            String[] searchPath = this.getSearchPath();
            for (int spi = 0; res == null && spi < searchPath.length; ++spi) {
                this.logger.debug("resolve: Try relative mapped path with search path entry {}", (Object)searchPath[spi]);
                res = this.resolveInternal(searchPath[spi] + realPath);
            }
        }
        if (res == null) {
            String resourcePath = this.ensureAbsPath(realPathList[0]);
            this.logger.debug("resolve: Path {} does not resolve, returning NonExistingResource at {}", (Object)absPath, (Object)resourcePath);
            res = new NonExistingResource((ResourceResolver)this, resourcePath);
            int index = resourcePath.indexOf(46);
            if (index != -1) {
                res.getResourceMetadata().setResolutionPathInfo(resourcePath.substring(index));
            }
        } else {
            this.logger.debug("resolve: Path {} resolves to Resource {}", (Object)absPath, res);
        }
        return this.factory.getResourceDecoratorTracker().decorate((Resource)res);
    }

    public String map(String resourcePath) {
        this.checkClosed();
        return this.map(null, resourcePath);
    }

    public String map(HttpServletRequest request, String resourcePath) {
        String schemePrefix;
        String schemehostport;
        String mappedPath;
        String fragmentQuery;
        this.checkClosed();
        int fragmentQueryMark = resourcePath.indexOf(35);
        if (fragmentQueryMark < 0) {
            fragmentQueryMark = resourcePath.indexOf(63);
        }
        if (fragmentQueryMark >= 0) {
            fragmentQuery = resourcePath.substring(fragmentQueryMark);
            mappedPath = resourcePath.substring(0, fragmentQueryMark);
            this.logger.debug("map: Splitting resource path '{}' into '{}' and '{}'", new Object[]{resourcePath, mappedPath, fragmentQuery});
        } else {
            fragmentQuery = null;
            mappedPath = resourcePath;
        }
        if (request != null) {
            schemehostport = MapEntry.getURI(request.getScheme(), request.getServerName(), request.getServerPort(), MANGLE_NAMESPACE_OUT_PREFIX);
            schemePrefix = request.getScheme().concat("://");
            this.logger.debug("map: Mapping path {} for {} (at least with scheme prefix {})", new Object[]{resourcePath, schemehostport, schemePrefix});
        } else {
            schemehostport = null;
            schemePrefix = null;
            this.logger.debug("map: Mapping path {} for default", (Object)resourcePath);
        }
        Resource res = this.resolveInternal(mappedPath);
        if (res != null) {
            String resolutionPathInfo = res.getResourceMetadata().getResolutionPathInfo();
            this.logger.debug("map: Path maps to resource {} with path info {}", (Object)res, (Object)resolutionPathInfo);
            LinkedList<String> names = new LinkedList<String>();
            Resource current = res;
            String path = res.getPath();
            while (path != null) {
                String alias = null;
                if (current != null && !path.endsWith(JCR_CONTENT_LEAF)) {
                    alias = ResourceResolverContext.getProperty(current, PROP_ALIAS);
                }
                if (alias == null || alias.length() == 0) {
                    alias = ResourceUtil.getName((String)path);
                }
                names.add(alias);
                path = ResourceUtil.getParent((String)path);
                if (MANGLE_NAMESPACE_OUT_PREFIX.equals(path)) {
                    path = null;
                    continue;
                }
                if (path == null) continue;
                current = res.getResourceResolver().resolve(path);
            }
            StringBuilder buf = new StringBuilder();
            if (names.isEmpty()) {
                buf.append('/');
            } else {
                while (!names.isEmpty()) {
                    buf.append('/');
                    buf.append((String)names.removeLast());
                }
            }
            if (resolutionPathInfo != null) {
                buf.append(resolutionPathInfo);
            }
            mappedPath = buf.toString();
            this.logger.debug("map: Alias mapping resolves to path {}", (Object)mappedPath);
        }
        boolean mappedPathIsUrl = false;
        for (MapEntry mapEntry : this.factory.getMapEntries().getMapMaps()) {
            String[] mappedPaths = mapEntry.replace(mappedPath);
            if (mappedPaths == null) continue;
            this.logger.debug("map: Match for Entry {}", (Object)mapEntry);
            boolean bl = mappedPathIsUrl = !mapEntry.isInternal();
            if (mappedPathIsUrl && schemehostport != null) {
                mappedPath = null;
                for (String candidate : mappedPaths) {
                    if (candidate.startsWith(schemehostport)) {
                        mappedPath = candidate.substring(schemehostport.length() - 1);
                        mappedPathIsUrl = false;
                        this.logger.debug("map: Found host specific mapping {} resolving to {}", (Object)candidate, (Object)mappedPath);
                        break;
                    }
                    if (!candidate.startsWith(schemePrefix) || mappedPath != null) continue;
                    mappedPath = candidate;
                }
                if (mappedPath == null) {
                    mappedPath = mappedPaths[0];
                }
            } else {
                mappedPath = mappedPaths[0];
            }
            this.logger.debug("resolve: MapEntry {} matches, mapped path is {}", (Object)mapEntry, (Object)mappedPath);
            break;
        }
        if (mappedPath == null) {
            mappedPath = resourcePath;
        }
        try {
            URI uri = new URI(mappedPath, false);
            String path = this.mangleNamespaces(uri.getPath());
            if (request != null && request.getContextPath() != null && request.getContextPath().length() > 0) {
                path = request.getContextPath().concat(path);
            }
            uri.setPath(path);
            mappedPath = uri.toString();
        }
        catch (URIException e) {
            this.logger.warn("map: Unable to mangle namespaces for " + mappedPath + " returning unmangled", (Throwable)((Object)e));
        }
        this.logger.debug("map: Returning URL {} as mapping for path {}", (Object)mappedPath, (Object)resourcePath);
        if (fragmentQuery != null) {
            mappedPath = mappedPath.concat(fragmentQuery);
        }
        return mappedPath;
    }

    public String[] getSearchPath() {
        this.checkClosed();
        return (String[])this.factory.getSearchPath().clone();
    }

    public Resource getResource(String path) {
        this.checkClosed();
        Resource result = null;
        if (path != null) {
            if (path.startsWith(MANGLE_NAMESPACE_OUT_PREFIX)) {
                Resource resource = result = (path = ResourceUtil.normalize((String)path)) != null ? this.getResourceInternal(path, false) : null;
                if (result != null) {
                    result = this.factory.getResourceDecoratorTracker().decorate(result);
                }
            } else {
                String[] paths = this.factory.getSearchPath();
                if (paths != null) {
                    String prefix;
                    String[] arr$ = this.factory.getSearchPath();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (result = this.getResource((prefix = arr$[i$]) + path)) == null; ++i$) {
                    }
                }
            }
        }
        return result;
    }

    public Resource getResource(Resource base, String path) {
        this.checkClosed();
        if (path != null && !path.startsWith(MANGLE_NAMESPACE_OUT_PREFIX) && base != null) {
            path = base.getPath() + MANGLE_NAMESPACE_OUT_PREFIX + path;
        }
        return this.getResource(path);
    }

    public Iterator<Resource> listChildren(Resource parent) {
        this.checkClosed();
        if (parent instanceof ResourceWrapper) {
            return this.listChildren(((ResourceWrapper)parent).getResource());
        }
        return new ResourceIteratorDecorator(this.factory.getResourceDecoratorTracker(), new ResourceIterator(this.context, parent, this.factory.getRootProviderEntry()));
    }

    public Iterable<Resource> getChildren(final Resource parent) {
        return new Iterable<Resource>(){

            @Override
            public Iterator<Resource> iterator() {
                return ResourceResolverImpl.this.listChildren(parent);
            }
        };
    }

    public Iterator<Resource> findResources(String query, String language) throws SlingException {
        this.checkClosed();
        return new ResourceIteratorDecorator(this.factory.getResourceDecoratorTracker(), this.factory.getRootProviderEntry().findResources(this.context, this, query, language == null ? DEFAULT_QUERY_LANGUAGE : language));
    }

    public Iterator<Map<String, Object>> queryResources(String query, String language) throws SlingException {
        this.checkClosed();
        return this.factory.getRootProviderEntry().queryResources(this.context, this, query, language == null ? DEFAULT_QUERY_LANGUAGE : language);
    }

    public String getUserID() {
        Session session;
        this.checkClosed();
        if (this.context.getAuthenticationInfo() != null) {
            Object impUser = this.context.getAuthenticationInfo().get("user.impersonation");
            if (impUser != null) {
                return impUser.toString();
            }
            Object user = this.context.getAuthenticationInfo().get("user.name");
            if (user != null) {
                return user.toString();
            }
        }
        if ((session = this.getSession()) != null) {
            return session.getUserID();
        }
        Object impUser = this.getAttribute("user.impersonation");
        if (impUser != null) {
            return impUser.toString();
        }
        Object user = this.getAttribute("user.name");
        if (user != null) {
            return user.toString();
        }
        return null;
    }

    private Session getSession() {
        if (!this.searchedSession) {
            this.searchedSession = true;
            this.cachedSession = this.factory.getRootProviderEntry().adaptTo(this.context, Session.class);
        }
        return this.cachedSession;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        this.checkClosed();
        if (type == Session.class) {
            return (AdapterType)this.getSession();
        }
        AdapterType result = this.factory.getRootProviderEntry().adaptTo(this.context, type);
        if (result != null) {
            return result;
        }
        return (AdapterType)super.adaptTo(type);
    }

    private static String getMapPath(String scheme, String host, int port, String path) {
        if (port < 0) {
            port = "https".equals(scheme) ? 443 : 80;
        }
        return scheme + MANGLE_NAMESPACE_OUT_PREFIX + host + "." + port + path;
    }

    private Resource resolveInternal(String absPath) {
        Resource resource = null;
        String curPath = absPath;
        try {
            ResourcePathIterator it = new ResourcePathIterator(absPath);
            while (it.hasNext() && resource == null) {
                curPath = it.next();
                resource = this.getResourceInternal(curPath, true);
            }
        }
        catch (Exception ex) {
            throw new SlingException("Problem trying " + curPath + " for request path " + absPath, (Throwable)ex);
        }
        if (resource != null) {
            String rpi = absPath.substring(curPath.length());
            resource.getResourceMetadata().setResolutionPathInfo(rpi);
            this.logger.debug("resolveInternal: Found resource {} with path info {} for {}", new Object[]{resource, rpi, absPath});
        } else {
            resource = this.getResourceInternal(MANGLE_NAMESPACE_OUT_PREFIX, true);
            StringBuilder resolutionPath = new StringBuilder();
            StringTokenizer tokener = new StringTokenizer(absPath, MANGLE_NAMESPACE_OUT_PREFIX);
            while (resource != null && tokener.hasMoreTokens()) {
                String childNameRaw = tokener.nextToken();
                Resource nextResource = this.getChildInternal(resource, childNameRaw);
                if (nextResource != null) {
                    resource = nextResource;
                    resolutionPath.append(MANGLE_NAMESPACE_OUT_PREFIX).append(childNameRaw);
                    continue;
                }
                String childName = null;
                ResourcePathIterator rpi = new ResourcePathIterator(childNameRaw);
                while (rpi.hasNext() && nextResource == null) {
                    childName = rpi.next();
                    nextResource = this.getChildInternal(resource, childName);
                }
                resource = nextResource;
                resolutionPath.append(MANGLE_NAMESPACE_OUT_PREFIX).append(childName);
                if (nextResource == null) continue;
                break;
            }
            if (resource != null) {
                String path = resolutionPath.toString();
                String pathInfo = absPath.substring(path.length());
                resource.getResourceMetadata().setResolutionPath(path);
                resource.getResourceMetadata().setResolutionPathInfo(pathInfo);
                this.logger.debug("resolveInternal: Found resource {} with path info {} for {}", new Object[]{resource, pathInfo, absPath});
            }
        }
        return resource;
    }

    private Resource getChildInternal(Resource parent, String childName) {
        String path = childName.startsWith(MANGLE_NAMESPACE_OUT_PREFIX) ? childName : parent.getPath() + '/' + childName;
        Resource child = this.getResourceInternal(ResourceUtil.normalize((String)path), true);
        if (child != null) {
            String alias = ResourceResolverContext.getProperty(child, PROP_REDIRECT_INTERNAL);
            if (alias != null) {
                this.logger.warn("getChildInternal: Internal redirect to {} for Resource {} is not supported yet, ignoring", (Object)alias, (Object)child);
            }
            return child;
        }
        if (this.factory.getMapEntries().isOptimizeAliasResolutionEnabled()) {
            String aliasName;
            this.logger.debug("getChildInternal: Optimize Alias Resolution is Enabled");
            Map<String, String> aliases = this.factory.getMapEntries().getAliasMap(parent.getPath());
            if (aliases != null && (aliasName = aliases.get(childName)) != null) {
                String aliasPath = aliasName.startsWith(MANGLE_NAMESPACE_OUT_PREFIX) ? aliasName : parent.getPath() + '/' + aliasName;
                Resource aliasedChild = this.getResourceInternal(ResourceUtil.normalize((String)aliasPath), true);
                this.logger.debug("getChildInternal: Found Resource {} with alias {} to use", (Object)aliasedChild, (Object)childName);
                return aliasedChild;
            }
        } else {
            this.logger.debug("getChildInternal: Optimize Alias Resolution is Disabled");
            Iterator<Resource> children = this.listChildren(parent);
            while (children.hasNext()) {
                String[] aliases;
                child = children.next();
                if (child.getPath().endsWith(JCR_CONTENT_LEAF) || (aliases = ResourceResolverContext.getProperty(child, PROP_ALIAS, String[].class)) == null) continue;
                for (String alias : aliases) {
                    if (!childName.equals(alias)) continue;
                    this.logger.debug("getChildInternal: Found Resource {} with alias {} to use", (Object)child, (Object)childName);
                    Resource aliasedChild = this.getResourceInternal(ResourceUtil.normalize((String)child.getPath()), true);
                    return aliasedChild;
                }
            }
        }
        this.logger.debug("getChildInternal: Resource {} has no child {}", (Object)parent, (Object)childName);
        return null;
    }

    private Resource getResourceInternal(String path, boolean isResolve) {
        Resource resource = this.factory.getRootProviderEntry().getResource(this.context, this, path, isResolve);
        if (resource != null) {
            resource.getResourceMetadata().setResolutionPath(path);
            return resource;
        }
        this.logger.debug("getResourceInternal: Cannot resolve path '{}' to a resource", (Object)path);
        return null;
    }

    private String ensureAbsPath(String path) {
        if (!path.startsWith(MANGLE_NAMESPACE_OUT_PREFIX)) {
            path = this.getSearchPath()[0] + path;
        }
        return path;
    }

    private String mangleNamespaces(String absPath) {
        if (this.factory.isMangleNamespacePrefixes() && absPath != null && absPath.contains(MANGLE_NAMESPACE_OUT_SUFFIX)) {
            Matcher m = MANLE_NAMESPACE_OUT_PATTERN.matcher(absPath);
            StringBuffer buf = new StringBuffer();
            while (m.find()) {
                String replacement = MANGLE_NAMESPACE_IN_PREFIX + m.group(1) + MANGLE_NAMESPACE_IN_SUFFIX;
                m.appendReplacement(buf, replacement);
            }
            m.appendTail(buf);
            absPath = buf.toString();
        }
        return absPath;
    }

    private String unmangleNamespaces(String absPath) {
        if (this.factory.isMangleNamespacePrefixes() && absPath.contains(MANGLE_NAMESPACE_IN_PREFIX)) {
            Matcher m = MANGLE_NAMESPACE_IN_PATTERN.matcher(absPath);
            StringBuffer buf = new StringBuffer();
            while (m.find()) {
                String namespace = m.group(1);
                try {
                    Session session = this.getSession();
                    if (session != null) {
                        session.getNamespaceURI(namespace);
                        String replacement = MANGLE_NAMESPACE_OUT_PREFIX + namespace + MANGLE_NAMESPACE_OUT_SUFFIX;
                        m.appendReplacement(buf, replacement);
                        continue;
                    }
                    this.logger.debug("unmangleNamespaces: '{}' is not a prefix, not unmangling", (Object)namespace);
                }
                catch (NamespaceException ne) {
                    this.logger.debug("unmangleNamespaces: '{}' is not a prefix, not unmangling", (Object)namespace);
                }
                catch (RepositoryException re) {
                    this.logger.warn("unmangleNamespaces: Problem checking namespace '{}'", (Object)namespace, (Object)re);
                }
            }
            m.appendTail(buf);
            absPath = buf.toString();
        }
        return absPath;
    }

    public void delete(Resource resource) throws PersistenceException {
        if (ResourceUtil.isNonExistingResource((Resource)resource)) {
            return;
        }
        this.factory.getRootProviderEntry().delete(this.context, this, resource);
    }

    public Resource create(Resource parent, String name, Map<String, Object> properties) throws PersistenceException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.indexOf(MANGLE_NAMESPACE_OUT_PREFIX) != -1) {
            throw new IllegalArgumentException("Name should not contain a slash: " + name);
        }
        String path = parent.getPath().equals(MANGLE_NAMESPACE_OUT_PREFIX) ? parent.getPath() + name : parent.getPath() + MANGLE_NAMESPACE_OUT_PREFIX + name;
        if (ResourceUtil.isSyntheticResource((Resource)parent)) {
            this.create(parent.getParent(), parent.getName(), null);
        }
        Resource rsrc = this.factory.getRootProviderEntry().create(this.context, this, path, properties);
        return this.factory.getResourceDecoratorTracker().decorate(rsrc);
    }

    public void revert() {
        this.context.revert(this);
    }

    public void commit() throws PersistenceException {
        this.context.commit(this);
    }

    public boolean hasChanges() {
        return this.context.hasChanges(this);
    }

    public boolean hasChildren(Resource resource) {
        return this.listChildren(resource).hasNext();
    }

    public String getParentResourceType(Resource resource) {
        String resourceSuperType = null;
        if (resource != null && (resourceSuperType = resource.getResourceSuperType()) == null) {
            resourceSuperType = this.getParentResourceType(resource.getResourceType());
        }
        return resourceSuperType;
    }

    public String getParentResourceType(String resourceType) {
        return this.context.getParentResourceType(this.factory, this, resourceType);
    }

    public boolean isResourceType(Resource resource, String resourceType) {
        boolean result = false;
        if (resource != null && resourceType != null) {
            if (resourceType.equals(resource.getResourceType())) {
                result = true;
            } else {
                String superType = this.getParentResourceType(resource);
                while (!result && superType != null) {
                    if (resourceType.equals(superType)) {
                        result = true;
                        continue;
                    }
                    superType = this.getParentResourceType(superType);
                }
            }
        }
        return result;
    }

    public void refresh() {
        this.context.refresh();
    }
}

