/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.security.ResourceAccessSecurity;

@Component
@Service(value={ResourceAccessSecurityTracker.class})
public class ResourceAccessSecurityTracker {
    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, target="(access.context=application)")
    private ResourceAccessSecurity applicationResourceAccessSecurity;
    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, target="(access.context=provider)")
    private ResourceAccessSecurity providerResourceAccessSecurity;

    public ResourceAccessSecurity getApplicationResourceAccessSecurity() {
        return this.applicationResourceAccessSecurity;
    }

    public ResourceAccessSecurity getProviderResourceAccessSecurity() {
        return this.providerResourceAccessSecurity;
    }

    protected void bindApplicationResourceAccessSecurity(ResourceAccessSecurity resourceAccessSecurity) {
        this.applicationResourceAccessSecurity = resourceAccessSecurity;
    }

    protected void unbindApplicationResourceAccessSecurity(ResourceAccessSecurity resourceAccessSecurity) {
        if (this.applicationResourceAccessSecurity == resourceAccessSecurity) {
            this.applicationResourceAccessSecurity = null;
        }
    }

    protected void bindProviderResourceAccessSecurity(ResourceAccessSecurity resourceAccessSecurity) {
        this.providerResourceAccessSecurity = resourceAccessSecurity;
    }

    protected void unbindProviderResourceAccessSecurity(ResourceAccessSecurity resourceAccessSecurity) {
        if (this.providerResourceAccessSecurity == resourceAccessSecurity) {
            this.providerResourceAccessSecurity = null;
        }
    }
}

