/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.cm.json.Configurations;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.apache.sling.feature.cpconverter.handlers.AbstractConfigurationEntryHandler;
import org.apache.sling.feature.cpconverter.shared.AbstractJcrNodeParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public final class XmlConfigurationEntryHandler
extends AbstractConfigurationEntryHandler {
    public XmlConfigurationEntryHandler() {
        super("xml");
    }

    @Override
    @Nullable
    protected Dictionary<String, Object> parseConfiguration(@NotNull String name, @NotNull InputStream input) {
        JcrConfigurationHandler configurationHandler = new JcrConfigurationHandler();
        try {
            return (Dictionary)configurationHandler.parse(input);
        }
        catch (Exception e) {
            this.logger.warn("Current OSGi configuration does not represent a valid XML document, see nested exceptions", (Throwable)e);
            return null;
        }
    }

    protected static final class JcrConfigurationHandler
    extends AbstractJcrNodeParser<Dictionary<String, Object>> {
        private static final String SLING_OSGICONFIG = "sling:OsgiConfig";
        private Dictionary<String, Object> configuration;

        public JcrConfigurationHandler() {
            super(SLING_OSGICONFIG);
        }

        @Override
        protected void onJcrRootElement(String uri, String localName, String qName, Attributes attributes) {
            this.configuration = Configurations.newConfiguration();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeValue;
                String attributeQName = attributes.getQName(i);
                if (attributeQName.indexOf(58) != -1 || (attributeValue = attributes.getValue(i)) == null || attributeValue.isEmpty()) continue;
                DocViewProperty property = DocViewProperty.parse((String)attributeQName, (String)attributeValue);
                Object value = property.values;
                List<String> strValues = Arrays.asList(property.values);
                switch (property.type) {
                    case 5: {
                        value = strValues.stream().map(s -> {
                            Calendar cal;
                            Long res = null;
                            if (s != null && (cal = ISO8601.parse((String)s)) != null) {
                                res = cal.getTimeInMillis();
                            }
                            return res;
                        }).toArray();
                        break;
                    }
                    case 4: {
                        value = strValues.stream().map(s -> {
                            Double res = null;
                            if (!s.isEmpty()) {
                                res = Double.parseDouble(s);
                            }
                            return res;
                        }).toArray();
                        break;
                    }
                    case 3: {
                        value = strValues.stream().map(s -> {
                            Long res = null;
                            if (!s.isEmpty()) {
                                res = Long.parseLong(s);
                            }
                            return res;
                        }).toArray();
                        break;
                    }
                    case 6: {
                        value = strValues.stream().map(s -> {
                            Boolean res = null;
                            if (s != null) {
                                res = Boolean.valueOf(s);
                            }
                            return res;
                        }).toArray();
                    }
                }
                if (!property.isMulti) {
                    value = ((Object[])value)[0];
                }
                if (property.values.length <= 0) continue;
                this.configuration.put(attributeQName, value);
            }
        }

        @Override
        protected Dictionary<String, Object> getParsingResult() {
            return this.configuration;
        }
    }
}

