/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.postgresql;

import com.google.gson.JsonObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.NodeType;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql.MySQLTableInstaller;

public class PostgreSQLTableInstaller
extends MySQLTableInstaller {
    public PostgreSQLTableInstaller(Client client, ModuleManager moduleManager, int maxSizeOfArrayColumn, int numOfSearchableValuesPerTag) {
        super(client, moduleManager, maxSizeOfArrayColumn, numOfSearchableValuesPerTag);
    }

    @Override
    protected String transform(ModelColumn column, Class<?> type, Type genericType) {
        String storageName = column.getColumnName().getStorageName();
        if (Integer.class.equals(type) || Integer.TYPE.equals(type) || NodeType.class.equals(type)) {
            return storageName + " INT";
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return storageName + " BIGINT";
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return storageName + " DOUBLE PRECISION";
        }
        if (String.class.equals(type)) {
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        if (StorageDataComplexObject.class.isAssignableFrom(type)) {
            return storageName + " VARCHAR(20000)";
        }
        if (byte[].class.equals(type)) {
            return storageName + " TEXT";
        }
        if (JsonObject.class.equals(type)) {
            if (column.getLength() > 16383) {
                return storageName + " TEXT";
            }
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        if (List.class.isAssignableFrom(type)) {
            Type elementType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            String oneColumnType = this.transform(column, (Class)elementType, elementType);
            oneColumnType = oneColumnType.substring(storageName.length());
            StringBuilder columns = new StringBuilder();
            for (int i = 0; i < this.maxSizeOfArrayColumn; ++i) {
                columns.append(storageName).append("_").append(i).append(oneColumnType).append(i == this.maxSizeOfArrayColumn - 1 ? "" : ",");
            }
            return columns.toString();
        }
        throw new IllegalArgumentException("Unsupported data type: " + type.getName());
    }

    @Override
    protected String getColumn(ModelColumn column) {
        String storageName = column.getColumnName().getStorageName();
        Class type = column.getType();
        if (StorageDataComplexObject.class.isAssignableFrom(type)) {
            return storageName + " TEXT";
        }
        if (String.class.equals((Object)type)) {
            if (column.getLength() > 16383) {
                return storageName + " TEXT";
            }
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        if (JsonObject.class.equals((Object)type)) {
            if (column.getLength() > 16383) {
                return storageName + " TEXT";
            }
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        return super.getColumn(column);
    }
}

