/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.postgresql;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilderFactory;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.StorageModule;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2BatchDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2EventQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2HistoryDeleteDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2MetadataQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2NetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2StorageDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TopologyQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2UITemplateManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.postgresql.PostgreSQLStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.postgresql.PostgreSQLTableInstaller;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.postgresql.dao.PostgreSQLAggregationQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.postgresql.dao.PostgreSQLAlarmQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.postgresql.dao.PostgreSQLBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.postgresql.dao.PostgreSQLLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.postgresql.dao.PostgreSQLMetricsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.postgresql.dao.PostgreSQLTraceQueryDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLStorageProvider
extends ModuleProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgreSQLStorageProvider.class);
    private PostgreSQLStorageConfig config = new PostgreSQLStorageConfig();
    private JDBCHikariCPClient postgresqlClient;

    public String name() {
        return "postgresql";
    }

    public Class<? extends ModuleDefine> module() {
        return StorageModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException {
        this.registerServiceImplementation(StorageBuilderFactory.class, (Service)new StorageBuilderFactory.Default());
        this.postgresqlClient = new JDBCHikariCPClient(this.config.getProperties());
        this.registerServiceImplementation(IBatchDAO.class, (Service)new H2BatchDAO(this.postgresqlClient));
        this.registerServiceImplementation(StorageDAO.class, (Service)new H2StorageDAO(this.getManager(), this.postgresqlClient, this.config.getMaxSizeOfArrayColumn(), this.config.getNumOfSearchableValuesPerTag()));
        this.registerServiceImplementation(INetworkAddressAliasDAO.class, (Service)new H2NetworkAddressAliasDAO(this.postgresqlClient));
        this.registerServiceImplementation(ITopologyQueryDAO.class, (Service)new H2TopologyQueryDAO(this.postgresqlClient));
        this.registerServiceImplementation(IMetricsQueryDAO.class, (Service)new PostgreSQLMetricsQueryDAO(this.postgresqlClient));
        this.registerServiceImplementation(ITraceQueryDAO.class, (Service)new PostgreSQLTraceQueryDAO(this.getManager(), this.postgresqlClient, this.config.getMaxSizeOfArrayColumn(), this.config.getNumOfSearchableValuesPerTag()));
        this.registerServiceImplementation(IBrowserLogQueryDAO.class, (Service)new PostgreSQLBrowserLogQueryDAO(this.postgresqlClient));
        this.registerServiceImplementation(IMetadataQueryDAO.class, (Service)new H2MetadataQueryDAO(this.postgresqlClient, this.config.getMetadataQueryMaxSize()));
        this.registerServiceImplementation(IAggregationQueryDAO.class, (Service)new PostgreSQLAggregationQueryDAO(this.postgresqlClient));
        this.registerServiceImplementation(IAlarmQueryDAO.class, (Service)new PostgreSQLAlarmQueryDAO(this.postgresqlClient, this.getManager(), this.config.getMaxSizeOfArrayColumn(), this.config.getNumOfSearchableValuesPerTag()));
        this.registerServiceImplementation(IHistoryDeleteDAO.class, (Service)new H2HistoryDeleteDAO(this.postgresqlClient));
        this.registerServiceImplementation(ITopNRecordsQueryDAO.class, (Service)new H2TopNRecordsQueryDAO(this.postgresqlClient));
        this.registerServiceImplementation(ILogQueryDAO.class, (Service)new PostgreSQLLogQueryDAO(this.postgresqlClient, this.getManager(), this.config.getMaxSizeOfArrayColumn(), this.config.getNumOfSearchableValuesPerTag()));
        this.registerServiceImplementation(IProfileTaskQueryDAO.class, (Service)new H2ProfileTaskQueryDAO(this.postgresqlClient));
        this.registerServiceImplementation(IProfileTaskLogQueryDAO.class, (Service)new H2ProfileTaskLogQueryDAO(this.postgresqlClient));
        this.registerServiceImplementation(IProfileThreadSnapshotQueryDAO.class, (Service)new H2ProfileThreadSnapshotQueryDAO(this.postgresqlClient));
        this.registerServiceImplementation(UITemplateManagementDAO.class, (Service)new H2UITemplateManagementDAO(this.postgresqlClient));
        this.registerServiceImplementation(IEventQueryDAO.class, (Service)new H2EventQueryDAO(this.postgresqlClient));
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        ConfigService configService = (ConfigService)this.getManager().find("core").provider().getService(ConfigService.class);
        int numOfSearchableTags = configService.getSearchableTracesTags().split(",").length;
        if (numOfSearchableTags * this.config.getNumOfSearchableValuesPerTag() > this.config.getMaxSizeOfArrayColumn()) {
            throw new ModuleStartException("Size of searchableTracesTags[" + numOfSearchableTags + "] * numOfSearchableValuesPerTag[" + this.config.getNumOfSearchableValuesPerTag() + "] > maxSizeOfArrayColumn[" + this.config.getMaxSizeOfArrayColumn() + "]. Potential out of bound in the runtime.");
        }
        int numOfSearchableLogsTags = configService.getSearchableLogsTags().split(",").length;
        if (numOfSearchableLogsTags * this.config.getNumOfSearchableValuesPerTag() > this.config.getMaxSizeOfArrayColumn()) {
            throw new ModuleStartException("Size of searchableLogsTags[" + numOfSearchableLogsTags + "] * numOfSearchableValuesPerTag[" + this.config.getNumOfSearchableValuesPerTag() + "] > maxSizeOfArrayColumn[" + this.config.getMaxSizeOfArrayColumn() + "]. Potential out of bound in the runtime.");
        }
        int numOfSearchableAlarmTags = configService.getSearchableAlarmTags().split(",").length;
        if (numOfSearchableAlarmTags * this.config.getNumOfSearchableValuesPerTag() > this.config.getMaxSizeOfArrayColumn()) {
            throw new ModuleStartException("Size of searchableAlarmTags[" + numOfSearchableAlarmTags + "] * numOfSearchableValuesPerTag[" + this.config.getNumOfSearchableValuesPerTag() + "] > maxSizeOfArrayColumn[" + this.config.getMaxSizeOfArrayColumn() + "]. Potential out of bound in the runtime.");
        }
        try {
            this.postgresqlClient.connect();
            PostgreSQLTableInstaller installer = new PostgreSQLTableInstaller((Client)this.postgresqlClient, this.getManager(), this.config.getMaxSizeOfArrayColumn(), this.config.getNumOfSearchableValuesPerTag());
            ((ModelCreator)this.getManager().find("core").provider().getService(ModelCreator.class)).addModelListener((ModelCreator.CreatingListener)installer);
        }
        catch (StorageException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

