/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql;

import com.google.gson.JsonObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.model.ExtraQueryIndex;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.jdbc.JDBCClientException;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLBuilder;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.TableMetaInfo;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TableInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLTableInstaller
extends H2TableInstaller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLTableInstaller.class);

    public MySQLTableInstaller(Client client, ModuleManager moduleManager, int maxSizeOfArrayColumn, int numOfSearchableValuesPerTag) {
        super(client, moduleManager, maxSizeOfArrayColumn, numOfSearchableValuesPerTag);
        this.overrideColumnName("precision", "cal_precision");
        this.overrideColumnName("match", "match_num");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean isExists(Model model) throws StorageException {
        TableMetaInfo.addModel(model);
        JDBCHikariCPClient h2Client = (JDBCHikariCPClient)this.client;
        try (Connection conn = h2Client.getConnection();
             ResultSet rset = conn.getMetaData().getTables(conn.getCatalog(), null, model.getName(), null);){
            if (!rset.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException | JDBCClientException e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    @Override
    protected void createTableIndexes(JDBCHikariCPClient client, Connection connection, Model model) throws JDBCClientException {
        int indexSeq = 0;
        for (ModelColumn modelColumn : model.getColumns()) {
            if (modelColumn.isStorageOnly() || modelColumn.getLength() >= 256) continue;
            Class type = modelColumn.getType();
            if (List.class.isAssignableFrom(type)) {
                for (int i = 0; i < this.maxSizeOfArrayColumn; ++i) {
                    SQLBuilder tableIndexSQL = new SQLBuilder("CREATE INDEX ");
                    tableIndexSQL.append(model.getName().toUpperCase()).append("_").append(String.valueOf(indexSeq++)).append("_IDX ");
                    tableIndexSQL.append("ON ").append(model.getName()).append("(").append(modelColumn.getColumnName().getStorageName() + "_" + i).append(")");
                    this.createIndex(client, connection, model, tableIndexSQL);
                }
                continue;
            }
            SQLBuilder tableIndexSQL = new SQLBuilder("CREATE INDEX ");
            tableIndexSQL.append(model.getName().toUpperCase()).append("_").append(String.valueOf(indexSeq++)).append("_IDX ");
            tableIndexSQL.append("ON ").append(model.getName()).append("(").append(modelColumn.getColumnName().getStorageName()).append(")");
            this.createIndex(client, connection, model, tableIndexSQL);
        }
        for (ExtraQueryIndex extraQueryIndex : model.getExtraQueryIndices()) {
            SQLBuilder tableIndexSQL = new SQLBuilder("CREATE INDEX ");
            tableIndexSQL.append(model.getName().toUpperCase()).append("_").append(String.valueOf(indexSeq++)).append("_IDX ");
            tableIndexSQL.append(" ON ").append(model.getName()).append("(");
            String[] columns = extraQueryIndex.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                tableIndexSQL.append(columns[i]);
                if (i >= columns.length - 1) continue;
                tableIndexSQL.append(",");
            }
            tableIndexSQL.append(")");
            this.createIndex(client, connection, model, tableIndexSQL);
        }
    }

    @Override
    protected String getColumn(ModelColumn column) {
        String storageName = column.getColumnName().getStorageName();
        Class type = column.getType();
        if (StorageDataComplexObject.class.isAssignableFrom(type)) {
            return storageName + " MEDIUMTEXT";
        }
        if (String.class.equals((Object)type)) {
            if (column.getLength() > 16383) {
                return storageName + " MEDIUMTEXT";
            }
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        if (JsonObject.class.equals((Object)type)) {
            if (column.getLength() > 16383) {
                return storageName + " MEDIUMTEXT";
            }
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        return super.getColumn(column);
    }
}

