/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.query.type.BasicTrace;
import org.apache.skywalking.oap.server.core.query.type.QueryOrder;
import org.apache.skywalking.oap.server.core.query.type.Span;
import org.apache.skywalking.oap.server.core.query.type.TraceBrief;
import org.apache.skywalking.oap.server.core.query.type.TraceState;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.elasticsearch.search.sort.SortOrder;

public class H2TraceQueryDAO
implements ITraceQueryDAO {
    private ModuleManager manager;
    private JDBCHikariCPClient h2Client;
    private List<String> searchableTagKeys;
    private int maxSizeOfArrayColumn;
    private int numOfSearchableValuesPerTag;

    public H2TraceQueryDAO(ModuleManager manager, JDBCHikariCPClient h2Client, int maxSizeOfArrayColumn, int numOfSearchableValuesPerTag) {
        this.h2Client = h2Client;
        this.manager = manager;
        this.maxSizeOfArrayColumn = maxSizeOfArrayColumn;
        this.numOfSearchableValuesPerTag = numOfSearchableValuesPerTag;
    }

    public TraceBrief queryBasicTraces(long startSecondTB, long endSecondTB, long minDuration, long maxDuration, String endpointName, String serviceId, String serviceInstanceId, String endpointId, String traceId, int limit, int from, TraceState traceState, QueryOrder queryOrder, List<Tag> tags) throws IOException {
        if (this.searchableTagKeys == null) {
            ConfigService configService = (ConfigService)this.manager.find("core").provider().getService(ConfigService.class);
            this.searchableTagKeys = Arrays.asList(configService.getSearchableTracesTags().split(","));
            if (this.searchableTagKeys.size() > this.maxSizeOfArrayColumn) {
                this.searchableTagKeys = this.searchableTagKeys.subList(0, this.maxSizeOfArrayColumn);
            }
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(10);
        sql.append("from ").append("segment").append(" where ");
        sql.append(" 1=1 ");
        if (startSecondTB != 0L && endSecondTB != 0L) {
            sql.append(" and ").append("time_bucket").append(" >= ?");
            parameters.add(startSecondTB);
            sql.append(" and ").append("time_bucket").append(" <= ?");
            parameters.add(endSecondTB);
        }
        if (minDuration != 0L) {
            sql.append(" and ").append("latency").append(" >= ?");
            parameters.add(minDuration);
        }
        if (maxDuration != 0L) {
            sql.append(" and ").append("latency").append(" <= ?");
            parameters.add(maxDuration);
        }
        if (!Strings.isNullOrEmpty((String)endpointName)) {
            sql.append(" and ").append("endpoint_name").append(" like concat('%',?,'%')");
            parameters.add(endpointName);
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            sql.append(" and ").append("service_id").append(" = ?");
            parameters.add(serviceId);
        }
        if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
            sql.append(" and ").append("service_instance_id").append(" = ?");
            parameters.add(serviceInstanceId);
        }
        if (!Strings.isNullOrEmpty((String)endpointId)) {
            sql.append(" and ").append("endpoint_id").append(" = ?");
            parameters.add(endpointId);
        }
        if (!Strings.isNullOrEmpty((String)traceId)) {
            sql.append(" and ").append("trace_id").append(" = ?");
            parameters.add(traceId);
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            for (Tag tag : tags) {
                int foundIdx = this.searchableTagKeys.indexOf(tag.getKey());
                if (foundIdx > -1) {
                    sql.append(" and (");
                    for (int i = 0; i < this.numOfSearchableValuesPerTag; ++i) {
                        String physicalColumn = "tags_" + (foundIdx * this.numOfSearchableValuesPerTag + i);
                        sql.append(physicalColumn).append(" = ? ");
                        parameters.add(tag.toString());
                        if (i == this.numOfSearchableValuesPerTag - 1) continue;
                        sql.append(" or ");
                    }
                    sql.append(")");
                    continue;
                }
                return new TraceBrief();
            }
        }
        switch (traceState) {
            case ERROR: {
                sql.append(" and ").append("is_error").append(" = ").append(1);
                break;
            }
            case SUCCESS: {
                sql.append(" and ").append("is_error").append(" = ").append(0);
            }
        }
        switch (queryOrder) {
            case BY_START_TIME: {
                sql.append(" order by ").append("start_time").append(" ").append(SortOrder.DESC);
                break;
            }
            case BY_DURATION: {
                sql.append(" order by ").append("latency").append(" ").append(SortOrder.DESC);
            }
        }
        TraceBrief traceBrief = new TraceBrief();
        try (Connection connection = this.h2Client.getConnection();){
            try (ResultSet resultSet = this.h2Client.executeQuery(connection, this.buildCountStatement(sql.toString()), parameters.toArray(new Object[0]));){
                while (resultSet.next()) {
                    traceBrief.setTotal(resultSet.getInt("total"));
                }
            }
            this.buildLimit(sql, from, limit);
            resultSet = this.h2Client.executeQuery(connection, "select segment_id, start_time, endpoint_name, latency, is_error, trace_id " + sql, parameters.toArray(new Object[0]));
            var25_26 = null;
            try {
                while (resultSet.next()) {
                    BasicTrace basicTrace = new BasicTrace();
                    basicTrace.setSegmentId(resultSet.getString("segment_id"));
                    basicTrace.setStart(resultSet.getString("start_time"));
                    basicTrace.getEndpointNames().add(resultSet.getString("endpoint_name"));
                    basicTrace.setDuration(resultSet.getInt("latency"));
                    basicTrace.setError(BooleanUtils.valueToBoolean((int)resultSet.getInt("is_error")));
                    String traceIds = resultSet.getString("trace_id");
                    basicTrace.getTraceIds().add(traceIds);
                    traceBrief.getTraces().add(basicTrace);
                }
            }
            catch (Throwable throwable) {
                var25_26 = throwable;
                throw throwable;
            }
            finally {
                if (resultSet != null) {
                    if (var25_26 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            var25_26.addSuppressed(throwable);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return traceBrief;
    }

    protected String buildCountStatement(String sql) {
        return "select count(1) total from (select 1 " + sql + " )";
    }

    protected void buildLimit(StringBuilder sql, int from, int limit) {
        sql.append(" LIMIT ").append(limit);
        sql.append(" OFFSET ").append(from);
    }

    public List<SegmentRecord> queryByTraceId(String traceId) throws IOException {
        ArrayList<SegmentRecord> segmentRecords = new ArrayList<SegmentRecord>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, "select segment_id, trace_id, service_id, service_instance_id, endpoint_name, start_time, end_time, latency, is_error, data_binary, version from segment where trace_id = ?", new Object[]{traceId});){
            while (resultSet.next()) {
                SegmentRecord segmentRecord = new SegmentRecord();
                segmentRecord.setSegmentId(resultSet.getString("segment_id"));
                segmentRecord.setTraceId(resultSet.getString("trace_id"));
                segmentRecord.setServiceId(resultSet.getString("service_id"));
                segmentRecord.setServiceInstanceId(resultSet.getString("service_instance_id"));
                segmentRecord.setEndpointName(resultSet.getString("endpoint_name"));
                segmentRecord.setStartTime(resultSet.getLong("start_time"));
                segmentRecord.setEndTime(resultSet.getLong("end_time"));
                segmentRecord.setLatency(resultSet.getInt("latency"));
                segmentRecord.setIsError(resultSet.getInt("is_error"));
                String dataBinaryBase64 = resultSet.getString("data_binary");
                if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
                    segmentRecord.setDataBinary(Base64.getDecoder().decode(dataBinaryBase64));
                }
                segmentRecord.setVersion(resultSet.getInt("version"));
                segmentRecords.add(segmentRecord);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return segmentRecords;
    }

    public List<Span> doFlexibleTraceQuery(String traceId) {
        return Collections.emptyList();
    }
}

