/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.gson.JsonObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.NodeType;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.model.ModelInstaller;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.jdbc.JDBCClientException;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLBuilder;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.TableMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2TableInstaller
extends ModelInstaller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(H2TableInstaller.class);
    public static final String ID_COLUMN = "id";
    protected final int maxSizeOfArrayColumn;
    protected final int numOfSearchableValuesPerTag;

    public H2TableInstaller(Client client, ModuleManager moduleManager, int maxSizeOfArrayColumn, int numOfSearchableValuesPerTag) {
        super(client, moduleManager);
        this.maxSizeOfArrayColumn = maxSizeOfArrayColumn;
        this.numOfSearchableValuesPerTag = numOfSearchableValuesPerTag;
    }

    protected boolean isExists(Model model) throws StorageException {
        TableMetaInfo.addModel(model);
        return false;
    }

    protected void createTable(Model model) throws StorageException {
        JDBCHikariCPClient jdbcHikariCPClient = (JDBCHikariCPClient)this.client;
        try (Connection connection = jdbcHikariCPClient.getConnection();){
            SQLBuilder tableCreateSQL = new SQLBuilder("CREATE TABLE IF NOT EXISTS " + model.getName() + " (");
            tableCreateSQL.appendLine("id VARCHAR(512) PRIMARY KEY, ");
            for (int i = 0; i < model.getColumns().size(); ++i) {
                ModelColumn column = (ModelColumn)model.getColumns().get(i);
                tableCreateSQL.appendLine(this.getColumn(column) + (i != model.getColumns().size() - 1 ? "," : ""));
            }
            tableCreateSQL.appendLine(")");
            if (log.isDebugEnabled()) {
                log.debug("creating table: " + tableCreateSQL.toStringInNewLine());
            }
            jdbcHikariCPClient.execute(connection, tableCreateSQL.toString());
            this.createTableIndexes(jdbcHikariCPClient, connection, model);
        }
        catch (SQLException | JDBCClientException e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    protected String getColumn(ModelColumn column) {
        return this.transform(column, column.getType(), column.getGenericType());
    }

    protected String transform(ModelColumn column, Class<?> type, Type genericType) {
        String storageName = column.getColumnName().getStorageName();
        if (Integer.class.equals(type) || Integer.TYPE.equals(type) || NodeType.class.equals(type)) {
            return storageName + " INT";
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return storageName + " BIGINT";
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return storageName + " DOUBLE";
        }
        if (String.class.equals(type)) {
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        if (StorageDataComplexObject.class.isAssignableFrom(type)) {
            return storageName + " VARCHAR(20000)";
        }
        if (byte[].class.equals(type)) {
            return storageName + " MEDIUMTEXT";
        }
        if (JsonObject.class.equals(type)) {
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        if (List.class.isAssignableFrom(type)) {
            Type elementType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            String oneColumnType = this.transform(column, (Class)elementType, elementType);
            oneColumnType = oneColumnType.substring(storageName.length());
            StringBuilder columns = new StringBuilder();
            for (int i = 0; i < this.maxSizeOfArrayColumn; ++i) {
                columns.append(storageName).append("_").append(i).append(oneColumnType).append(i == this.maxSizeOfArrayColumn - 1 ? "" : ",");
            }
            return columns.toString();
        }
        throw new IllegalArgumentException("Unsupported data type: " + type.getName());
    }

    protected void createTableIndexes(JDBCHikariCPClient client, Connection connection, Model model) throws JDBCClientException {
    }

    protected void createIndex(JDBCHikariCPClient client, Connection connection, Model model, SQLBuilder indexSQL) throws JDBCClientException {
        if (log.isDebugEnabled()) {
            log.debug("create index for table {}, sql: {} ", (Object)model.getName(), (Object)indexSQL.toStringInNewLine());
        }
        client.execute(connection, indexSQL.toString());
    }
}

