/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.config.NoneStream;
import org.apache.skywalking.oap.server.core.analysis.management.ManagementData;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.storage.IManagementDAO;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.INoneStreamDAO;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageHashMapBuilder;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2MetricsDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2NoneStreamDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2RecordDAO;

public class H2StorageDAO
implements StorageDAO {
    private final ModuleManager manager;
    private final JDBCHikariCPClient h2Client;
    private final int maxSizeOfArrayColumn;
    private final int numOfSearchableValuesPerTag;

    public IMetricsDAO newMetricsDao(StorageBuilder storageBuilder) {
        return new H2MetricsDAO(this.h2Client, (StorageHashMapBuilder<Metrics>)((StorageHashMapBuilder)storageBuilder));
    }

    public IRecordDAO newRecordDao(StorageBuilder storageBuilder) {
        return new H2RecordDAO(this.manager, this.h2Client, (StorageHashMapBuilder<Record>)((StorageHashMapBuilder)storageBuilder), this.maxSizeOfArrayColumn, this.numOfSearchableValuesPerTag);
    }

    public INoneStreamDAO newNoneStreamDao(StorageBuilder storageBuilder) {
        return new H2NoneStreamDAO(this.h2Client, (StorageHashMapBuilder<NoneStream>)((StorageHashMapBuilder)storageBuilder));
    }

    public IManagementDAO newManagementDao(StorageBuilder storageBuilder) {
        return new H2ManagementDAO(this.h2Client, (StorageHashMapBuilder<ManagementData>)((StorageHashMapBuilder)storageBuilder));
    }

    @Generated
    public H2StorageDAO(ModuleManager manager, JDBCHikariCPClient h2Client, int maxSizeOfArrayColumn, int numOfSearchableValuesPerTag) {
        this.manager = manager;
        this.h2Client = h2Client;
        this.maxSizeOfArrayColumn = maxSizeOfArrayColumn;
        this.numOfSearchableValuesPerTag = numOfSearchableValuesPerTag;
    }
}

