/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joptsimple.internal.Strings;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.AbstractSearchTagBuilder;

public class H2SegmentRecordBuilder
extends AbstractSearchTagBuilder<Record> {
    public H2SegmentRecordBuilder(int maxSizeOfArrayColumn, int numOfSearchableValuesPerTag, List<String> searchTagKeys) {
        super(maxSizeOfArrayColumn, numOfSearchableValuesPerTag, searchTagKeys, "tags");
    }

    public Map<String, Object> entity2Storage(Record record) {
        SegmentRecord storageData = (SegmentRecord)record;
        storageData.setStatement(Strings.join((String[])new String[]{storageData.getEndpointName(), storageData.getTraceId()}, (String)" - "));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("segment_id", storageData.getSegmentId());
        map.put("trace_id", storageData.getTraceId());
        map.put("statement", storageData.getStatement());
        map.put("service_id", storageData.getServiceId());
        map.put("service_instance_id", storageData.getServiceInstanceId());
        map.put("endpoint_name", storageData.getEndpointName());
        map.put("endpoint_id", storageData.getEndpointId());
        map.put("start_time", storageData.getStartTime());
        map.put("end_time", storageData.getEndTime());
        map.put("latency", storageData.getLatency());
        map.put("is_error", storageData.getIsError());
        map.put("time_bucket", storageData.getTimeBucket());
        if (CollectionUtils.isEmpty((byte[])storageData.getDataBinary())) {
            map.put("data_binary", "");
        } else {
            map.put("data_binary", new String(Base64.getEncoder().encode(storageData.getDataBinary())));
        }
        map.put("version", storageData.getVersion());
        this.analysisSearchTag(storageData.getTagsRawData(), map);
        return map;
    }

    public Record storage2Entity(Map<String, Object> dbMap) {
        SegmentRecord record = new SegmentRecord();
        record.setSegmentId((String)dbMap.get("segment_id"));
        record.setTraceId((String)dbMap.get("trace_id"));
        record.setStatement((String)dbMap.get("statement"));
        record.setServiceId((String)dbMap.get("service_id"));
        record.setServiceInstanceId((String)dbMap.get("service_instance_id"));
        record.setEndpointName((String)dbMap.get("endpoint_name"));
        record.setEndpointId((String)dbMap.get("endpoint_id"));
        record.setStartTime(((Number)dbMap.get("start_time")).longValue());
        record.setEndTime(((Number)dbMap.get("end_time")).longValue());
        record.setLatency(((Number)dbMap.get("latency")).intValue());
        record.setIsError(((Number)dbMap.get("is_error")).intValue());
        record.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
        if (StringUtil.isEmpty((String)((String)dbMap.get("data_binary")))) {
            record.setDataBinary(new byte[0]);
        } else {
            record.setDataBinary(Base64.getDecoder().decode((String)dbMap.get("data_binary")));
        }
        record.setVersion(((Number)dbMap.get("version")).intValue());
        return record;
    }
}

