/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.alarm.AlarmRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.log.LogRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.StorageHashMapBuilder;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2AlarmRecordBuilder;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2LogRecordBuilder;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SQLExecutor;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SegmentRecordBuilder;

public class H2RecordDAO
extends H2SQLExecutor
implements IRecordDAO {
    private JDBCHikariCPClient h2Client;
    private StorageHashMapBuilder<Record> storageBuilder;
    private final int maxSizeOfArrayColumn;

    public H2RecordDAO(ModuleManager manager, JDBCHikariCPClient h2Client, StorageHashMapBuilder<Record> storageBuilder, int maxSizeOfArrayColumn, int numOfSearchableValuesPerTag) {
        this.h2Client = h2Client;
        try {
            if (SegmentRecord.class.equals(storageBuilder.getClass().getMethod("storage2Entity", Map.class).getReturnType())) {
                this.maxSizeOfArrayColumn = maxSizeOfArrayColumn;
                ConfigService configService = (ConfigService)manager.find("core").provider().getService(ConfigService.class);
                this.storageBuilder = new H2SegmentRecordBuilder(maxSizeOfArrayColumn, numOfSearchableValuesPerTag, Arrays.asList(configService.getSearchableTracesTags().split(",")));
            } else if (LogRecord.class.equals(storageBuilder.getClass().getMethod("storage2Entity", Map.class).getReturnType())) {
                this.maxSizeOfArrayColumn = maxSizeOfArrayColumn;
                ConfigService configService = (ConfigService)manager.find("core").provider().getService(ConfigService.class);
                this.storageBuilder = new H2LogRecordBuilder(maxSizeOfArrayColumn, numOfSearchableValuesPerTag, Arrays.asList(configService.getSearchableLogsTags().split(",")));
            } else if (AlarmRecord.class.equals(storageBuilder.getClass().getMethod("storage2Entity", Map.class).getReturnType())) {
                this.maxSizeOfArrayColumn = maxSizeOfArrayColumn;
                ConfigService configService = (ConfigService)manager.find("core").provider().getService(ConfigService.class);
                this.storageBuilder = new H2AlarmRecordBuilder(maxSizeOfArrayColumn, numOfSearchableValuesPerTag, Arrays.asList(configService.getSearchableAlarmTags().split(",")));
            } else {
                this.maxSizeOfArrayColumn = 1;
                this.storageBuilder = storageBuilder;
            }
        }
        catch (NoSuchMethodException e) {
            throw new UnexpectedException("Can't find the SegmentRecord$Builder.map2Data method.");
        }
    }

    public InsertRequest prepareBatchInsert(Model model, Record record) throws IOException {
        return this.getInsertExecutor(model.getName(), record, this.storageBuilder, this.maxSizeOfArrayColumn);
    }
}

