/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.skywalking.oap.server.core.analysis.config.NoneStream;
import org.apache.skywalking.oap.server.core.storage.INoneStreamDAO;
import org.apache.skywalking.oap.server.core.storage.StorageHashMapBuilder;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SQLExecutor;

public class H2NoneStreamDAO
extends H2SQLExecutor
implements INoneStreamDAO {
    private JDBCHikariCPClient h2Client;
    private StorageHashMapBuilder<NoneStream> storageBuilder;

    public H2NoneStreamDAO(JDBCHikariCPClient h2Client, StorageHashMapBuilder<NoneStream> storageBuilder) {
        this.h2Client = h2Client;
        this.storageBuilder = storageBuilder;
    }

    public void insert(Model model, NoneStream noneStream) throws IOException {
        try (Connection connection = this.h2Client.getConnection();){
            SQLExecutor insertExecutor = this.getInsertExecutor(model.getName(), noneStream, this.storageBuilder);
            insertExecutor.invoke(connection);
        }
        catch (IOException | SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

