/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.manual.log.LogRecord;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.AbstractSearchTagBuilder;

public class H2LogRecordBuilder
extends AbstractSearchTagBuilder<Record> {
    public H2LogRecordBuilder(int maxSizeOfArrayColumn, int numOfSearchableValuesPerTag, List<String> searchTagKeys) {
        super(maxSizeOfArrayColumn, numOfSearchableValuesPerTag, searchTagKeys, "tags");
    }

    public Record storage2Entity(Map<String, Object> dbMap) {
        LogRecord record = new LogRecord();
        record.setUniqueId((String)dbMap.get("unique_id"));
        record.setServiceId((String)dbMap.get("service_id"));
        record.setServiceInstanceId((String)dbMap.get("service_instance_id"));
        record.setEndpointId((String)dbMap.get("endpoint_id"));
        record.setEndpointName((String)dbMap.get("endpoint_name"));
        record.setTraceId((String)dbMap.get("trace_id"));
        record.setTraceSegmentId((String)dbMap.get("trace_segment_id"));
        record.setSpanId(((Number)dbMap.get("span_id")).intValue());
        record.setContentType(((Number)dbMap.get("content_type")).intValue());
        record.setContent((String)dbMap.get("content"));
        record.setTimestamp(((Number)dbMap.get("timestamp")).longValue());
        record.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
        if (StringUtil.isEmpty((String)((String)dbMap.get("tags_raw_data")))) {
            record.setTagsRawData(new byte[0]);
        } else {
            record.setTagsRawData(Base64.getDecoder().decode((String)dbMap.get("tags_raw_data")));
        }
        return record;
    }

    public Map<String, Object> entity2Storage(Record record) {
        LogRecord storageData = (LogRecord)record;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("unique_id", storageData.getUniqueId());
        map.put("service_id", storageData.getServiceId());
        map.put("service_instance_id", storageData.getServiceInstanceId());
        map.put("endpoint_id", storageData.getEndpointId());
        map.put("endpoint_name", storageData.getEndpointName());
        map.put("trace_id", storageData.getTraceId());
        map.put("trace_segment_id", storageData.getTraceSegmentId());
        map.put("span_id", storageData.getSpanId());
        map.put("time_bucket", storageData.getTimeBucket());
        map.put("content_type", storageData.getContentType());
        map.put("content", storageData.getContent());
        map.put("timestamp", storageData.getTimestamp());
        if (CollectionUtils.isEmpty((byte[])storageData.getTagsRawData())) {
            map.put("tags_raw_data", "");
        } else {
            map.put("tags_raw_data", new String(Base64.getEncoder().encode(storageData.getTagsRawData())));
        }
        this.analysisSearchTag(storageData.getTags(), map);
        return map;
    }
}

